/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import java.io.IOException;
import java.io.InputStream;

public final class HTMLUtil {
    public static String readString(InputStream in) throws IOException {
        StringBuffer ans = new StringBuffer();
        while (ans.length() == 0 && in.available() > 0) {
            int r = in.read();
            while (r != 60 && r != 62 && r != -1) {
                ans.append((char)r);
                r = in.read();
            }
        }
        return ans.toString();
    }

    private HTMLUtil() {
    }

    public static int getNumberOfLines(String s) {
        if (s == null) {
            return 0;
        }
        if (s.length() < 2) {
            return 0;
        }
        int NumberOfLines = 0;
        for (int st = 0; st < s.length() - 1; ++st) {
            if (s.charAt(st) == '\r') {
                if (s.charAt(st + 1) == '\n') continue;
                ++NumberOfLines;
                continue;
            }
            if (s.charAt(st) != '\n') continue;
            ++NumberOfLines;
        }
        if (s.charAt(s.length() - 1) == '\n' || s.charAt(s.length() - 1) == '\r') {
            ++NumberOfLines;
        }
        return NumberOfLines + 1;
    }

    public static String replaceLinesWithParagraphs(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() < 2) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        block4: for (int pos = 0; pos < s.length() - 1; ++pos) {
            char c = s.charAt(pos);
            switch (c) {
                case '\r': {
                    if (s.charAt(pos + 1) == '\n') continue block4;
                    sb.append("<BR>");
                    ++pos;
                    continue block4;
                }
                case '\n': {
                    sb.append("<BR>");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append(s.charAt(s.length() - 1));
        return sb.toString();
    }

    public static String makeStringHTMLSafe(String str) {
        StringBuffer s = new StringBuffer();
        block5: for (int pos = 0; pos < str.length(); ++pos) {
            char c = str.charAt(pos);
            switch (c) {
                case '<': {
                    s.append("&lt;");
                    continue block5;
                }
                case '>': {
                    s.append("&gt;");
                    continue block5;
                }
                case '\"': {
                    s.append("&quot;");
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        return s.toString();
    }

    public static String recoverHTML(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() < 3) {
            return str;
        }
        StringBuffer outs = new StringBuffer();
        for (int pos = 0; pos < str.length() - 3; ++pos) {
            if (str.startsWith("&lt;", pos)) {
                outs.append('<');
                pos += 3;
                continue;
            }
            if (str.startsWith("&gt;", pos)) {
                outs.append('>');
                pos += 3;
                continue;
            }
            if (str.startsWith("&quot;", pos)) {
                outs.append('\"');
                pos += 5;
                continue;
            }
            outs.append(str.charAt(pos));
        }
        for (int k = pos; k < str.length(); ++k) {
            outs.append(str.charAt(k));
        }
        return outs.toString();
    }
}

