/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.ServletCopyright;
import com.ondelette.servlet.webforum.ForumLocale;
import com.ondelette.servlet.webforum.ForumLocaleFactory;
import com.ondelette.servlet.webforum.Message;
import com.ondelette.servlet.webforum.MessageFolder;
import com.ondelette.servlet.webforum.MessageReference;
import com.ondelette.servlet.webforum.User;
import com.ondelette.servlet.webforum.UserList;
import com.ondelette.servlet.webforum.UserListFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public final class Forum {
    protected String mForumTitle;
    protected String mForumSubTitle;
    protected ForumLocale mForumLocale;
    protected long mSaveDelay;
    protected int mPostPrivilege = 0;
    protected MessageFolder mMessageFolder;
    protected UserList mUserList;
    protected File mMessageArchiveDirectory;
    protected File mConfigFile;
    protected File mForumLocaleFile;
    protected File mUserListFile;
    protected int mAuthorizationLevel = 0;
    protected String mForumFooter;
    protected String mWelcomeURL;
    protected String mCSSURL;

    public Forum(File forumconfigfile) throws IOException {
        Properties p = new Properties();
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(forumconfigfile));
        p.load(fis);
        fis.close();
        this.mConfigFile = forumconfigfile;
        this.mMessageArchiveDirectory = new File(p.getProperty("MessageArchiveDirectory"));
        this.mForumLocaleFile = new File(p.getProperty("ForumLocaleFile"));
        this.mUserListFile = new File(p.getProperty("UserListFile"));
        try {
            this.mSaveDelay = Long.parseLong(p.getProperty("SaveDelay"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mCSSURL = p.getProperty("CSSURL");
        if (this.mCSSURL == null) {
            this.mCSSURL = "";
        }
        this.mForumTitle = p.getProperty("ForumTitle");
        if (this.mForumTitle == null) {
            this.mForumTitle = "";
        }
        this.mForumSubTitle = p.getProperty("ForumSubTitle");
        if (this.mForumSubTitle == null) {
            this.mForumSubTitle = "";
        }
        try {
            this.mAuthorizationLevel = Integer.parseInt(p.getProperty("AuthorizationLevel"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mForumFooter = p.getProperty("ForumFooter");
        if (this.mForumFooter == null) {
            this.mForumFooter = "";
        }
        this.mWelcomeURL = p.getProperty("WelcomeURL");
        if (this.mWelcomeURL == null) {
            this.mWelcomeURL = "";
        }
        try {
            this.mPostPrivilege = Integer.parseInt(p.getProperty("PostPrivilege"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mForumLocale = ForumLocaleFactory.getForumLocale(this.mForumLocaleFile);
        this.mUserList = UserListFactory.getUserList(this.mUserListFile);
        this.mMessageFolder = new MessageFolder(this);
    }

    public void getPage(int k, PrintWriter out, User user, String ServletPath) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.printMenu(this, out, k, user, ServletPath);
        this.mMessageFolder.writePageSummaryHTML(k, out, ServletPath);
        this.mForumLocale.printMenu(this, out, k, user, ServletPath);
        if (this.mPostPrivilege > 0) {
            if (user != null && user.getAutorizationLevel() >= this.mPostPrivilege) {
                this.mForumLocale.printPostForm(this, out, user, ServletPath);
            }
        } else {
            this.mForumLocale.printPostForm(this, out, user, ServletPath);
        }
        this.mForumLocale.printButtons(this, out, user, ServletPath);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }

    public void getLastMessages(int k, PrintWriter out, User user, String ServletPath) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.printMenu(this, out, -1, user, ServletPath);
        this.mForumLocale.printBackToForum(out, this, ServletPath);
        this.mMessageFolder.writeLastMessagesSummaryHTML(k, out, ServletPath);
        this.mForumLocale.printMenu(this, out, -1, user, ServletPath);
        if (this.mPostPrivilege > 0) {
            if (user != null && user.getAutorizationLevel() >= this.mPostPrivilege) {
                this.mForumLocale.printPostForm(this, out, user, ServletPath);
            }
        } else {
            this.mForumLocale.printPostForm(this, out, user, ServletPath);
        }
        this.mForumLocale.printButtons(this, out, user, ServletPath);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }

    public MessageReference addMessage(String SubjectString, String MessageString, String AuthorString, String EmailString, User user) throws IOException {
        Message message = new Message(AuthorString, EmailString, SubjectString, MessageString);
        if (user != null) {
            message.setAutorizationLevel(user.getAutorizationLevel());
        }
        return this.addMessage(message);
    }

    public MessageReference addMessage(Message message) throws IOException {
        return this.mMessageFolder.addMessage(message);
    }

    public MessageReference addReply(int k, String SubjectString, String MessageString, String AuthorString, String EmailString, User user) throws IOException {
        Message message = new Message(AuthorString, EmailString, SubjectString, MessageString);
        message.setInReplyTo(k);
        if (user != null) {
            message.setAutorizationLevel(user.getAutorizationLevel());
        }
        return this.addMessage(message);
    }

    public void showMessage(int k, PrintWriter out, User user, String ServletPath) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.printMenu(this, out, -1, user, ServletPath);
        this.mForumLocale.printInFull(k, this, out, user, ServletPath);
        if (this.mPostPrivilege > 0) {
            if (user != null && user.getAutorizationLevel() >= this.mPostPrivilege) {
                this.mForumLocale.printReplyForm(k, this, out, user, ServletPath);
            }
        } else {
            this.mForumLocale.printReplyForm(k, this, out, user, ServletPath);
        }
        this.mForumLocale.printButtons(this, out, user, ServletPath);
        out.print(this.mForumFooter);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }

    public void deleteMessage(int k, PrintWriter out, User user, String ServletPath) throws IOException {
        this.mMessageFolder.deleteMessage(k);
        this.getPage(0, out, user, ServletPath);
    }

    public void askForConfirmationOnDeletingMessage(int k, PrintWriter out, User user, String ServletPath) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.printDeleteConfirmation(k, this, out, user, ServletPath);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }

    public void destroy() {
        this.mMessageFolder.destroy();
    }

    public void showWarningNameInUse(String name, PrintWriter out) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.showWarningNameInUse(name, out, this);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }

    public void showWarningPasswordsDontMatch(String name, PrintWriter out) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.showWarningNameInUse(name, out, this);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }

    public void showWarningAutorizationRequired(PrintWriter out) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.showWarningAutorizationRequired(out, this);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }

    public void showWarningCannotChangeAdmin(PrintWriter out) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.showWarningCannotChangeAdmin(out, this);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }

    public void displayUserList(PrintWriter out, String ServletPath) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.printUserList(this, out, ServletPath);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }

    public void displayUser(String name, PrintWriter out, String ServletPath) throws IOException {
        this.mForumLocale.printForumHeader(this, out);
        this.mForumLocale.printForumTitle(this, out);
        this.mForumLocale.printUser(this, name, out, ServletPath);
        out.print(this.mForumFooter);
        ServletCopyright.printFooter(out);
    }
}

