/*
 * Decompiled with CFR 0.152.
 */
package WBMPcreator;

import WBMPcreator.WBMPCustomFont;
import WBMPcreator.WBMPDimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;

public class WBMPfile {
    public static final int MIX_MODE_XOR = 1;
    public static final int MIX_MODE_AND = 2;
    public static final int MIX_MODE_OR = 3;
    public static final int MIX_MODE_NOT = 4;
    public static final int APPEND_MODE_DIVISION = 1;
    public static final int APPEND_MODE_CONTINUOUS = 2;
    protected int WBMPLength;
    protected int WBMPWidth;
    protected int[][] WBMPpic;
    protected Raster r;
    protected BufferedImage img;
    protected Graphics g;
    protected WBMPfile outFile;
    private String licenseExpires = "31.12.2099";
    private String licenseNumber = "LICENSE_FOR_VERSION_1_23";
    private String licenseOwner = "Unknown user";
    private static boolean isLicenseValid = false;
    public static final int LINE_POINT1 = 1;
    public static final int LINE_POINT2 = 2;
    public static final int LINE_POINT3 = 3;
    public static final int LINE_INT2_1 = 21;
    public static final int LINE_INT2_2 = 22;
    public static final int LINE_INT3_2 = 32;
    public static final int LINE_CHAIN3_1 = 131;
    public static final int LINE_CHAIN3_2 = 132;

    public WBMPfile() {
    }

    public WBMPfile(String filename) {
        this.openWBMPFile(filename);
    }

    public WBMPfile(int length, int width) {
        this.WBMPLength = length;
        this.WBMPWidth = width;
        this.createWBMPFile();
    }

    public WBMPfile(int length, int width, int[][] picData) {
        this.setWBMPLength(length);
        this.setWBMPWidth(width);
        this.createWBMPFile();
        this.WBMPpic = picData;
    }

    public void setWBMPLength(int newLength) {
        this.WBMPLength = newLength;
    }

    public int getWBMPLength() {
        return this.WBMPLength;
    }

    public void setWBMPWidth(int newWidth) {
        this.WBMPWidth = newWidth;
    }

    public int getWBMPWidth() {
        return this.WBMPWidth;
    }

    public void createWBMPFile() {
        this.WBMPpic = null;
        this.WBMPpic = new int[this.getExcNum(this.WBMPLength)][this.WBMPWidth];
        for (int i = 0; i < this.getExcNum(this.WBMPLength); ++i) {
            for (int j = 0; j < this.WBMPWidth; ++j) {
                this.WBMPpic[i][j] = 1;
            }
        }
    }

    public void destroyWBMPFile() {
        this.WBMPpic = null;
    }

    public void setElementAt(int X, int Y, int value) {
        try {
            this.WBMPpic[X][Y] = value;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getElementAt(int X, int Y) {
        return this.WBMPpic[X][Y];
    }

    public void saveWBMP2File(String filename) {
        WBMPfile wf = this;
        if (!isLicenseValid) {
            this.putCopyrightString(wf);
        }
        int excLen = this.getExcNum(this.WBMPLength);
        int excWid = this.WBMPWidth;
        int num2write = 0;
        int numInLine = excLen / 8;
        File saveFile = new File(filename);
        if (saveFile.exists()) {
            saveFile.delete();
        }
        try {
            FileOutputStream fos = new FileOutputStream(saveFile);
            fos.write(0);
            fos.write(0);
            fos.write(this.WBMPLength);
            fos.write(this.WBMPWidth);
            for (int i = 0; i < excWid; ++i) {
                for (int j = 0; j < numInLine; ++j) {
                    num2write = 0;
                    for (int k = 7; k >= 0; --k) {
                        if (wf.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                        num2write = (byte)(num2write + this.power2(k));
                    }
                    fos.write(num2write);
                }
            }
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public WBMPfile openWBMPFile(String filename) {
        File f1 = new File(filename);
        int numBytes = 0;
        int currentLine = 0;
        try {
            FileInputStream fis = new FileInputStream(f1);
            fis.read();
            fis.read();
            this.WBMPLength = fis.read();
            this.WBMPWidth = fis.read();
            this.createWBMPFile();
            numBytes = this.getExcNum(this.WBMPLength) / 8;
            int[] oneLine = new int[numBytes];
            for (currentLine = 0; currentLine < this.WBMPWidth; ++currentLine) {
                for (int i = 0; i < numBytes; ++i) {
                    oneLine[i] = fis.read();
                }
                this.convertBytes2Points(oneLine, numBytes, currentLine);
            }
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    protected int getExcNum(int oldNum) {
        int newNum = oldNum / 8;
        if (newNum * 8 == oldNum) {
            return oldNum;
        }
        return (newNum + 1) * 8;
    }

    protected int power2(int pow) {
        int retval = 1;
        for (int i = 0; i < pow; ++i) {
            retval *= 2;
        }
        return retval;
    }

    public void printWBMPImage() {
        WBMPfile wf = this;
        if (!isLicenseValid) {
            this.putCopyrightString(wf);
        }
        for (int j = 0; j < this.getWBMPWidth(); ++j) {
            for (int i = 0; i < this.getWBMPLength(); ++i) {
                System.out.print(wf.WBMPpic[i][j]);
            }
            System.out.println("\n");
        }
    }

    public void invertWBMPImage() {
        int i = 0;
        int j = 0;
        try {
            for (i = 0; i < this.getExcNum(this.WBMPLength); ++i) {
                for (j = 0; j < this.WBMPWidth; ++j) {
                    this.WBMPpic[i][j] = this.WBMPpic[i][j] == 0 ? 1 : 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void convertBytes2Points(int[] bytes, int bytesQuant, int index) {
        for (int i = 0; i < bytesQuant; ++i) {
            int tmpByte = bytes[i];
            if (tmpByte < 0) {
                tmpByte += 256;
            }
            for (int j = 7; j >= 0; --j) {
                this.WBMPpic[7 - j + 8 * i][index] = tmpByte / this.power2(j);
                if (tmpByte < this.power2(j)) continue;
                tmpByte -= this.power2(j);
            }
        }
    }

    public WBMPfile mix(WBMPfile layer1, int mixMode) {
        return this.mix(layer1, mixMode, 0, 0);
    }

    protected int xor(int n1, int n2) {
        if (n1 == n2) {
            return 1;
        }
        return 0;
    }

    protected int and(int n1, int n2) {
        if (n1 == 0 && n2 == 0) {
            return 0;
        }
        return 1;
    }

    protected int or(int n1, int n2) {
        if (n1 != 0 && n2 != 0) {
            return 1;
        }
        return 0;
    }

    protected int not(int n1, int n2) {
        int notn1 = n1 == 0 ? 1 : 0;
        return this.and(notn1, n2);
    }

    public WBMPfile mix(WBMPfile layer1, int mixMode, int X, int Y) {
        WBMPfile outFile = this;
        for (int i = 0; i < layer1.getWBMPLength(); ++i) {
            block7: for (int j = 0; j < layer1.getWBMPWidth(); ++j) {
                switch (mixMode) {
                    case 1: {
                        outFile.setElementAt(i + X, j + Y, this.xor(layer1.getElementAt(i, j), this.getElementAt(i + X, j + Y)));
                        continue block7;
                    }
                    case 2: {
                        outFile.setElementAt(i + X, j + Y, this.and(layer1.getElementAt(i, j), this.getElementAt(i + X, j + Y)));
                        continue block7;
                    }
                    case 3: {
                        outFile.setElementAt(i + X, j + Y, this.or(layer1.getElementAt(i, j), this.getElementAt(i + X, j + Y)));
                        continue block7;
                    }
                    case 4: {
                        outFile.setElementAt(i + X, j + Y, this.not(layer1.getElementAt(i, j), this.getElementAt(i + X, j + Y)));
                    }
                }
            }
        }
        return outFile;
    }

    protected WBMPfile text2WBMP(String text, Font textFont, int resX, int resY, int X, int Y) {
        this.prepareRaster(resX, resY);
        this.g.setFont(textFont);
        this.g.drawString(text, X, Y);
        this.copyDataToOutLayer();
        this.clearRaster();
        return this.outFile;
    }

    public void drawString(String text, int X, int Y, Font inFont) {
        this.mix(this.text2WBMP(text, inFont, this.WBMPLength, this.WBMPWidth, X, Y), 3);
    }

    public void drawLine(int x_1, int y_1, int x_2, int y_2) {
        this.drawLine10(x_1, y_1, x_2, y_2, 0);
    }

    public void drawOval(int x, int y, int length, int width, boolean isFilled) {
        this.drawOval10(x, y, length, width, 0, isFilled);
    }

    public void drawPoint(int x, int y, int color) {
        this.setElementAt(x, y, color);
    }

    public void drawRect(int x, int y, int length, int width, boolean isFilled) {
        this.drawRect10(x, y, length, width, 0, isFilled);
    }

    public void draw3DRect(int x, int y, int length, int width, boolean isFilled, boolean isRaised) {
        this.draw3DRect10(x, y, length, width, 0, isFilled, isRaised);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc10(x, y, width, height, startAngle, arcAngle, 0);
    }

    protected void prepareRaster(int resX, int resY) {
        this.outFile = new WBMPfile(resX, resY);
        this.img = new BufferedImage(resX, resY, 11);
        this.g = this.img.getGraphics();
    }

    protected void copyDataToOutLayer() {
        this.r = this.img.getData();
        int[] iArray = new int[1];
        for (int j = 0; j < this.WBMPLength; ++j) {
            for (int k = 0; k < this.WBMPWidth; ++k) {
                int[] jArray = this.r.getPixel(j, k, iArray);
                try {
                    if (jArray[0] != 0) {
                        this.outFile.setElementAt(j, k, 0);
                        continue;
                    }
                    this.outFile.setElementAt(j, k, 1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void clearRaster() {
        this.r = null;
        this.g = null;
        this.img = null;
    }

    public String getString() {
        WBMPfile wf = this;
        if (!isLicenseValid) {
            this.putCopyrightString(wf);
        }
        String str = "";
        str = String.valueOf(str).concat(String.valueOf('\u0000'));
        str = String.valueOf(str).concat(String.valueOf('\u0000'));
        int num2write = Integer.parseInt(String.valueOf(this.WBMPLength));
        str = String.valueOf(str).concat(String.valueOf((char)num2write));
        num2write = Integer.parseInt(String.valueOf(this.WBMPWidth));
        str = String.valueOf(str).concat(String.valueOf((char)num2write));
        int numInLine = this.getExcNum(this.WBMPLength) / 8;
        for (int i = 0; i < this.WBMPWidth; ++i) {
            for (int j = 0; j < numInLine; ++j) {
                num2write = 0;
                for (int k = 7; k >= 0; --k) {
                    if (wf.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                    num2write += this.power2(k);
                }
                str = String.valueOf(str).concat(String.valueOf((char)num2write));
            }
        }
        return str;
    }

    public WBMPfile rotate(int angle) {
        if (angle / 4 * 4 == angle) {
            return this;
        }
        if (angle / 2 * 2 == angle) {
            this.outFile = new WBMPfile(this.WBMPLength, this.WBMPWidth);
            for (int i = 0; i < this.WBMPLength; ++i) {
                for (int j = 0; j < this.WBMPWidth; ++j) {
                    this.outFile.setElementAt(this.WBMPLength - 1 - i, this.WBMPWidth - 1 - j, this.getElementAt(i, j));
                }
            }
        } else {
            this.outFile = new WBMPfile(this.WBMPWidth, this.WBMPLength);
            if (angle / 4 * 4 + 1 == angle) {
                for (int i = 0; i < this.WBMPWidth; ++i) {
                    for (int j = 0; j < this.WBMPLength; ++j) {
                        this.outFile.setElementAt(i, this.WBMPLength - 1 - j, this.getElementAt(j, i));
                    }
                }
            } else {
                for (int i = 0; i < this.WBMPWidth; ++i) {
                    for (int j = 0; j < this.WBMPLength; ++j) {
                        this.outFile.setElementAt(this.WBMPWidth - 1 - i, j, this.getElementAt(j, i));
                    }
                }
            }
        }
        return this.outFile;
    }

    public WBMPfile getRectArea(WBMPDimension area) {
        int xRem = this.getWBMPLength() - area.getX();
        int yRem = this.getWBMPWidth() - area.getY();
        if (xRem > area.getDimensionLength()) {
            xRem = area.getDimensionLength() - 1;
        }
        if (yRem > area.getDimensionWidth()) {
            yRem = area.getDimensionWidth() - 1;
        }
        this.outFile = new WBMPfile(xRem, yRem);
        try {
            int i_upper = area.getX();
            int j_upper = area.getY();
            for (int i = 0; i < xRem; ++i) {
                for (int j = 0; j < yRem; ++j) {
                    this.outFile.setElementAt(i, j, this.getElementAt(i + i_upper, j + j_upper));
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (!isLicenseValid) {
            this.putCopyrightString(this.outFile);
        }
        return this.outFile;
    }

    public PrintStream getStream() {
        WBMPfile wf = this;
        if (!isLicenseValid) {
            this.putCopyrightString(wf);
        }
        PrintStream ps = new PrintStream(System.out);
        int num2write = Integer.parseInt(String.valueOf(this.WBMPLength));
        ps.print((char)num2write);
        num2write = Integer.parseInt(String.valueOf(this.WBMPWidth));
        ps.print((char)num2write);
        int numInLine = this.getExcNum(this.WBMPLength) / 8;
        for (int i = 0; i < this.WBMPWidth; ++i) {
            for (int j = 0; j < numInLine; ++j) {
                num2write = 0;
                for (int k = 7; k >= 0; --k) {
                    if (wf.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                    num2write += this.power2(k);
                }
                ps.print((char)num2write);
            }
        }
        return ps;
    }

    public int[][] getWBMPpic() {
        WBMPfile wf = this;
        if (!isLicenseValid) {
            this.putCopyrightString(wf);
        }
        return wf.WBMPpic;
    }

    public boolean writeToOutputStream(OutputStream os) {
        WBMPfile wf = this;
        if (!isLicenseValid) {
            this.putCopyrightString(wf);
        }
        try {
            int num2write = Integer.parseInt(String.valueOf(this.WBMPLength));
            os.write(num2write);
            num2write = Integer.parseInt(String.valueOf(this.WBMPWidth));
            os.write(num2write);
            int numInLine = this.getExcNum(this.WBMPLength) / 8;
            for (int i = 0; i < this.WBMPWidth; ++i) {
                for (int j = 0; j < numInLine; ++j) {
                    num2write = 0;
                    for (int k = 7; k >= 0; --k) {
                        if (wf.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                        num2write += this.power2(k);
                    }
                    os.write(num2write);
                }
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    WBMPfile putCopyrightString(WBMPfile in) {
        WBMPfile out = in;
        int x = in.getWBMPLength();
        int y = in.getWBMPWidth();
        if (x < 35 || y < 7) {
            return out;
        }
        out.mix(WBMPCustomFont.getWBMPImage("(c) Max", 1), 1, x - 35, y - 7);
        return out;
    }

    private void drawRect10(int x, int y, int length, int width, int color, boolean isFilled) {
        if (isFilled) {
            for (int i = 0; i < length; ++i) {
                this.drawLine10(x + i, y, x + i, y + width, color);
            }
        } else {
            this.drawLine10(x, y, x + length, y, color);
            this.drawLine10(x, y, x, y + width, color);
            this.drawLine10(x + length, y, x + length, y + width, color);
            this.drawLine10(x, y + width, x + length, y + width, color);
        }
    }

    private void drawLine10(int x1, int y1, int x2, int y2, int color) {
        double lineLen = 0.0;
        int dx = x2 - x1;
        int dy = y2 - y1;
        lineLen = Math.sqrt(dx * dx + dy * dy);
        double cosX = (double)dx / lineLen;
        double sinY = (double)dy / lineLen;
        int i = 1;
        while ((long)i <= Math.round(lineLen)) {
            this.drawPoint((int)((long)x1 + Math.round((double)i * cosX)), (int)((long)y1 + Math.round((double)i * sinY)), color);
            ++i;
        }
    }

    private void drawPoint10(int x, int y, int color) {
        try {
            this.WBMPpic[x][y] = color;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void draw3DRect10(int x, int y, int length, int width, int color, boolean isFilled, boolean isRaised) {
        this.drawRect10(x, y, length, width, color, isFilled);
        if (isRaised) {
            this.drawLine10(x + length + 1, y + 1, x + length + 1, y + width + 1, color);
            this.drawLine10(x + 1, y + width + 1, x + length + 1, y + width + 1, color);
        }
    }

    public void drawCircle(int x, int y, int radius, int color, boolean isFilled) {
        if (isFilled) {
            for (int i = 0; i < 180; ++i) {
                int k = (int)((double)x + (double)radius * Math.cos(i));
                this.drawLine10(k, (int)((double)y + (double)radius * Math.sin(i)), k, (int)((double)y - (double)radius * Math.sin(i)), color);
            }
        } else {
            for (int i = 0; i < 360; ++i) {
                this.drawPoint10((int)((double)x + (double)radius * Math.cos(i)), (int)((double)y + (double)radius * Math.sin(i)), color);
            }
        }
    }

    private void drawOval10(int x, int y, int length, int width, int color, boolean isFilled) {
        int xCentre = x + length / 2;
        int yCentre = y + width / 2;
        if (isFilled) {
            for (int i = 0; i < 360; ++i) {
                int k = xCentre - (int)((double)length / (double)2 * Math.cos(i / 2));
                this.drawLine10(k, yCentre + (int)((double)width / (double)2 * Math.sin(i / 2)), k, yCentre - (int)((double)width / (double)2 * Math.sin(i / 2)), color);
            }
        } else {
            for (int i = 0; i < 360; ++i) {
                this.drawPoint10(xCentre + (int)((double)length / (double)2 * Math.cos(i)), yCentre - (int)((double)width / (double)2 * Math.sin(i)), color);
            }
        }
    }

    private void drawArc10(int x, int y, int length, int width, int startAngle, int arcAngle, int color) {
        int xCentre = x + length / 2;
        int yCentre = y + width / 2;
        for (int i = startAngle; i < arcAngle + 1; ++i) {
            this.drawPoint10(xCentre + (int)((double)(length / 2) * Math.cos(i)), yCentre - (int)((double)(width / 2) * Math.sin(i)), color);
        }
    }

    public void drawSpecialLine(int x1, int y1, int x2, int y2, int line_type, int color) {
        double lineLen = 0.0;
        int dx = x2 - x1;
        int dy = y2 - y1;
        lineLen = Math.sqrt(dx * dx + dy * dy);
        double cosX = (double)dx / lineLen;
        double sinY = (double)dy / lineLen;
        switch (line_type) {
            case 1: {
                int i = 1;
                while ((long)i <= Math.round(lineLen)) {
                    if (i / 2 * 2 == i) {
                        this.drawPoint((int)((long)x1 + Math.round((double)i * cosX)), (int)((long)y1 + Math.round((double)i * sinY)), color);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 1;
                while ((long)i <= Math.round(lineLen)) {
                    if (i / 3 * 3 == i) {
                        this.drawPoint((int)((long)x1 + Math.round((double)i * cosX)), (int)((long)y1 + Math.round((double)i * sinY)), color);
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 1;
                while ((long)i <= Math.round(lineLen)) {
                    if (i / 3 * 3 == i) {
                        this.drawPoint((int)((long)x1 + Math.round((double)i * cosX)), (int)((long)y1 + Math.round((double)i * sinY)), color);
                    }
                    ++i;
                }
                break;
            }
            case 21: {
                int i = 1;
                while ((long)i <= Math.round(lineLen)) {
                    if (i / 3 * 3 != i) {
                        this.drawPoint((int)((long)x1 + Math.round((double)i * cosX)), (int)((long)y1 + Math.round((double)i * sinY)), color);
                    }
                    ++i;
                }
                break;
            }
            case 22: {
                int i = 1;
                while ((long)i <= Math.round(lineLen)) {
                    if (i / 4 * 4 == i || i / 4 * 4 == i + 1) {
                        this.drawPoint((int)((long)x1 + Math.round((double)i * cosX)), (int)((long)y1 + Math.round((double)i * sinY)), color);
                    }
                    ++i;
                }
                break;
            }
            case 32: {
                int i = 1;
                while ((long)i <= Math.round(lineLen)) {
                    if (i - i / 5 * 5 < 3) {
                        this.drawPoint((int)((long)x1 + Math.round((double)i * cosX)), (int)((long)y1 + Math.round((double)i * sinY)), color);
                    }
                    ++i;
                }
                break;
            }
            case 131: {
                int i = 1;
                while ((long)i <= Math.round(lineLen)) {
                    int chain = i - i / 6 * 6;
                    if (chain < 3 || chain == 5) {
                        this.drawPoint((int)((long)x1 + Math.round((double)i * cosX)), (int)((long)y1 + Math.round((double)i * sinY)), color);
                    }
                    ++i;
                }
                break;
            }
            case 132: {
                int i = 1;
                while ((long)i <= Math.round(lineLen)) {
                    int chain = i - i / 8 * 8;
                    if (chain < 3 || chain == 5 || chain == 6) {
                        this.drawPoint((int)((long)x1 + Math.round((double)i * cosX)), (int)((long)y1 + Math.round((double)i * sinY)), color);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public WBMPfile(String url, int port) {
        try {
            String protocol = url.substring(0, url.indexOf("://"));
            String urlWithoutFile = url.substring(url.indexOf("://") + 3);
            String file = urlWithoutFile.substring(urlWithoutFile.indexOf("/"));
            urlWithoutFile = urlWithoutFile.substring(0, urlWithoutFile.indexOf("/"));
            URL wbmpInstance = new URL(protocol, urlWithoutFile, port, file);
            URLConnection uconn = wbmpInstance.openConnection();
            InputStream is = uconn.getInputStream();
            int k = is.available();
            byte[] buf = new byte[k];
            int len = is.read(buf);
            is.close();
            len = buf[2];
            if (len < 0) {
                len += 256;
            }
            this.setWBMPLength(len);
            len = buf[3];
            if (len < 0) {
                len += 256;
            }
            this.setWBMPWidth(len);
            this.createWBMPFile();
            int bufIndex = 3;
            int numBytes = this.getExcNum(this.WBMPLength) / 8;
            int[] oneLine = new int[numBytes];
            int currentLine = 0;
            for (currentLine = 0; currentLine < this.WBMPWidth; ++currentLine) {
                for (int i = 0; i < numBytes; ++i) {
                    oneLine[i] = buf[++bufIndex];
                }
                this.convertBytes2Points(oneLine, numBytes, currentLine);
            }
        }
        catch (Exception e) {
            this.WBMPLength = 96;
            this.WBMPWidth = 44;
            this.createWBMPFile();
        }
    }
}

