/*
 * Decompiled with CFR 0.152.
 */
package WBMPcreator;

import WBMPcreator.WBMPDimension;
import WBMPcreator.WBMPfile;
import java.awt.Font;
import java.util.Vector;

public class WBMPTable
extends WBMPfile {
    private String columnNames;
    private Vector columnData;
    private int tableColumns;
    private Font headerFont;
    private Font dataFont;
    private WBMPDimension tableSize;

    public WBMPTable() {
    }

    public WBMPTable(String newColumnNames, Vector newColumnData) {
        this.columnNames = newColumnNames;
        this.columnData = newColumnData;
    }

    public void setColumnNames(String newColumnNames) {
        this.columnNames = newColumnNames;
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnData(Vector newColumnData) {
        this.columnData = newColumnData;
    }

    public Vector getColumnData() {
        return this.columnData;
    }

    public void setHeaderFont(Font newHeaderFont) {
        this.headerFont = newHeaderFont;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setDataFont(Font newDataFont) {
        this.dataFont = newDataFont;
    }

    public Font getDataFont() {
        return this.dataFont;
    }

    public void setTableSize(WBMPDimension newTableSize) {
        this.tableSize = newTableSize;
    }

    public WBMPDimension getTableSize() {
        return this.tableSize;
    }

    public void saveWBMPTable(String filename, boolean headerOnEachPiece) {
        this.getWBMPTable(filename, headerOnEachPiece);
    }

    private void getWBMPTable(String filename, boolean headerOnEachPiece) {
        int xSizeAll = this.getTableSize().getDimensionLength();
        int headerY = this.getHeaderFont().getSize() + 2;
        int ySize = this.getTableSize().getDimensionWidth() - headerY;
        int ySizeAll = headerOnEachPiece ? ySize : this.getTableSize().getDimensionWidth();
        int linesQuantTotal = this.getColumnData().size();
        int linesSize = this.getDataFont().getSize() + 2;
        int linesQuantImage = ySize / linesSize;
        WBMPfile header = new WBMPfile(xSizeAll, headerY);
        header.drawRect(0, 0, xSizeAll - 1, headerY - 2, false);
        header.drawString(this.columnNames, 2, headerY - 3, this.headerFont);
        WBMPfile body = null;
        body = new WBMPfile(xSizeAll, headerY + linesQuantImage * linesSize);
        for (int i = 0; i < linesQuantImage; ++i) {
            body.drawString((String)this.getColumnData().elementAt(i), 2, headerY + (i + 1) * linesSize - 2, this.getDataFont());
        }
        int linesRead = linesQuantImage;
        body.drawRect(0, headerY, xSizeAll - 1, ySize - headerY, false);
        body.mix(header, 3, 0, 0);
        int imageQuant = 1;
        linesQuantImage = ySizeAll / linesSize;
        imageQuant = (this.columnData.size() - linesQuantImage) / linesQuantImage * linesQuantImage == this.columnData.size() - linesQuantImage ? (imageQuant += (this.columnData.size() - linesQuantImage) / linesQuantImage) : (imageQuant += (this.columnData.size() - linesQuantImage) / linesQuantImage + 1);
        body.saveWBMP2File(String.valueOf(String.valueOf(filename).concat(String.valueOf(0))).concat(String.valueOf(".wbmp")));
        for (int i = 1; i < imageQuant; ++i) {
            int j;
            body.createWBMPFile();
            if (headerOnEachPiece) {
                for (j = 0; j < linesQuantImage; ++j) {
                    if (linesRead == this.getColumnData().size()) continue;
                    body.drawString((String)this.getColumnData().elementAt(linesRead), 2, headerY + (j + 1) * linesSize - 2, this.getDataFont());
                    ++linesRead;
                }
                body.drawRect(0, headerY, xSizeAll - 1, ySize - headerY, false);
                body.mix(header, 3, 0, 0);
                body.saveWBMP2File(String.valueOf(String.valueOf(filename).concat(String.valueOf(i))).concat(String.valueOf(".wbmp")));
                continue;
            }
            for (j = 0; j < linesQuantImage; ++j) {
                if (linesRead == this.getColumnData().size()) continue;
                body.drawString((String)this.getColumnData().elementAt(linesRead), 2, 1 + (j + 1) * linesSize - 2, this.getDataFont());
                ++linesRead;
            }
            body.drawRect(0, 0, xSizeAll - 1, ySize, false);
            body.saveWBMP2File(String.valueOf(String.valueOf(filename).concat(String.valueOf(i))).concat(String.valueOf(".wbmp")));
        }
        body = null;
    }
}

