/*
 * Decompiled with CFR 0.152.
 */
package WBMPcreator;

import WBMPcreator.WBMPDimension;
import WBMPcreator.WBMPfile;
import java.awt.Font;
import java.util.Vector;

public class WBMPChart
extends WBMPfile {
    private Vector xData;
    private Vector yData;
    private String xCaption = "x";
    private String yCaption = "y";
    private Font axisFont = new Font("Courier", 0, 8);
    private Font dataFont = new Font("Arial", 0, 8);
    public static final int CHART_PLAIN = 1;
    public static final int CHART_POINT = 2;
    public static final int CHART_PLAIN_FILLED = 3;
    public static final int CHART_POINT_FILLED = 4;
    private static final int CHART_HISTOGRAM = 10;
    private static final int CHART_APPLEPIE_SIMPLE = 100;

    public WBMPChart(int xSize, int ySize) {
        this.setWBMPLength(xSize);
        this.setWBMPWidth(ySize);
        this.createWBMPFile();
    }

    public WBMPChart(WBMPDimension imageDim) {
        this.setWBMPLength(imageDim.getDimensionLength());
        this.setWBMPWidth(imageDim.getDimensionWidth());
        this.createWBMPFile();
    }

    public WBMPChart(WBMPfile wbmpFile) {
        this.WBMPpic = wbmpFile.getWBMPpic();
        this.WBMPLength = wbmpFile.getWBMPLength();
        this.WBMPWidth = wbmpFile.getWBMPWidth();
    }

    public WBMPfile drawChart(int chartMode) {
        WBMPfile wf = new WBMPfile(this.getWBMPLength(), this.getWBMPWidth(), this.getWBMPpic());
        switch (chartMode) {
            case 1: {
                this.drawChartPlain(wf);
                break;
            }
            case 2: {
                this.drawChartPoint(wf);
                break;
            }
            case 3: {
                this.drawChartPlainFilled(wf);
                break;
            }
            case 4: {
                this.drawChartPointFilled(wf);
                break;
            }
            case 10: {
                this.drawChartHistogram(wf);
                break;
            }
            case 100: {
                this.drawApplePie(wf);
            }
        }
        return wf;
    }

    private WBMPfile drawChartPlain(WBMPfile in) {
        WBMPfile out = in;
        this.drawAxis(in);
        int xSize = in.getWBMPLength() - 1;
        int ySize = in.getWBMPWidth() - 1;
        double xMin = this.getMinX();
        double yMin = this.getMinY();
        double xScale = (double)xSize / (this.getMaxX() - this.getMinX());
        double yScale = (double)ySize / (this.getMaxY() - this.getMinY());
        int oldX = 0;
        int oldY = 0;
        for (int i = 0; i < this.xData.size(); ++i) {
            int x = (int)(xScale * (Double.parseDouble((String)this.xData.get(i)) - xMin)) + 1;
            int y = ySize - (int)(yScale * (Double.parseDouble((String)this.yData.get(i)) - yMin));
            out.drawPoint(x, y, 0);
            if (i > 0) {
                out.drawLine(oldX, oldY, x, y);
            }
            oldX = x;
            oldY = y;
        }
        return out;
    }

    private WBMPfile drawChartPoint(WBMPfile in) {
        WBMPfile out = in;
        this.drawAxis(in);
        int xSize = in.getWBMPLength() - 3;
        int ySize = in.getWBMPWidth() - 2;
        double xMin = this.getMinX();
        double yMin = this.getMinY();
        double xScale = (double)xSize / (this.getMaxX() - this.getMinX());
        double yScale = (double)ySize / (this.getMaxY() - this.getMinY());
        for (int i = 0; i < this.xData.size(); ++i) {
            int x = (int)(xScale * (Double.parseDouble((String)this.xData.get(i)) - xMin)) + 1;
            int y = ySize - (int)(yScale * (Double.parseDouble((String)this.yData.get(i)) - yMin)) + 1;
            out.drawPoint(x, y, 0);
            out.drawPoint(x - 1, y - 1, 0);
            out.drawPoint(x + 1, y - 1, 0);
            out.drawPoint(x - 1, y + 1, 0);
            out.drawPoint(x + 1, y + 1, 0);
        }
        return out;
    }

    private WBMPfile drawChartPlainFilled(WBMPfile in) {
        WBMPfile out = in;
        this.drawAxis(in);
        int xSize = in.getWBMPLength() - 2;
        int ySize = in.getWBMPWidth() - 2;
        double xMin = this.getMinX();
        double yMin = this.getMinY();
        double xScale = (double)xSize / (this.getMaxX() - this.getMinX());
        double yScale = (double)ySize / (this.getMaxY() - this.getMinY());
        int oldX = 0;
        int oldY = 0;
        for (int i = 0; i < this.xData.size(); ++i) {
            int x = (int)(xScale * (Double.parseDouble((String)this.xData.get(i)) - xMin)) + 1;
            int y = ySize - (int)(yScale * (Double.parseDouble((String)this.yData.get(i)) - yMin)) - 1;
            out.drawPoint(x, y, 0);
            if (i > 0) {
                for (int j = oldX; j <= x; ++j) {
                    double tgalpha = (double)(y - oldY) / (double)(x - oldX);
                    double yi1 = (double)oldY + tgalpha * (double)(j - oldX);
                    int yi = (int)yi1;
                    out.drawLine(j, yi, j, ySize - 1);
                }
            }
            oldX = x;
            oldY = y;
        }
        return out;
    }

    private WBMPfile drawChartPointFilled(WBMPfile in) {
        WBMPfile out = in;
        this.drawAxis(in);
        int xSize = in.getWBMPLength() - 2;
        int ySize = in.getWBMPWidth() - 2;
        double xMin = this.getMinX();
        double yMin = this.getMinY();
        double xScale = (double)xSize / (this.getMaxX() - this.getMinX());
        double yScale = (double)ySize / (this.getMaxY() - this.getMinY());
        for (int i = 0; i < this.xData.size(); ++i) {
            int x = (int)(xScale * (Double.parseDouble((String)this.xData.get(i)) - xMin)) + 1;
            int y = ySize - (int)(yScale * (Double.parseDouble((String)this.yData.get(i)) - yMin)) - 1;
            out.drawLine(x, y, x, ySize - 1);
        }
        return out;
    }

    private WBMPfile drawChartHistogram(WBMPfile in) {
        WBMPfile out = in;
        return out;
    }

    private WBMPfile drawAxis(WBMPfile in) {
        WBMPfile out = in;
        int xSize = in.getWBMPLength();
        int ySize = in.getWBMPWidth();
        out.drawLine(1, 1, 1, ySize - 1);
        out.drawLine(1, ySize - 1, xSize - 1, ySize - 1);
        return out;
    }

    private WBMPfile drawApplePie(WBMPfile in) {
        WBMPfile out = in;
        double percent = 100.0;
        try {
            percent = Double.parseDouble((String)this.xData.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int xSize = out.getWBMPLength();
        int ySize = out.getWBMPWidth();
        out.drawArc(1, 1, xSize - 2, ySize - 2, 0, (int)(3.6 * percent));
        out.drawLine(xSize / 2, ySize / 2, xSize, ySize / 2);
        return out;
    }

    private double getMinX() {
        double out = 0.0;
        try {
            out = Double.parseDouble((String)this.xData.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int totalData = this.xData.size();
        for (int i = 0; i < totalData; ++i) {
            if (!(out > Double.parseDouble((String)this.xData.get(i)))) continue;
            out = Double.parseDouble((String)this.xData.get(i));
        }
        return out;
    }

    private double getMinY() {
        double out = 0.0;
        try {
            out = Double.parseDouble((String)this.yData.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int totalData = this.yData.size();
        for (int i = 0; i < totalData; ++i) {
            if (!(out > Double.parseDouble((String)this.yData.get(i)))) continue;
            out = Double.parseDouble((String)this.yData.get(i));
        }
        return out;
    }

    private double getMaxX() {
        double out = 0.0;
        try {
            out = Double.parseDouble((String)this.xData.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int totalData = this.xData.size();
        for (int i = 0; i < totalData; ++i) {
            if (!(out < Double.parseDouble((String)this.xData.get(i)))) continue;
            out = Double.parseDouble((String)this.xData.get(i));
        }
        return out;
    }

    private double getMaxY() {
        double out = 0.0;
        try {
            out = Double.parseDouble((String)this.yData.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int totalData = this.yData.size();
        for (int i = 0; i < totalData; ++i) {
            if (!(out < Double.parseDouble((String)this.yData.get(i)))) continue;
            out = Double.parseDouble((String)this.yData.get(i));
        }
        return out;
    }

    public void setXData(Vector newXData) {
        this.xData = newXData;
    }

    public Vector getXData() {
        return this.xData;
    }

    public void setYData(Vector newYData) {
        this.yData = newYData;
    }

    public Vector getYData() {
        return this.yData;
    }
}

