package com.openecho;
import java.lang.*;
import java.net.*;
import java.io.*;
import javax.net.ssl.*;

/**

for detailed information on all the public fields, please see:<BR>
<a href="https://wwws.echo-inc.com/ISPGuide-Fields2.asp">https://wwws.echo-inc.com/ISPGuide-Fields2.asp</a>

Requirements:<BR>
You must have the JCE (crypto) installed.<BR>
It can be found at: <BR>
<a href="http://java.sun.com/products/jce/">http://java.sun.com/products/jce/</a><BR><BR>

You must have the JSSE (java secure socket extensions) installed.<BR>
It can be found at: <BR>
<a href="http://java.sun.com/products/jsse/">http://java.sun.com/products/jsse/</a><BR><BR>

You must include the following line to the java.security file:<BR>
security.provider.2=com.sun.net.ssl.internal.ssl.Provider<BR><BR>

You must add openecho.jar to your CLASSPATH.<BR><BR>

Please, please, please let us know about any<BR>
any bugs or feature requests.  You may contact us at:<BR>
<a href="mailto:support@openecho.com">support@openecho.com</a>

* @author <a href="mailto:support@openecho.com">Jim Darden</a>
* @version 1.0
*/

public class Echo {
	public String order_type = "";
	public String transaction_type = "";
	public String merchant_echo_id = "";
	public String merchant_pin = "";
	public String isp_echo_id = "";
	public String isp_pin = "";
	public String authorization = "";
	public String billing_ip_address = "";
	public String billing_prefix = "";
	public String billing_name = "";
	public String billing_address1 = "";
	public String billing_address2 = "";
	public String billing_city = "";
	public String billing_state = "";
	public String billing_zip = "";
	public String billing_country = "";
	public String billing_phone = "";
	public String billing_fax = "";
	public String billing_email = "";
	public String cc_number = "";
	public String ccexp_month = "";
	public String ccexp_year = "";
	public String counter = "";
	public String debug = "";
	public String ec_account = "";
	public String ec_address1 = "";
	public String ec_address2 = "";
	public String ec_bank_name = "";
	public String ec_business_acct = "";
	public String ec_city = "";
	public String ec_email = "";
	public String ec_first_name = "";
	public String ec_id_country = "";
	public String ec_id_exp_mm = "";
	public String ec_id_exp_dd = "";
	public String ec_id_exp_yy = "";
	public String ec_id_number = "";
	public String ec_id_state = "";
	public String ec_id_type = "";
	public String ec_last_name = "";
	public String ec_license_number = "";
	public String ec_license_state = "";
	public String ec_merchant_ref = "";
	public String ec_nbds_code = "";
	public String ec_other_name = "";
	public String ec_payee = "";
	public String ec_rt = "";
	public String ec_serial_number = "";
	public String ec_state = "";
	public String ec_zip = "";
	public String grand_total = "";
	public String merchant_email = "";
	public String merchant_trace_nbr = "";
	public String original_amount = "";
	public String original_trandate_mm = "";
	public String original_trandate_dd = "";
	public String original_trandate_yyyy = "";
	public String original_reference = "";
	public String order_number = "";
	public String shipping_flag = "";
	public String status = "";
	public String shipping_prefix = "";
	public String shipping_name = "";
	public String shipping_address1 = "";
	public String shipping_address2 = "";
	public String shipping_city = "";
	public String shipping_state = "";
	public String shipping_zip = "";
	public String shipping_comments = "";
	public String shipping_country = "";
	public String shipping_phone = "";
	public String shipping_fax = "";
	public String shipper = "";
	public String shipper_tracking_nbr = "";
	public String track1 = "";
	public String track2 = "";
    public String product_description = "";
    public String purchase_order_number = "";
    public String sales_tax = "";
	public String openecho = "";
	public String athorization = "";
	public String reference = "";
	public String echoServer = "https://wwws.echo-inc.com/scripts/INR200.EXE";


	// private variables
	private String privEchoResponse = "";
	private boolean privEchoSuccess = false;
	private String privEchoStatus = "";
    private String privDeclineCode = "";
    private String privAVSResult = "";
    private String privAuthCode = "";
    private String privEchoType1 = "";
    private String privEchoType2 = "";
    private String privEchoType3 = "";


	// constructor
	public void Echo() {
	}

    /**
        @return <code>true</code> if the result of the credit card or check transaction was successful or
        <code>false</code> if declined.
        @see #echoSuccess
    */
	public boolean submit() {
		// set this system property so we can do https requests using the URL class
		System.setProperty("java.protocol.handler.pkgs","com.sun.net.ssl.internal.www.protocol");
		URL url = null;

		try {
			url = new URL(urlString());

		} catch(MalformedURLException e) {
			privEchoResponse = e.toString();
			return false;
		}

		// collect the response from echo
		try {
			InputStream in = url.openStream();

			StringWriter sw = new StringWriter();
            byte b;
            while ((b = (byte)in.read()) != -1)
            	sw.write(b);

            privEchoResponse = sw.toString();

		} catch (IOException e) {
			privEchoResponse = e.toString();
			return false;
		}

		privEchoType1 = getEchoProp(privEchoResponse, "ECHOTYPE1");
		privEchoType2 = getEchoProp(privEchoResponse, "ECHOTYPE2");
		privEchoType3 = getEchoProp(privEchoResponse, "ECHOTYPE3");

		privEchoStatus = getEchoProp(privEchoType3, "status");
        authorization = getEchoProp(privEchoType3, "auth_code");
        order_number = getEchoProp(privEchoType3, "order_number");
        reference = getEchoProp(privEchoType3, "echo_reference");
        privDeclineCode = getEchoProp(privEchoType3, "decline_code");
        privAVSResult = getEchoProp(privEchoType3, "avs_result");
        privAuthCode = getEchoProp(privEchoType3, "auth_code");

        privEchoSuccess = ((!privEchoStatus.equals("D")) && (!privEchoStatus.equals("")));

		return privEchoSuccess;
	}

    /**
        @return <code>true</code> if the result of the last submit() succeeded or
        <code>false</code> if submit() failed.
        @see #submit
    */
	public boolean echoSuccess() {
		return privEchoSuccess;
	}

    /**
        @return The one character status code.  Status code of "D" or "" indicates the transaction failed.
    */
	public String echoStatus() {
		return privEchoStatus;
	}

    /**
        @return The order number returned by the ECHO server.
        This is filled in after calling submit().  You can also
        set and get the value of order number by accessing the
        public field order_number
        @see #submit()
        @see #order_number
    */
    public  String echoOrderNumber() {
        return order_number;
    }

    /**
        @return The deline code, if any returned by the ECHO server.
        This is filled in after the calling submit().  For more information
        on this code see ECHO's documentation:
        <a target="_blank" href="https://wwws.echo-inc.com/ISPGuide-Codes.asp">https://wwws.echo-inc.com/ISPGuide-Codes.asp</a>

        @see #submit()
    */
    public String echoDeclineCode() {
        return privDeclineCode;
    }

    /**
        @return The code returned for for AVS transactions.
        This is filled in after the calling submit().
        For more information on this code see ECHO's documentation:
        <a target="_blank" href="https://wwws.echo-inc.com/ISPGuide-Response.asp#AVSOnly">https://wwws.echo-inc.com/ISPGuide-Response.asp#AVSOnly</a>

        @see #submit()
    */
    public String echoAVSResult() {
        return privAVSResult;
    }


    /**
        @return The reference number returned by the ECHO server.
        This is filled in after calling submit().  You can also
        set and get the value of reference by accessing the
        public field reference.
        @see #submit()
        @see #reference
    */
    public String echoReference() {
        return reference;
    }

    /**
        @return The authorization code returned for for address verification transactions.
        This is filled in after the calling submit().
        For more information on this code see ECHO's documentation:
        <a target="_blank" href="https://wwws.echo-inc.com/ISPGuide-Response.asp">https://wwws.echo-inc.com/ISPGuide-Response.asp</a>

        @see #submit()
    */
    public String echoAuthCode() {
        return privAuthCode;
    }


    /**
        @return The raw, unformatted response from the ECHO server.
    */
	public String echoResponse() {
		return privEchoResponse;
	}

    /**
        @return The raw, unformatted echotype1 returned by the ECHO server.
        See the bottom of this page: <a target="_blank" href="https://wwws.echo-inc.com/ISPGuide-Interface.asp">https://wwws.echo-inc.com/ISPGuide-Interface.asp</a>
        for more information about echotype data.
    */
    public String echoType1() {
        return privEchoType1;
    }

    /**
        @return The raw, unformatted echotype2 returned by the ECHO server.
        This is HTML displayable data.
        See the bottom of this page: <a target="_blank" href="https://wwws.echo-inc.com/ISPGuide-Interface.asp">https://wwws.echo-inc.com/ISPGuide-Interface.asp</a>
        for more information about echotype data.

    */
    public String echoType2() {
        return privEchoType2;
    }

    /**
        @return The raw, unformatted echotype3 returned by the ECHO server.
        This is XML formatted data.
        See the bottom of this page: <a target="_blank" href="https://wwws.echo-inc.com/ISPGuide-Interface.asp">https://wwws.echo-inc.com/ISPGuide-Interface.asp</a>
        for more information about echotype data.

    */
    public String echoType3() {
        return privEchoType3;
    }

    private String getEchoProp(String haystack, String prop) {
		int startPos, endPos;
        String propValue = "";
        String modifiedProp = "<" + prop + ">";
        if  ((startPos = haystack.indexOf(modifiedProp)) > -1) {
            startPos = haystack.indexOf(modifiedProp) + modifiedProp.length();
            endPos = haystack.indexOf("</" + prop);
            try {
                propValue = haystack.substring(startPos, endPos);
            } catch(Exception e) {
                // there could be a StringIndexOutOfBounds error here...
                propValue = "";
            }
        }
        return propValue;
	}


    private String noNulls(String value) {
        return (value != null) ? value : "";
    }

    /**
        @return The formatted string of data that is submitted to the ECHO server.
        This is good for debugging purposes.  This follows the ECHO interface
        spcification as described in:
        <a target="_blank" href="https://wwws.echo-inc.com/ISPGuide-Interface.asp">https://wwws.echo-inc.com/ISPGuide-Interface.asp</a>
    */
	public String urlString() {
		String s;
		s = echoServer +
        "?order_type="              + noNulls(order_type) +
        "&transaction_type="        + noNulls(transaction_type) +
        "&merchant_echo_id="        + noNulls(merchant_echo_id) +
        "&merchant_pin="            + noNulls(merchant_pin) +
        "&isp_echo_id="             + noNulls(isp_echo_id) +
        "&isp_pin="                 + noNulls(isp_pin) +
        "&authorization="           + noNulls(authorization) +
        "&billing_ip_address="      + URLEncoder.encode(noNulls(billing_ip_address)) +
        "&billing_prefix="          + URLEncoder.encode(noNulls(billing_prefix)) +
        "&billing_name="            + URLEncoder.encode(noNulls(billing_name)) +
        "&billing_address1="        + URLEncoder.encode(noNulls(billing_address1)) +
        "&billing_address2="        + URLEncoder.encode(noNulls(billing_address2)) +
        "&billing_city="            + URLEncoder.encode(noNulls(billing_city)) +
        "&billing_state="           + URLEncoder.encode(noNulls(billing_state)) +
        "&billing_zip="             + URLEncoder.encode(noNulls(billing_zip)) +
        "&billing_country="         + URLEncoder.encode(noNulls(billing_country)) +
        "&billing_phone="           + URLEncoder.encode(noNulls(billing_phone)) +
        "&billing_fax="             + URLEncoder.encode(noNulls(billing_fax)) +
        "&billing_email="           + URLEncoder.encode(noNulls(billing_email)) +
        "&cc_number="               + URLEncoder.encode(noNulls(cc_number)) +
        "&ccexp_month="             + noNulls(ccexp_month) +
        "&ccexp_year="              + noNulls(ccexp_year) +
        "&counter="                 + noNulls(counter) +
        "&debug="                   + noNulls(debug) +
        "&transaction_type="        + noNulls(transaction_type);

        if ((noNulls(transaction_type) == "DD") || (noNulls(transaction_type) == "DC")) {
            s +=
            "&ec_account="              + noNulls(ec_account) +
            "&ec_address1="             + URLEncoder.encode(noNulls(ec_address1)) +
            "&ec_address2="             + URLEncoder.encode(noNulls(ec_address2)) +
            "&ec_bank_name="            + URLEncoder.encode(noNulls(ec_bank_name)) +
            "&ec_business_acct="        + URLEncoder.encode(noNulls(ec_business_acct)) +
            "&ec_city="                 + URLEncoder.encode(noNulls(ec_city)) +
            "&ec_email="                + URLEncoder.encode(noNulls(ec_email)) +
            "&ec_first_name="           + URLEncoder.encode(noNulls(ec_first_name)) +
            "&ec_id_country="           + URLEncoder.encode(noNulls(ec_id_country)) +
            "&ec_id_exp_mm="            + noNulls(ec_id_exp_mm) +
            "&ec_id_exp_dd="            + noNulls(ec_id_exp_dd) +
            "&ec_id_exp_yy="            + noNulls(ec_id_exp_yy) +
            "&ec_id_number="            + noNulls(ec_id_number) +
            "&ec_id_state="             + URLEncoder.encode(noNulls(ec_id_state)) +
            "&ec_id_type="              + noNulls(ec_id_type) +
            "&ec_last_name="            + URLEncoder.encode(noNulls(ec_last_name)) +
            "&ec_license_number="       + URLEncoder.encode(noNulls(ec_license_number)) +
            "&ec_license_state="        + URLEncoder.encode(noNulls(ec_license_state)) +
            "&ec_merchant_ref="         + URLEncoder.encode(noNulls(ec_merchant_ref)) +
            "&ec_nbds_code="            + noNulls(ec_nbds_code) +
            "&ec_other_name="           + URLEncoder.encode(noNulls(ec_other_name)) +
            "&ec_payee="                + URLEncoder.encode(noNulls(ec_payee)) +
            "&ec_rt="                   + URLEncoder.encode(noNulls(ec_rt)) +
            "&ec_serial_number="        + URLEncoder.encode(noNulls(ec_serial_number)) +
            "&ec_state="                + URLEncoder.encode(noNulls(ec_state)) +
            "&ec_zip="                  + URLEncoder.encode(noNulls(ec_zip));
		}

		s +=
        "&grand_total="             + noNulls(grand_total) +
        "&merchant_email="          + URLEncoder.encode(noNulls(merchant_email)) +
        "&merchant_trace_nbr="      + noNulls(merchant_trace_nbr) +
        "&original_amount="         + noNulls(original_amount) +
        "&original_trandate_mm="    + noNulls(original_trandate_mm) +
        "&original_trandate_dd="    + noNulls(original_trandate_dd) +
        "&original_trandate_yyyy="  + noNulls(original_trandate_yyyy) +
        "&original_reference="      + noNulls(original_reference) +
        "&order_number="            + noNulls(order_number) +
        "&shipping_flag="           + noNulls(shipping_flag) +
        "&shipping_prefix="         + noNulls(shipping_prefix) +
        "&shipping_name="           + URLEncoder.encode(noNulls(shipping_name)) +
        "&shipping_address1="       + URLEncoder.encode(noNulls(shipping_address1)) +
        "&shipping_address2="       + URLEncoder.encode(noNulls(shipping_address2)) +
        "&shipping_city="           + URLEncoder.encode(noNulls(shipping_city)) +
        "&shipping_state="          + URLEncoder.encode(noNulls(shipping_state)) +
        "&shipping_zip="            + URLEncoder.encode(noNulls(shipping_zip)) +
        "&shipping_comments="       + URLEncoder.encode(noNulls(shipping_comments)) +
        "&shipping_country="        + URLEncoder.encode(noNulls(shipping_country)) +
        "&shipping_phone="          + URLEncoder.encode(noNulls(shipping_phone)) +
        "&shipping_fax="            + URLEncoder.encode(noNulls(shipping_fax)) +
        "&shipper="                 + URLEncoder.encode(noNulls(shipper)) +
        "&shipper_tracking_nbr="    + noNulls(shipper_tracking_nbr) +
        "&product_description="     + URLEncoder.encode(noNulls(product_description)) +
        "&purchase_order_number="   + URLEncoder.encode(noNulls(purchase_order_number)) +
        "&sales_tax="               + URLEncoder.encode(noNulls(sales_tax)) +
        "&track1="                  + URLEncoder.encode(noNulls(track1)) +
        "&track2="                  + URLEncoder.encode(noNulls(track2));

		return s;

	} // end urlString


}
