/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Service;

import jChatBox.Chat.ChatException;
import jChatBox.Chat.Chatroom;
import jChatBox.Chat.ChatroomManager;
import jChatBox.Chat.ChatroomUser;
import jChatBox.Chat.Monitor;
import jChatBox.Chat.UserParams;
import jChatBox.Service.Login;
import jChatBox.Util.Debug;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserLogin
extends Login {
    public String doLogin(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        this.setSysMessage("");
        String string = httpServletRequest.getParameter("name");
        String string2 = httpServletRequest.getParameter("chatrooms");
        String string3 = httpServletRequest.getParameter("email");
        if (string != null && !string.equals("")) {
            if (string2 != null && !string2.equals("")) {
                int n = -1;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setSysMessage("CHATROOMNOTFOUND");
                    String string4 = null;
                    return string4;
                }
                UserParams userParams = new UserParams();
                userParams.setEmail(string3);
                try {
                    this.boundUser(httpServletRequest, httpSession, n, userParams, string);
                    String string5 = "room.jsp";
                    return string5;
                }
                catch (ChatException chatException) {
                    this.setSysMessage(chatException.getMessage());
                    String string6 = null;
                    return string6;
                }
            }
            this.setSysMessage("CHATROOMIDMISSING");
            return null;
        }
        return null;
    }

    protected void boundUser(HttpServletRequest httpServletRequest, HttpSession httpSession, int n, UserParams userParams, String string) throws ChatException {
        Chatroom chatroom = null;
        ChatroomManager chatroomManager = ChatroomManager.getInstance();
        if (chatroomManager == null) {
            throw new ChatException("SYSTEMERROR");
        }
        chatroom = chatroomManager.getChatroom(n);
        userParams.setChatroom(n);
        userParams.setRefresh(chatroom.getParams().getRefreshLimit());
        userParams.setAgent(httpServletRequest.getHeader("User-Agent"));
        ChatroomUser chatroomUser = new ChatroomUser(string, httpServletRequest.getRemoteAddr(), 0, userParams, chatroom);
        chatroom.addUser(chatroomUser);
        Monitor monitor = Monitor.getInstance();
        if (monitor == null) {
            throw new ChatException("SYSTEMERROR");
        }
        httpSession.putValue("user", (Object)chatroomUser);
        monitor.getTable().put(chatroomUser, httpSession);
        httpSession.setMaxInactiveInterval(chatroom.getParams().getMaxInactive());
        chatroomUser.updateMonitorLogListener(monitor);
    }

    protected void trace(int n, String string) {
        Debug.log(n, this.getClass().getName(), string);
    }
}

