/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Chat;

import jChatBox.Chat.Blacklist;
import jChatBox.Chat.ChatException;
import jChatBox.Chat.ChatroomParams;
import jChatBox.Chat.ChatroomUser;
import jChatBox.Chat.LogListener;
import jChatBox.Chat.Msg;
import jChatBox.Util.Debug;
import jChatBox.Util.XMLConfig;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Chatroom
implements Serializable,
LogListener {
    private ChatroomParams _$38988 = null;
    private Vector _$64023;
    private transient Hashtable _$64028 = null;
    private Blacklist _$64034 = null;
    private Date _$64044 = null;

    public Chatroom(ChatroomParams chatroomParams) {
        this._$38988 = chatroomParams;
        this._$64023 = new Vector();
        this._$64028 = new Hashtable();
        this._$64034 = new Blacklist();
        this.open();
        this._$1501(1, String.valueOf(String.valueOf(new StringBuffer("New Chatroom : ").append(this._$38988.getName()).append("/").append(this._$38988.getSubject()).append("/").append(this._$38988.getMaxUsers()))));
    }

    public void open() {
        this._$64044 = new Date();
    }

    public void reOpen() {
        this._$64028 = new Hashtable();
        this._$64044 = new Date();
        this._$1501(1, "reOpen : ".concat(String.valueOf(String.valueOf(this._$38988.getName()))));
    }

    public void close() {
        this._$64044 = null;
    }

    public Date getDate() {
        return this._$64044;
    }

    public void addUser(ChatroomUser chatroomUser) throws ChatException {
        if (this._$64044 == null) {
            throw new ChatException("CHATROOMCLOSED");
        }
        String string = chatroomUser.getName();
        if (this._$64034.isKickedOff(chatroomUser)) {
            throw new ChatException("KICKEDOFF");
        }
        if (this._$64034.isBanned(chatroomUser)) {
            throw new ChatException("BANNED");
        }
        if (chatroomUser.getType() != 2 && this._$64028.size() > this._$38988.getMaxUsers()) {
            throw new ChatException("CHATROOMFULL");
        }
        ChatroomUser chatroomUser2 = (ChatroomUser)this._$64028.get(string);
        if (chatroomUser2 == null) {
            if (chatroomUser.getName().toUpperCase().equals(XMLConfig.SYSTEMLOGIN.toUpperCase()) && chatroomUser.getType() != 2) {
                throw new ChatException("NAMENOTAVAILABLE");
            }
        } else {
            throw new ChatException("NAMENOTAVAILABLE");
        }
        this._$64028.put(string, chatroomUser);
        this.addMsg(new Msg(new Date(), "Manager", "ALL", string, 1));
    }

    public ChatroomUser getUser(String string) {
        ChatroomUser chatroomUser = (ChatroomUser)this._$64028.get(string);
        return chatroomUser;
    }

    public int getTotalUsers() {
        return this._$64028.size();
    }

    public ChatroomParams getParams() {
        return this._$38988;
    }

    public void updateParams(ChatroomParams chatroomParams) {
        this._$38988 = chatroomParams;
        this._$1501(1, String.valueOf(String.valueOf(new StringBuffer("Chatroom updated: ").append(this._$38988.getName()).append("/").append(this._$38988.getSubject()).append("/").append(this._$38988.getMaxUsers()))));
    }

    public void addToBlacklist(ChatroomUser chatroomUser, String string) {
        this._$64034.add(chatroomUser, string);
    }

    public void removeFromBlacklist(String string) {
        this._$64034.remove(string);
    }

    public void resetBlacklist() {
        this._$64034.clear();
    }

    public Blacklist getBlacklist() {
        return this._$64034;
    }

    public void removeUser(String string) throws ChatException {
        ChatroomUser chatroomUser = (ChatroomUser)this._$64028.get(string);
        if (chatroomUser == null) {
            throw new ChatException("NAMENOTFOUND");
        }
        this._$64028.remove(chatroomUser.getName());
        this.addMsg(new Msg(new Date(), "Manager", "ALL", chatroomUser.getName(), 2));
    }

    public void addMsg(Msg msg) throws ChatException {
        this._$64023.addElement(msg);
    }

    public Vector getChat() {
        return this._$64023;
    }

    public Vector getChat(String string) {
        Vector<Msg> vector = new Vector<Msg>();
        Msg msg = null;
        for (int i = 0; i < this._$64023.size(); ++i) {
            msg = (Msg)this._$64023.elementAt(i);
            if (!msg.getTo().equals(string) && !msg.getTo().equals("ALL") && !msg.getTo().equals("BROADCAST") && (msg.getType() != 3 || !msg.getFrom().equals(string))) continue;
            vector.addElement(msg);
        }
        return vector;
    }

    public Hashtable getUsers() {
        return this._$64028;
    }

    public void performLogout(ChatroomUser chatroomUser) {
        try {
            this.removeUser(chatroomUser.getName());
        }
        catch (Exception exception) {
            this._$1501(2, String.valueOf(String.valueOf(new StringBuffer("").append(chatroomUser.getName()).append(" has already left room : ").append(this._$38988.getName()))));
        }
    }

    public void performLogin(ChatroomUser chatroomUser) {
    }

    private void _$1501(int n, String string) {
        Debug.log(n, this.getClass().getName(), string);
    }
}

