package net.sourceforge.idrs.utils.pool;
public class PooledObject {
  protected long born;
  protected boolean free;
  protected Object value;
  public PooledObject(long born,boolean free,Object obj) throws Exception {
    this.born = born;
    this.free = free;
    this.value = obj;	
  }	
  
  public void isFree(boolean free)  {
    this.free = free;	
  }
  
  public boolean isFree() {
    return this.free;	
  }
  
  public void setBorn(long born)  {
    this.born = born;	
  }
  
  public long getBorn()  {
    return this.born;	
  }
  
  public void setValue(Object obj)  {
    this.value = obj;	
  }
  
  public Object getValue()  {
    return this.value;	
  }
  
  public boolean equals(Object obj) {
    PooledObject key;
    try {
      key = (PooledObject) obj;
      return ((key.born == this.born) && (key.free == this.free));
    }
    catch (Exception e) {
      return false;	
    }	
  }  
  
  public boolean equalsObj(Object obj) {
    return this.value.toString().equals(obj.toString());
  }
  
  
  protected int genHashCode(int source,Object x) {
     final int PRIME = 1000003;
     return (x == null) ? 0 : PRIME * source + x.hashCode();
   } 
   
   public int hashCode() {
     return (genHashCode(super.hashCode(),this.value.toString()));	
   }
}
