package net.sourceforge.idrs.utils;
import java.util.*;
import java.sql.*;
import java.lang.reflect.*;
import net.sourceforge.idrs.script.IDRSScript;
/**
 * ObjectStore.java
 * Copyright (C) 2000 Marc Boorshtein under the GNU General Public License offered
 * without warenty
 */
public class ObjectStore {
  private Hashtable methods = new Hashtable();
  private Object obj;
  private String className;
  private Class cls;
  private String id;

  /**
   * Creates an ObjectStore based on an Id and a classname
   */
  public ObjectStore(String id, String className) {
    this.id = id;
    this.className = className;
    try {
      cls = Class.forName(className);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Creates a ObjectStore based on an ID
   */
  public ObjectStore(String id) {
    this.id = id;
  }

  /**
   * Loads given class
   */
  public void setClassName(String clsName) throws Exception {
    this.className = clsName;
    try {
      cls = Class.forName(className);
    }
    catch (Exception e) {
      throw new Exception("Class : " + clsName + " is not a vaild class");
    }
    Method[] meths = cls.getMethods();
    int i;
    Method meth;
    for (i = 0;i < meths.length;i++) {
      meth = meths[i];
    }
  }

  /**
   * Loads given method for use
   */
  public void addMethod(String methodName, Class[] argTypes) throws Exception {
      Method[] meths = cls.getMethods();
    int i;
    Method meth;
    meth = cls.getMethod(methodName,argTypes);
    //Class[] clss = meth.getParameterTypes();
      //clss = argTypes;


      methods.put(methodName,meth);
  }

  /**
   * Returns the class' of a given methods arguments
   */
  public Class[] getMethodTypes(String method) {
    Method meth = (Method) methods.remove(method);
    Class[] clss =  meth.getParameterTypes();
    methods.put(method,meth);
    return clss;
  }

  /**
   * Executes a given method with given arguments
   */
  public Object execMethod(String methodName, Object[] vals) throws Exception {
    Object retVal;

    Method meth = (Method) methods.remove(methodName);

    retVal =  meth.invoke(obj,vals);

    methods.put(methodName,meth);
    return retVal;
  }

  /**
   * Calls the constructor matching the artypes
   */
  public void initiate(Class[] argTypes, Object[] args) throws Exception {

    try {

      Constructor con = this.cls.getConstructor(argTypes);
      obj = con.newInstance(args);

    }
    catch (Exception e) {
      throw new Exception("No Matching Constructor");
    }
  }

  /**
   * Used to return a valid class for the ObjectStore
   */
  public static Object getValue(Class cls, String val,Connection con,IDRSScript idrs) throws Exception {
    val = val.trim();
    if (cls == String.class) {
      return val;
    }
    else if (cls == Integer.class) {
      return new Integer(val);
    }
    else if (cls == Float.class) {
      return new Float(val);
    }
    else if (cls == java.sql.Date.class) {
      return new java.sql.Date(java.sql.Date.parse(val));
    }
    else if (cls == java.sql.Time.class) {
      return new java.sql.Time(java.sql.Time.parse(val));
    }
    else if (cls == java.sql.Connection.class) {
      return con;
    }
    else if (cls == IDRSScript.class) {
      return idrs;	
    }
    else
      throw new Exception(cls.toString() + " not a valid class for the ObjectStore");

  }
  
  public Object getRef() throws Exception {
    return obj;	
  }

}