package net.sourceforge.idrs.script.embedable;
//import IDRSScript;
import javax.servlet.http.*;
import javax.servlet.*;
import java.io.PrintWriter;
import net.sourceforge.idrs.core.IDRSReport;

public class IDRSShell {
    IDRSReport idrs;
    
    public IDRSShell(IDRSReport idrs) {
      this.idrs = idrs;  	
    }
    /**
    Used to retrieve a piece of data from a particuler DB with a given format
    */
    public String getFieldData(String db,String field,String format) throws Exception {
      return idrs.getFieldData(db,field,format);
    }
    
    /**
    Used to retrieve a piece of data from a particuler DB without format
    */
    public String getFieldData(String db,String field) throws Exception {
      return idrs.getFieldData(db,field);	
    }
    
    /**
     Used to retrieve the results of an update
    */
    public int getInputResults(String db) throws Exception {
      return idrs.getInputResults(db);
    }
    
    /**
     Used to move to the next record in a selected db
     */
    public boolean next(String db) throws Exception {
      return idrs.next(db);
    }
    
    /**
     Used to move to a particuler record
     */
    public boolean moveTo(String db, int record) throws Exception {
      return idrs.next(db);
    }
    
    /**
     Used to retrieve a refrence to an object created in an IDRS report
    */
    public Object getObject(String obj) throws Exception {
      return idrs.getObject(obj);
    }
    
    /**
     retrieves printwriter used by the IDRS
    */
    public PrintWriter getOut() throws Exception {
      return idrs.getOut();
    }
    
    /**
     Retrieves the session object from webserver
    */
    public HttpSession getSession() throws Exception {
      return idrs.getSession();
    }
    
    /**
     Retrieves request object from webserver
    */
    public HttpServletRequest getRequest() throws Exception {
      return idrs.getRequest();
    }
}