package net.sourceforge.idrs.script.embedable;

import net.sourceforge.idrs.script.IDRSScript;
//import IDRSScriptLanguage;
import org.python.util.PythonInterpreter; 
import org.python.core.*; 

public class IDRSJPython implements IDRSScriptLanguage {
	
  protected PythonInterpreter interp;
  
  public IDRSJPython() {
    interp = new PythonInterpreter();  	
    //interp.exec("import IDRSScript");
  }
   
  
  public void importClass(String className) throws Exception {
    if (className.indexOf(".") != -1) {
      String pack = className.substring(0,className.lastIndexOf("."));
      String clsNm = className.substring(className.lastIndexOf(".") + 1);
      interp.exec("from " + pack + " import " + clsNm);
    }
    else {
      interp.exec("import " + className);	
    }
  }
  /**
   Used for <$= $>
  */
  public String eval(String cmd) throws Exception {
    return interp.eval(cmd).toString();
  }
  
  /**
   Used for <$ $>
  */
  public void exec(String cmds) throws Exception {
    interp.exec(cmds);
  }
  
  /**
    Used for extracting objects
  */
  public Object getVal(String obj) throws Exception {
    return interp.get(obj);	
  }
  
  /**
   Used for setting object
  */
  public void setVal(String name,Object val) throws Exception {
    interp.set(name,val);
  }
}