package net.sourceforge.idrs.script.embedable;
//import IDRSScriptLanguage;
import bsh.*;

public class IDRSBeanShell implements IDRSScriptLanguage {
  Interpreter bsh;
  public IDRSBeanShell() throws Exception {
    bsh = new Interpreter();
  }
  
  /**
   Used for <$= $>
  */
  public String eval(String cmd) throws Exception {
    return bsh.eval(cmd).toString();
  }
  
  /**
   Used for <$ $>
  */
  public void exec(String cmds) throws Exception {
    bsh.eval("return " + cmds);
  }
  
  /**
    Used for extracting objects
  */
  public Object getVal(String obj) throws Exception {
    return bsh.getVariable(obj);
  }
  
  /**
   Used for setting object
  */
  public void setVal(String name,Object val) throws Exception {
    bsh.setVariable(name,val);
  }
  
  public void importClass(String className) throws Exception {
    bsh.eval("import " + className);
  }
}