package net.sourceforge.idrs.script;

/*****************************************************************************************************
 *The IDRSScript class encapsultes all of the features needed by a scripting method or mebeded script*
 *****************************************************************************************************/
import java.io.*;
import javax.servlet.http.*;
import javax.servlet.*;

public interface IDRSScript {
    /**
    Used to retrieve a piece of data from a particuler DB with a given format
    */
    public String getFieldData(String db,String field,String format) throws Exception;
    
    /**
    Used to retrieve a piece of data from a particuler DB without format
    */
    public String getFieldData(String db,String field) throws Exception;
    
    /**
     Used to retrieve the results of an update
    */
    public int getInputResults(String db) throws Exception;
    
    /**
     Used to move to the next record in a selected db
     */
    public boolean next(String db) throws Exception;
    
    /**
     Used to move to a particuler record
     */
    public boolean moveTo(String db, int record) throws Exception;
    
    /**
     Used to retrieve a refrence to an object created in an IDRS report
    */
    public Object getObject(String obj) throws Exception;
    
    /**
     retrieves printwriter used by the IDRS
    */
    public PrintWriter getOut() throws Exception;
    
    /**
     Retrieves the session object from webserver
    */
    public HttpSession getSession() throws Exception;
    
    /**
     Retrieves request object from webserver
    */
    public HttpServletRequest getRequest() throws Exception;
    
}