package net.sourceforge.idrs.script;
/**
 * DBShell.java<p>
 * Copyright (C) 2000 Marc Boorshtein under the GNU General Public License offered
 * without warenty
 */
//import IdrsDB;
import net.sourceforge.idrs.utils.DB;

public class DBShell implements IdrsDB {
  private DB db;
  String id;
  /**
   * Creates a new DBShell based on an id and a db
   */
  public DBShell(String id,DB db) {
    this.id = id;
    this.db = db;
  }


  /**
   * Retrieves DBShell's db
   */
  public DB getDB() throws Exception {
    return db;
  }

  /**
   * Calls db's next() method
   */
  public boolean next() throws Exception {
    return db.next();
  }

  /**
   * Calls db's getFieldData method
   */
  public String getFieldData(String fieldname,String format) throws Exception {
    String data;
    data = db.getFieldData(fieldname,format);

    return data;
  }

 
  public String getFieldData(String fieldname) throws Exception {
  	return getFieldData(fieldname,null);
  }
  
  public int  getUpdateResult() throws Exception {
    return db.getUpdateResult();
  }
  
  /**
   * Calls db's moveTo method
   */
  public boolean moveTo(int location) throws Exception {
    return db.moveTo(location);
  }
}