package net.sourceforge.idrs.jdbc;
/*
 *  PoolMan Java Object Pooling and Caching Library
 *  Copyright (C) 2000 The Code Studio
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  The full license is located at the root of this distribution
 *  in the LICENSE file.
 */


/*removed Marc boorshtein - 8/31/00
// Code Studio
import com.codestudio.sql.*;
*/

// The JDK
import java.sql.*;
import java.util.*;
import java.io.*;
import net.sourceforge.idrs.utils.pool.*;
//import JDBCInfo;

/**
 * JDBCPool is an ObjectPool of JDBC connection objects.
 */
public class JDBCPool extends ObjectPool {
    
    protected JDBCInfo info;
    /*removed Marc Boorshtein - 8/31/00
    protected SQLCache sqlcache;
    */

    
    /**
     * Create a JDBCPool with full control of all parameters.
     * @param drivername the name of the sql driver
     * @param url the url for the db connection
     * @param username the user of the db connections
     * @param password the paswer for the db user
     * @param timeout the timout for a given connection
     * @param sleep the amount of time between sk4m cycles.
     * @param limit is the maximum number of open connections allowed.
     */
    public JDBCPool(String poolname, String drivername, String url,
		    String username, String password, int min, int limit,
		    long daysOpen, long sleep, String path,int trys) throws Exception {
    // System.out.println("Made it here");
	super(min,limit, daysOpen, sleep, path,trys);
	//System.out.println("still here");
	this.info = new JDBCInfo(poolname, drivername, url,
				username, password);
	logHeader();
	PooledObject pobj;
	if (min >= 0) {
	  for (int i = 0; i < min;i++) {
	    pobj = create();
	    
	    pobj.isFree(true);
	    this.pool[count] = pobj;
	    count++;
	  }
	}
	
	/*removed Marc Boorshtein
	this.sqlcache = null;
7	*/
    }

    protected void logHeader() throws Exception {
    	if (this.info == null) {
    	  System.out.println("No INFO!");
    	}
      if (out == null) 
        out = System.out;
      out.println("Starting Poolman, IDRS Version");
      out.println("dbDriver = " + this.info.getDrivername());
      out.println("dbServer = " + this.info.getUrl());
      out.println("dbLogin = " + this.info.getUsername());
      out.println("log file = " + logPath); 
      out.println("minconnections = " + Integer.toString(minn));
      out.println("maxconnections = " + Integer.toString(limit));
	 out.println("Total refresh intervel = " + Long.toString(daysOpen) + " days");
	 out.println("-----------------------------------------");
    }

    /** Associates a SQLCache with this pool. */
    /*
    public void setCache(SQLCache cache) {
	this.sqlcache = cache;
    }
    */
    /** @return SQLCache The SQLCache associated with this pool. */
    /*
    public SQLCache getCache() {
	return this.sqlcache;
    }

    public boolean usingCache() {
	if (this.sqlcache == null)
	    return false;
	return true;
    }
    */
    /** Creates a new JDBC connection */
    protected PooledObject create() 
	throws SQLException {
	
	if (info.getDrivername() == null || info.getUrl() == null)
	    return null;
	
	try {

	    // using the .newInstance() method to work around 
	    // known problems with certain VM's (per mm.mysql)

	    Driver d = (Driver) (Class.forName(info.getDrivername()).newInstance());
	    Properties p = new Properties();
	    p.put("user", info.getUsername());
	    p.put("password", info.getPassword());
	    Connection con = d.connect(info.getUrl(), p);
	    java.util.Date now = new java.util.Date(System.currentTimeMillis());
         out.println(now.toString() + " Opening connection " + count + " " + con.toString());
	    /* OLD CODE
	    Class.forName(info.getDrivername()).newInstance();
	    Connection con = DriverManager.getConnection(info.getUrl(),
							info.getUsername(),
							info.getPassword());
	    */

	    /*remove Marc Boorshtein - 8/31/00
	    SmartConnection smartcon = new SmartConnection(con, this);
	    return smartcon;
	    */
	    return new PooledObject(System.currentTimeMillis(),true,con);
	    
	}
	catch (ClassNotFoundException cnfex) {
	    out.println("Looks like the driver was not found...");
	    out.println("Be sure it is in your CLASSPATH and listed properly in the properties file.");
	}
	catch (SQLException sqlex)	{
	    /*/throw new SQLException("SQLException occurred in JDBCPool: " + sqlex.toString() + 
				   "\nparams: " + info.getDrivername() + ", " +
				   info.getUrl() + ". Please check your username, password " +
				   "and other connectivity info.");*/
	  out.println(sqlex);
	}
	catch(RuntimeException e) {
	    out.println(e);
	    //e.printStackTrace();
	}
	catch(Exception e) {
	    out.println(e);
	    //e.printStackTrace();
	}
	catch(Throwable t) {
	    out.println(t);
	    //t.printStackTrace();
	}
	return null;
    }
    
    /** Checks to see if the current connection is valid. */
    protected boolean validate(PooledObject o) {
	Connection conn= (Connection) o.getValue();
	try {
	    //Statement stmt = conn.createStatement();
	    //Resultset rs = stmt.query("SELECT * FROM verify;");
	    return !conn.isClosed();
	} catch(SQLException e) {
	    out.println(e);
	}
	return false;
    }
    
    /** Closes a database connection. */
    protected void expire(PooledObject o) {
	/*remove - Marc Boorshtein - 8/31/00
	if (o instanceof com.codestudio.sql.SmartConnection) {
	    SmartConnection scon = (SmartConnection) o;
	    scon.closeAllResources();
    	}
	o = null;
	*/
	Connection con;
	try {
	  con = (Connection) o.getValue();
	  con.close();
	  con = null;
	}
	catch (Exception e) {
	  out.println(e);
	}
    }
    
    /** Retrieves a connection. Renamed from requestConnection*/
    public Connection getConnection() 
	throws SQLException {
	try {
	    Connection con = (Connection) super.checkOut(0);
	    
	    return con;
	} catch (SQLException sqle) {
	    throw new SQLException(sqle.getMessage());
	} catch(Exception e) {
	    out.print("A non-SQL error occurred when requesting a connection:");
	    out.println(e);
	    //e.printStackTrace();
	}
	return null;
    }
    
    /** Returns a connection to the pool. Renamed from returnConnection */
    public void freeConnection(Connection conn) throws Exception {
	super.checkIn(conn);
    }
    
    public void freeConnection(String connName) throws Exception {
      super.checkIn(connName);	
    }

    public JDBCInfo getInfo() {
	return this.info;
    }

    public void setInfo(JDBCInfo i) {
	this.info = i;
    }
    
    /** Static method that closes the statement and result sets in one place; 
     * this is here as a convenience to shorten the finally block 
     * in statements.  Both arguments may be null;
     * @param statement the statement to be closed
     * @param resultSet the resultSet to be closed
     */
    /*removed Macr Boorshtein - 8/31/00
    public static void closeResources(Statement statement, ResultSet resultSet) {
	closeResultSet(resultSet);
	closeStatement(statement);
    }
    
    /** Closes the given statement.  It is here to get rid of
     * the extra try block in finally blocks that need to close statements
     * @param statement the statement to be closed. may be null
     *
    public static void closeStatement(Statement statement) {
	try {
	    if(statement!=null)
		statement.close();
      	} catch(SQLException e) {}
    }
    
    /** This method closes the given resultset.  It is here to get rid of 
     * the extra try block in finally blocks.
     * @param rs the ResultSet to be closed.  may be null
     *
    public static void closeResultSet(ResultSet rs) {
	try {
	    if (rs!=null)
		rs.close();
	} catch(SQLException e) {}
    }
    
    /**
     * Close all resources in the pool.
     *
    public void closeAllResources() {
    	for (Enumeration enum=this.unlocked.keys(); enum.hasMoreElements(); ) {
	    Object o = enum.nextElement();
	    expire(o);
	    o=null;
	}
    }
    
    public void finalize() {
	closeAllResources();
    }
   */
   private int genHashCode(int source,Object x) {
     final int PRIME = 1000003;
     return (x == null) ? 0 : PRIME * source + x.hashCode();
   } 
   
   public int hashCode() {
     return (genHashCode(super.hashCode(),this.info.getUrl()));	
   }
   
   public boolean equals(Object obj) {
     JDBCPool pool;
     try {
       pool = (JDBCPool) obj;
       return this.info.getUrl().equalsIgnoreCase(pool.info.getUrl());	
     }
     catch (Exception e) {
       return false;	
     }
   }
   
   protected void reset(int index) {
     try {
       Connection con = (Connection) pool[index].getValue();
       con.close();
       con = null;
       pool[index].setValue(null);
       pool[index] = null;
       out.println("----->Resetting connection " + index + " ...");
       int tmpCount = count;
       count = index;
       pool[index] = create();
       count = tmpCount;
     }	
     catch (Exception e) {
       out.println(e);	
     }
   }
  
}


