package net.sourceforge.idrs.core;
/*
 * IDRSServlet.java
 * Copyright (C) 2000 Marc Boorshtein under the GNU General Public License offered
 * without warenty
 * Created on March 26, 2000, 12:43 PM
 */
import javax.servlet.http.*;
import javax.servlet.*;
//import IDRSSecurity;
//import IDRSReport;
import java.io.*;
import java.util.*;
import java.sql.*;
//import com.javaexchange.dbConnectionBroker.DbConnectionBroker;
import net.sourceforge.idrs.jdbc.JDBCPool;

/**
 *
 * @author  root
 * @version
 */
public class IDRSServlet extends HttpServlet {
  private String dbName,
                  dbDriver,
                  dbUser,
                  dbPass,
                  contextPath,
                  logPath;
  private long daysToReset;
  private int minConns, maxConns;
  private boolean toLower;

  private Hashtable dbs;
  private Hashtable conns;
  private int numDbs;
  private JDBCPool idrsDBs;
  private String IDRSName;
  private IDRSPool idrss;
  /** Creates new IDRSServlet */
  public IDRSServlet()   {
  }

  public void init(ServletConfig svg) throws ServletException {

    dbDriver = svg.getInitParameter("dbDriver");
    dbName = svg.getInitParameter("dbName");
    dbUser = svg.getInitParameter("dbUser");
    if (dbUser == null)
      dbUser = "";
    dbPass = svg.getInitParameter("dbPass");
    if (dbPass == null)
      dbPass = "";
    String lower = svg.getInitParameter("toLower");
    if  (lower == null)
      toLower = false;
    else
      toLower = lower.equalsIgnoreCase("true");

    conns = new Hashtable();
    contextPath = svg.getInitParameter("contextPath");
    minConns = Integer.parseInt(svg.getInitParameter("minConns"));
    maxConns = Integer.parseInt(svg.getInitParameter("maxConns"));
    daysToReset = Long.parseLong(svg.getInitParameter("daysOpen"));
    logPath = svg.getInitParameter("logPath");
    try {
      idrsDBs = new JDBCPool("IDRS",dbDriver,dbName,dbUser,dbPass,minConns,maxConns,daysToReset,2000,logPath,10);
    }
    catch (Exception e) {
      try {
         System.out.println(e);
         e.printStackTrace();
      }
      catch (Exception e2) {}
    }
    //create list of DB connections
    if (svg.getInitParameter("numDBs") == null)
      numDbs = 0;
    else
      numDbs = Integer.parseInt(svg.getInitParameter("numDBs"));
    String tmpUser,
           tmpPass,
           tmpDriver,
           tmpName,
           tmpLog;
    long tmpDaysOpen;
    int tmpMin,
        tmpMax;
    int i;
    dbs = new Hashtable();
    JDBCPool tmpDB;
    for (i = 1;i <= numDbs; i++) {
      tmpDriver = svg.getInitParameter("dbDriver" + Integer.toString(i));
      
      tmpName = svg.getInitParameter("dbName" + Integer.toString(i));
      
        tmpUser = svg.getInitParameter("dbUser" + Integer.toString(i));
      
      
      if (tmpUser == null)
        tmpUser = "";
      tmpPass = svg.getInitParameter("dbPass" + Integer.toString(i));
      if (tmpPass == null)
        tmpPass = "";

      tmpMin = Integer.parseInt(svg.getInitParameter("minConns" + Integer.toString(i)));
      tmpMax = Integer.parseInt(svg.getInitParameter("maxConns" + Integer.toString(i)));
      tmpDaysOpen = Long.parseLong(svg.getInitParameter("daysOpen" + Integer.toString(i)));
      tmpLog = svg.getInitParameter("logPath" + Integer.toString(i));

      try {
        tmpDB = new JDBCPool(tmpDriver,tmpDriver,tmpName,tmpUser,tmpPass,tmpMin,tmpMax,tmpDaysOpen,2000,tmpLog,10);
        dbs.put(tmpName,tmpDB);
      }
      catch (Exception e) {
        try {
        e.printStackTrace();
          }
        catch (Exception e2) {}
      }



    }
    IDRSName = svg.getServletName();
    
    //start report pool - will make dynamic after it works
    String idrsLogPath, scriptClass;
    
    int poolmin, poolmax, idrsDaysOpen;
    
    try {
      idrsLogPath = svg.getInitParameter("reportLogPath");
      if (idrsLogPath != null) {
        poolmin = Integer.parseInt(svg.getInitParameter("minReports"));
        poolmax = Integer.parseInt(svg.getInitParameter("maxReports"));
        idrsDaysOpen = Integer.parseInt(svg.getInitParameter("daysReportsOpen"));
        scriptClass = svg.getInitParameter("scriptClass"); 
      }
      else {
        idrsLogPath = "idrs.log";
        poolmin = 25;
        poolmax = 50;
        idrsDaysOpen = 7;
        scriptClass = "";
      }
      idrss = new IDRSPool(poolmin,poolmax,idrsDaysOpen,2000,idrsLogPath,10,scriptClass);
    }
    catch (Exception poole) {
      try {poole.printStackTrace(System.out);}catch (Exception ee){}
    }
    
    super.init(svg);
  }

  public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {

    try {
      this.procIDRS(req, resp);
      //System.out.println("Request Processed");

    }
    catch (Exception e) {
      System.out.println(e + "\n" + e.getMessage() + "\n" );
      e.printStackTrace();
    }
  }

  public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
    try {
      this.procIDRS(req, resp);
    }
    catch (Exception e) {
      System.out.println(e + "\n" + e.getMessage() + "\n" );
      e.printStackTrace();
    }
  }


  private  boolean getConns(String Conns,Hashtable conns,Vector dbNames) throws Exception {

    String conString;
    JDBCPool brkr;
    Connection tmpCon;
    Enumeration connsGotten;
    int i;
    //synchronized (dbs) {
      if (this.numDbs != 0) {

        StringTokenizer tok = new StringTokenizer(Conns,",",false);

        while (tok.hasMoreTokens()) {
          conString = tok.nextToken();
          brkr = (JDBCPool) dbs.get(conString);
          tmpCon = null;
          tmpCon = brkr.getConnection();
          dbNames.add(tmpCon.toString());
          if (tmpCon == null) {
            //there are no more connections to use and waiting has timed out
            System.out.println("No Conns!");
            connsGotten = conns.keys();
            while (connsGotten.hasMoreElements()) {
              //return all aquired connections
              conString = (String) connsGotten.nextElement();
              brkr = (JDBCPool) dbs.get(conString);
              tmpCon = (Connection) conns.remove(conString);
              
              brkr.freeConnection(tmpCon);
              return false;
            }
          }
           //System.out.println(conString + "  " + tmpCon); 
          conns.put(conString,tmpCon);
        }
        return true;
      }
      return true;
          //end loadConns
    //}
  }

 private  void returnConns(String Conns, Hashtable conns,Vector dbNames) throws Exception {
     String conString;
     JDBCPool brkr;
     Connection tmpCon;
     StringTokenizer tok = new StringTokenizer(Conns,",",false);
     int i = 0;
     //synchronized (dbs) {
       if (numDbs != 0) {

         //conns = rep.getConns();
         conns = null;  //the connection will be returned by name, not object
         
         
         while (tok.hasMoreTokens()) {
           conString = tok.nextToken();
           brkr = (JDBCPool) dbs.get(conString);
           /*if (brkr == null) {
             System.out.println("Broker Aint THERE!");
             while (brkr == null) {
               wait();
               brkr = (JDBCPool) dbs.remove(conString);
             }
             notifyAll();

           }*/
           
              
           brkr.freeConnection((String) dbNames.elementAt(i));
           i++;
           //dbs.put(conString,brkr);
           //notifyAll();
         }
       }
     //}
  }
 


  private IDRSReport getReport (HttpServletResponse resp, HttpServletRequest req, PrintWriter out,File f,Thread thread,IDRSSecurity secure, Hashtable conns, String IDRSLocation) throws Exception {
    String src = secure.getSrc();
    IDRSReport rep;
    //repName = "";
    
    boolean isJSP ;
   
      rep = (IDRSReport) idrss.checkOut(0);
      //repName = rep.toString();
      
      if (rep == null)  
         throw new Exception("An error has occured trying to get the report");
   
    
    
    
    
    try {


      if (req.getParameter("isJSP").equalsIgnoreCase("true")){
        String fname = contextPath + "trash/" + Integer.toString(thread.hashCode()) + ".jsp";
        f = new File(fname);
        out = new PrintWriter(new FileOutputStream(f), true);


        rep.init(out,src,false,secure.getUserID(),conns,secure.getDocID(),IDRSLocation,req.getSession(true),req);
      }
      else {
        rep.init(resp.getWriter(),src,false,secure.getUserID(),conns,secure.getDocID(),IDRSLocation,req.getSession(true),req);
      }
    }
    catch (Exception e) {
      rep.init(resp.getWriter(),src,false,secure.getUserID(),conns,secure.getDocID(),IDRSLocation,req.getSession(true),req);
    }

    return rep;
  }

  private void addVars(HttpServletRequest req, IDRSReport rep,Hashtable dbCache,String params) throws Exception {
    StringTokenizer tok = new StringTokenizer(params, ":", false);
    String currentDB = "";
    String valName;
    String param;
    String db;
    while (tok.hasMoreTokens()) {
      param = tok.nextToken();
      db = param.substring(0, param.indexOf("_"));
      valName = param.substring(param.indexOf("_") + 1);
      if (! db.equalsIgnoreCase(currentDB)) {
        rep.addVarList(db);
        currentDB = db;
      }
      if (param.indexOf("Reset") != -1) {
        try {
          if (req.getParameter(param).equalsIgnoreCase("true"))
            dbCache.remove(db);
        }
        catch (Exception ignore){}
      }
      else if (param.indexOf("PageSize") != -1) {
        rep.setPageSize(db,Integer.parseInt((String) req.getParameter(param)));
      }
      else if (param.indexOf("FirstRecord") != -1) {
        rep.setPageFirst(db,Integer.parseInt((String) req.getParameter(param)));
      }
      else if (param.indexOf("UserID") != -1) {
        rep.addVar("UserID",db);
        rep.addVarName("ignore",db);
      }
      else if (param.indexOf("Dataset") != -1) {
        rep.addVar("Dataset",db);
        rep.addVarName("ignore",db);
      }
      else if (param.indexOf("Scripter") != -1) {
        rep.addVar("Scripter",db);
        rep.addVarName("ignore",db);
      }
      else if (param.indexOf("Connection") != -1) {
        rep.addVar("Connection",db);
        rep.addVarName("ignore",db);
      }
      else {
        rep.addVar((String) req.getParameter(param),db);
        rep.addVarName(valName,db);
      }
    }

  }

  private void procIDRS(HttpServletRequest req, HttpServletResponse resp) throws ServletException, Exception {
    //long beginTime = System.currentTimeMillis();
    boolean quit = false;
    int docID = -1;
    String docName = "";
    //leave
    try {
      docID = Integer.parseInt(req.getParameter("doc_ID"));
    }
    catch (Exception e) {
      docName = req.getParameter("doc_Name");
    }
    HttpSession session = req.getSession(true);
    resp.setContentType("text/html");
    String user = "", pass = "";
    //end leave

   String repName = "";
    //leave
    try {
      user = (String) session.getValue("user");
      pass = (String) session.getValue("pass");

      if (user == null) {
        user = (String) req.getParameter("user");
        pass = (String) req.getParameter("pass");
      }
    }
    catch (Exception E) {
      resp.getWriter().println("<H1>Error</H1>");
      resp.getWriter().println(E + "\n" + E.getMessage() + "\n" + E.toString());
      quit = true;
    }
    //end leave

    String IDRSLocation = IDRSName;
    IDRSSecurity secure;
    String Conns = "";
    String params;
    IDRSReport rep;
    Connection con;
    PrintWriter out = null;
    Hashtable dbCache;
    Thread thread = Thread.currentThread();
    File f = null;
    RequestDispatcher serv;
    Vector dbNames = new Vector();

      if (! quit) {
        con = idrsDBs.getConnection();

        if (docID != -1)
          secure = new IDRSSecurity(docID, user, pass, con, toLower);
        else
          secure = new IDRSSecurity(docName, user, pass, con, toLower);

        params = secure.getParamNames();
        String conString = "";
          //DbConnectionBroker brkr;
          Connection tmpCon;

        dbCache = (Hashtable) session.getAttribute("DbCache");
        session.removeAttribute("DbCache");

        if (dbCache == null)
          dbCache = new Hashtable();


        if (params != null) {
          conns = new Hashtable();
          if (getConns(secure.getConns(),conns,dbNames)) {
            rep = getReport(resp,req,out,f,thread,secure,conns,IDRSLocation);
            repName = rep.toString();
            addVars(req,rep,dbCache,params);
            rep.setCache(dbCache);
            try {
              rep.buildReport();
            }
            catch (Exception repE) {
              if (out == null) {
                resp.getWriter().println("<h1>IDRS ERROR: An error occurred while building the report - " + repE + "</h1><br>");
                repE.printStackTrace(resp.getWriter());
              }
              else {
              	 out.println("<h1>IDRS ERROR: An error occurred while building the report - " + repE + "</h1>");              
              }
            }
            rep.cleanUp();
            returnConns(secure.getConns(),rep.getConns(),dbNames);
            dbCache = rep.getCacheDBs();
            session.setAttribute("DbCache",dbCache);
            
            
            secure.close();
            idrsDBs.freeConnection(con);
            
            idrss.checkIn(repName);
            session.putValue("user",user);
            session.putValue("pass",pass);
            rep = null;
            secure = null;
            dbNames = null;
            try {
               //if out doesn't exist, then there is no jsp!
               out.close();
               ServletContext sc = getServletContext();
               sc.getRequestDispatcher("/trash/" + Integer.toString(thread.hashCode()) + ".jsp").forward(req,resp);
               f.delete();
            }
            catch (Exception noJSP) {
              //no need to trap an exception
              rep = null;
              secure = null;
              dbNames = null;
            }
          }
          else {
            resp.getWriter().println("<H1>Server is busy</H1>");
            resp.getWriter().println("<H2>The server is currently busy, please try again later</H2>");
            rep = null;
            secure = null;
            dbNames = null;
          }
        }
        else {
          if (! quit) {
            secure.close();
            idrsDBs.freeConnection(con);

            resp.getWriter().println("<H1>Access Denied</H1>");
            resp.getWriter().println("<H2>Hit Backspace and re-enter your username and password</H2>");
            rep = null;
            secure = null;
            dbNames = null;
          }
        }
      }
      else {

        resp.getWriter().println("<H1>Access Denied</H1>");
            resp.getWriter().println("<H2>Hit Backspace and re-enter your username and password</H2>");
            rep = null;
            secure = null;
            dbNames = null;
          }
     if (out != null)
       out.close();
       
     resp.getWriter().close();

  }
  public void destroy() {

    super.destroy();
  }
}









