package net.sourceforge.idrs.core;

import net.sourceforge.idrs.utils.DB;
import java.util.*;
import java.io.*;
import java.sql.*;
/**
  *IDRSSecurity
  * Copyright (C) 2000 Marc Boorshtein under the GNU General Public License offered
  * without warenty
  *Used to verify that a user has access to a particuler document
  *@author: Marc Boorshtein
 */
public class IDRSSecurity {

  private boolean isOK, docRetrieved;
  private DB doc, user, group;
  private String docName, userName, password;
  int docID;
  BufferedReader in;
  private boolean toLower;



  /*
   *Constructor used to check against docname and a premade DB object for object pools
  */
  public IDRSSecurity(String docName,String userName,String password, Connection con,boolean toLower) throws Exception {
    this.docID = -1;
    this.docName = docName;
    this.userName = userName;
    this.password = password;
    this.doc = doc;
    this.user = user;
    isOK = false;
    docRetrieved = false;
    doc = new DB("Doc");
    doc.setConnection(con);
    user = new DB("User");
    user.setConnection(con);
    this.toLower = toLower;

  }
  /*
   *Constructor used to check against docname and a premade DB object for object pools
  */
  public IDRSSecurity(int docID,String userName,String password, Connection con,boolean toLower) throws Exception {
    this.docID = docID;
    this.docName = null;
    this.userName = userName;
    this.password = password;
    this.doc = doc;
    this.user = user;
    isOK = false;
    docRetrieved = false;
    doc = new DB("Doc");
    doc.setConnection(con);
    user = new DB("User");
    user.setConnection(con);
    this.toLower = toLower;
  }

  /*
   *returns the ID of the loged in user, secure
  */
  public int getUserID() throws Exception {
    String fldUserID = "UserID";
    if (toLower)
      fldUserID = fldUserID.toLowerCase();
    if (checkOK())
      return Integer.parseInt(user.getFieldData(fldUserID,null));
    else
      return -1;
  }

  public int getDocID() throws Exception {
    String fldDocID = "DocID";
    if (toLower)
      fldDocID = fldDocID.toLowerCase();
    if (checkOK())
      return Integer.parseInt(doc.getFieldData(fldDocID,null));
    else
      return -1;
  }
  private void retrieveDoc() throws Exception{
    if (! docRetrieved) {
      //retrive document
      String docSQL = "Select * FROM tblDoc WHERE ";
      if (docID != -1)
        docSQL += "DocID = " + docID + ";";
      else
        docSQL += "DocName = '" + docName + "';";

      doc.ProcSQL(docSQL,false);
      docRetrieved = true;
    }

  }

  /*
   *returns the source of a requested document, secure
  */
  public String getSrc() throws Exception {

      String fld_docSrc = "DocSrc";
      if (toLower)
        fld_docSrc = fld_docSrc.toLowerCase();
      //retrieve user information
      retrieveDoc();

      if (checkOK())
        return doc.getFieldData(fld_docSrc,null);
      else
        return null;



  }

  /**
   * Returns a string containing all of the connections needed by a report
   */
  public String getConns() throws Exception {
    String fld_docConns = "DocConns";
    if (toLower)
      fld_docConns = fld_docConns.toLowerCase();

    if (checkOK())
      return doc.getFieldData(fld_docConns,null);
    else
      return null;
  }

  /*
   *returns the HTML source for parameter input of a requested document, secure
  */
  public String getParamSRC() throws Exception {
    String fld_docParamSrc = "DocParamSrc";
    if (toLower)
        fld_docParamSrc = fld_docParamSrc.toLowerCase();

    if (checkOK())
      return doc.getFieldData(fld_docParamSrc,null);
    else
      return null;
  }


  /*
   *returns the names of all parameters and the data sets, secure
  */
  public String getParamNames() throws Exception {
    String fld_docParams = "DocParams";
    if (toLower)
        fld_docParams = fld_docParams.toLowerCase();

    retrieveDoc();
    if (checkOK())
        return doc.getFieldData(fld_docParams,null);
      else
        return null;
  }
  private boolean checkOK() throws Exception {


    if (! isOK) {
      String usrSQL = "SELECT * FROM tblUser WHERE Username = '" + userName + "';";
      user.ProcSQL(usrSQL,false);
      String fld_docGroups = "DocGroups";
      String fldGroupID = "GroupID";
      String fldPassword = "Password";
      if (toLower) {
        fld_docGroups = fld_docGroups.toLowerCase();
        fldGroupID = fldGroupID.toLowerCase();
        fldPassword = fldPassword.toLowerCase();
      }

      String allowed = doc.getFieldData(fld_docGroups,null);
      if (allowed.indexOf("-1") == -1) {
        String user = this.user.getFieldData(fldGroupID,null);
        String tblPass = this.user.getFieldData(fldPassword,null);

        int currentAllow, currentUser;
        StringTokenizer tokAllow = new StringTokenizer(allowed, ",", false);
        StringTokenizer tokUser;
        boolean passed = false;
        while ((tokAllow.hasMoreTokens()) && (!passed)) {
          currentAllow = Integer.parseInt(tokAllow.nextToken());
          tokUser = new StringTokenizer(user, ",", false);
          while ((tokUser.hasMoreTokens()) && (!passed)) {
            currentUser = Integer.parseInt(tokUser.nextToken());
            passed = (currentUser == currentAllow);
          }
        }
        isOK = passed  && (tblPass.equalsIgnoreCase(password));
        return isOK;
      }
      else {
        isOK = true;
        return isOK;
      }
    }
    else {
      return true;
    }

  }

  
  
  public void close() throws Exception {
    user.close();
    doc.close();
  }
  

}
