package net.sourceforge.idrs.core;


/****************************************************************************************
* Copyright (C) 2000 Marc Boorshtein under the GNU General Public License offered
* without warenty
*Class: CReport
*Purpose: using the DB class, parses an RML document and builds a new HTML document
****************************************************************************************/

import java.io.*;
import java.util.*;
import net.sourceforge.idrs.utils.pool.*;
import net.sourceforge.idrs.utils.*;
import java.sql.*;
//import ObjectStore;
import java.net.*;
import net.sourceforge.idrs.script.*;
import net.sourceforge.idrs.script.embedable.*;
//import IdrsDB;
import javax.servlet.http.*;
import javax.servlet.*;
//import IDRSScript;
//import IDRSScriptLanguage;
//import IDRSShell;

/**
 *Parses an RML document and produces a full HTML or JSP document
 *@author: Marc Boorshtein
 */
public class IDRSReport implements IDRSScript {
  int docID;
  int numDBsPaged = 0;
  PrintWriter out;
  String source;
  boolean isFile;
  BufferedReader in;
  int currentPos,
  lineNum;
  String DBName, DBDriver;
  Hashtable DBs;
  Hashtable vars;
  Hashtable lineNums;
  StringTokenizer tok;
  int userNum;
  Hashtable conns;
  boolean connLoaded;
  Hashtable color1;
  Hashtable color2;
  Hashtable tracking;
  Hashtable objects;
  boolean checkIsChange;
  boolean isChanged;
  Hashtable varLists;
  Hashtable pageSizes;
  Hashtable pageStart;
  Hashtable varsNames;
  Hashtable DBcache;
  //String IdrsURL;
  boolean isHTML;
  String IdrsUrl;
  HttpSession session;
  HttpServletRequest request;
  IDRSScriptLanguage idrs;
  IDRSShell me;
  
  
  public IDRSReport(String scriptClass) throws Exception {
    if (! scriptClass.equals("")) {
      idrs = (IDRSScriptLanguage) Class.forName(scriptClass).newInstance();
    }
    
    color1 = new Hashtable();
    color2 = new Hashtable();
    tracking = new Hashtable();
    objects = new Hashtable();
    varLists = new Hashtable();
    pageSizes = new Hashtable();
    pageStart = new Hashtable();
    varsNames = new Hashtable();
    lineNums = new Hashtable();
    vars = new Hashtable();
    DBs = new Hashtable();
    //this.DBcache = DBsCached;
    
  }

  /**
   *Pre:out is a valid PrintStream, soucre contains either a filename for or the source of
   *    an RML document , isFile says if source is a filename
   *Post:initializes as instance variables
   */
  public void init(PrintWriter out, String source, boolean isFile, int UserNum, Hashtable conns, int docId, String url,
                    HttpSession session, HttpServletRequest request) throws Exception {
    this.session = session;
    this.request = request;
    //used to print final report
    this.out = out;

    //souce for template, either a file path or the text of the document
    this.source = source;

    //tells the class wether or not this is a file
    this.isFile = isFile;

    //DBs = new Hashtable();
    //vars = new Hashtable();
    //lineNums = new Hashtable();
    if (isFile) {
      File f = new File(source);
      FileInputStream fis = new FileInputStream(f);
      InputStreamReader isr = new InputStreamReader(fis);
      in = new BufferedReader(isr);

    }
    else {
      tok = new StringTokenizer(source, "\n", false);

    }
    userNum = UserNum;
    this.currentPos = 0;
    this.conns = conns;
    this.numDBsPaged = 0;
    this.docID = docId;
    this.IdrsUrl = url;
    isHTML = true;
    //idrs = script;
  }
  
  public void setCache(Hashtable cache) throws Exception {
    this.DBcache = cache;
  }

  /**
  *Pre:none													     *
  *Post:if source was a file it reads a line from the file, else it reads until '\n' and
  *     returns that as a line
  */
  private String getLine() throws Exception {
    int startPos = this.currentPos, endPos = currentPos + 1;
    char c = '\n';

    if (isFile)
      return in.readLine();
    else {
      if (tok.hasMoreTokens()) {
        return tok.nextToken();
      }
      else
        return source.substring(source.lastIndexOf("\n"));
    }

  }

  /**
   *Public method for building the report.  once completed the report has benn fully built
  */
  public void buildReport() throws Exception {
    String useLine = getLine();
    String line = useLine.toLowerCase();
    if (line.indexOf("<rml>") != -1) {
      useLine = getLine();
      line = useLine.toLowerCase();
      String val;
      int start;
      int end;
      while (line.indexOf("<head") == -1) {
        if (line.indexOf("<ishtml>") != -1) {
          start = line.indexOf("<ishtml>") + 8;
          end  = line.indexOf("</ishtml>",start);
          val = useLine.substring(start,end);
          try {
            isHTML = Boolean.valueOf(val).booleanValue();  	
          }
          catch (Exception e) {
            throw new Exception("<IsHTML></IsHTML> may only contain TRUE or FALSE");	
          }
          useLine = getLine();
          line = useLine.toLowerCase();
          start = 0;
          end = 0;
        }
        else if (line.indexOf("<scriptclass>") != -1) {
          start = line.indexOf("<scriptclass>") + 13;
          end = line.indexOf("</scriptclass>");
          val = useLine.substring(start,end);
          if (idrs == null) {
            try {
              idrs = (IDRSScriptLanguage) Class.forName(val).newInstance();
            }
            catch (Exception e1) {
              throw new Exception(e1.toString() + " : Can't create script object");
          
            }
          }
          
          this.me = new IDRSShell(this);
          idrs.setVal("idrs",me);
          if (this.session != null) {
            idrs.importClass("javax.servlet.http.*");
            idrs.importClass("javax.servlet.*");
            
          }
          idrs.importClass("net.sourceforge.idrs.script.IDRSScript");
          idrs.importClass("net.sourceforge.idrs.script.embedable.IDRSShell");
          idrs.importClass("net.sourceforge.idrs.core.IDRSReport");
          
          idrs.importClass("java.io.PrintWriter");
          idrs.setVal("out",this.out);
          useLine = getLine();
          line = useLine.toLowerCase();
          start = 0;
          end = 0;
          	
        }
        else {
          out.println(useLine);	
        }
      }
      if (isHTML) {
        out.println(useLine);	
      }
      
    }
    else {
      out.println(useLine);	
    }
    readHeader();
    readBody();
    source = null;
    //cleanUp();
  }

  /**
   * Cleans up the report for destruction, caches all cached db's and extracts
   * all connections
   */
  public void cleanUp() throws Exception {
    Enumeration e = DBs.keys();
    String key;
    DB db;
    Connection con;

    this.DBcache = null;
    this.DBcache = new Hashtable();
    Hashtable hold = new Hashtable();
        Enumeration notUsedConns = conns.keys();
        String i;
        Object tmp;
        while (notUsedConns.hasMoreElements()) {
          i = (String) notUsedConns.nextElement();
          tmp = conns.remove(i);
          hold.put(i,tmp);	
        }
       
    while (e.hasMoreElements()) {
      key = (String) e.nextElement();
      db = (DB) DBs.remove(key);
      con = db.getConnection();

      if (! db.getDBName().equalsIgnoreCase(""))
        if (db.shouldPool())
          this.conns.put(db.getDBName(),con);

      if (db.getIsPaged()) {
        this.DBcache.put(key,db);
      }
      else {
        db.close();
      }
      
      
        notUsedConns = hold.keys();
        while (notUsedConns.hasMoreElements()) {
          i = (String) notUsedConns.nextElement();
          tmp = hold.remove(i);
          conns.put(i,tmp);	
        }

    }
    
    lineNums.clear();
    color1.clear();
    color2.clear();
    tracking.clear();
    objects.clear();
    varLists.clear();
    pageSizes.clear();
    pageStart.clear();
    varsNames.clear();
    DBs.clear();
    vars.clear();
    out = null;
    //idrs = null;
  }

  /**
   * Retrieves all connections used by the report
   */
  public Hashtable getConns() throws Exception {
    return this.conns;
  }

  /**
  *Pre: All DB information is between seperated <HEAD></HEAD> tags and is structured
  *     perse the RML specs
  *Post: All none RML tags are printed to the final document, all RML tags are processesd
  */
  private void procVarList(String line, String useLine) throws Exception {
    int start = line.indexOf("\"") + 1;
    int end = line.indexOf("\"",start);
    String ID = useLine.substring(start,end);

    Vector tmpVec = new Vector();
    useLine = getLine();
    line = useLine.toLowerCase();
    while (line.indexOf("</varlist>") == -1) {
      if (line.indexOf("<vartype>") != -1) {
        start = line.indexOf("<vartype>") + 9;
        end = line.indexOf("</vartype>");
        tmpVec.add(getClass(useLine.substring(start,end)));
      }
      else {//wants a result set
        start = line.indexOf("<dbresult>") + 10;
        end = line.indexOf("</dbresult>",start);

        tmpVec.add(useLine.substring(start,end));

      }
      useLine = getLine();
      line = useLine.toLowerCase();

    }
    varLists.put(ID,tmpVec);
    tmpVec = null;
  }

  /**
   * Reads in classname and passes it to an objectstore
   */
  private void procObjClss(String line,String useLine,ObjectStore tmpObj) throws Exception {
    int start = line.indexOf("<class>") + 7;
    int end = line.indexOf("</class>");
    tmpObj.setClassName(useLine.substring(start,end));
  }

  /**
   * reads in a datapage, retrieves datacache, sets up datapage for this report,
   * retruns db
   */
  private DB procDBPage(String line, String useLine,DB db) throws Exception {
    DB dbToReturn;
    String ID = db.getID();
    if (this.DBcache.containsKey(ID)) {
      dbToReturn = null;
      dbToReturn = (DB) DBcache.remove(ID);
      dbToReturn.wasCached(true);
    }
    else {
      dbToReturn = db;
      dbToReturn.wasCached(false);
    }

    dbToReturn.setIsPaged(true);
    int start = line.indexOf("<pagesize>") + 10;
    int end = line.indexOf("</pagesize>");
    int numRecs = 0;
    int firstRec = 0;
    Integer tmp;

    //Hashtable pageInfo = (Hashtable) vars.remove(db.getID());b
    if (line.substring(start,end).indexOf("<external>") != -1) {
      tmp = (Integer) this.pageSizes.remove(db.getID()) ;
      numRecs = tmp.intValue();
      this.pageSizes.put(dbToReturn.getID(),tmp);
    }
    else {
      try {
        numRecs = Integer.parseInt(useLine.substring(start,end));
      }
      catch (NumberFormatException e) {
        e.printStackTrace();
      }
    }

    dbToReturn.setNumRecs(numRecs);

    if (numRecs <= 0) throw new Exception(numRecs + " is less then 0, number of records must be greater then 0");

    tmp = (Integer) this.pageStart.remove(db.getID());
    if (tmp.intValue() != 0) {
      firstRec = tmp.intValue();
      if (firstRec < 0) throw new Exception("First Record may not be less then 0");
    }
    this.pageStart.put(db.getID(),tmp);

    if (dbToReturn.wasCached()) {

      dbToReturn.moveTo(firstRec);
    }

      dbToReturn.startWith(firstRec);

    //vars.put(db.getID(),pageInfo);
    this.numDBsPaged++;
    tmp = null;
      return dbToReturn;

  }

  /**
   * Reads in a constructor's <vartype>s and passes them to a objectstore
   */
  private void procObjConstructor(String line,String useLine, ObjectStore tmpObj,String ID) throws Exception {
    Vector tmpVec = new Vector();
    int start = 0;
    int end  = 0;
    useLine = getLine().trim();
    line = useLine.toLowerCase();
    Class[] argCls;
    Object[] args;
    while (line.indexOf("</constructor>") == -1) {
      start = line.indexOf("<vartype>") + 9;
      end = line.indexOf("</vartype>");
      tmpVec.add(getClass(useLine.substring(start,end)));
      start = 0;
      end  = 0;
      useLine = getLine().trim();
      line = useLine.toLowerCase();
    }

   int place;
    try {
      Vector objVec = (Vector) vars.remove(ID);
      if (objVec != null) {
        if (objVec.indexOf("UserID") >= 0) {
          place = objVec.indexOf("UserID");
          objVec.remove(place);
          objVec.insertElementAt(Integer.toString(userNum),place);
        }
        if (objVec.indexOf("Scripter") >= 0) {
          place = objVec.indexOf("Scripter");
          objVec.remove(place);
          objVec.insertElementAt(this,place);
        
        }	
        argCls = new Class[tmpVec.size()];
        args = tmpVec.toArray();
        System.arraycopy(args,0,argCls,0,argCls.length);
        tmpObj.initiate(argCls,objVec.toArray());
      }
      else {//empty constructor
        tmpObj.initiate(new Class[0],new Object[0]);
      }
    }
    catch (Exception e) {

      //tmpObj.initiate(new Class[0],new Object[0]);
    }
    argCls = null;
    args = null;  
    tmpVec = null; 

  }

  /**
   * Reads in a methods atributes and passes them to an objectstore
   */
  private void procObjMethod(String line, String useLine,ObjectStore tmpObj) throws Exception {
    Vector tmpVec;
    String methodName;
    //first line should be <name>
    int start = 0;
    int end  = 0;
    useLine = getLine().trim();
    line = useLine.toLowerCase();
    start = line.indexOf("<name>") + 6;
    end = line.indexOf("</name>");
    methodName = useLine.substring(start,end);
    start = 0;
    end  = 0;
    useLine = getLine().trim();
    line = useLine.toLowerCase();
    tmpVec = new Vector();
    while (line.indexOf("</method>") == -1) {
      start = line.indexOf("<vartype>") + 9;
      end = line.indexOf("</vartype>");
      Class tmpClss = getClass(useLine.substring(start,end));
      tmpVec.add(tmpClss);
      start = 0;
      end  = 0;
      useLine = getLine().trim();
      line = useLine.toLowerCase();
    }

    //String tmp = tmpVec.toArray().getClass().toString();

    Class[] clss = new Class[tmpVec.size()];
    Object[] objs = tmpVec.toArray();
    System.arraycopy(objs,0,clss,0,objs.length);


    tmpObj.addMethod(methodName,clss);
    tmpVec = null;
    clss = null;
    objs = null;
  }

  /**
   * Reads in an <object> tag and creates an objectstore
   */
  private void procObject(String line, String useLine) throws Exception {
    Vector tmpVec, objVec;
    String methodName;
    int start = line.indexOf("\"",line.indexOf("id")) + 1;
    int end = line.indexOf("\"",start + 1);
    String ID = useLine.substring(start,end);
    useLine = getLine().trim();
    line = useLine.toLowerCase();
    start = 0;
    end = 0;
    ObjectStore tmpObj = new ObjectStore(ID);
    while (line.indexOf("</object>") == -1) {
      if (line.indexOf("<class>") != -1) {
        procObjClss(line,useLine,tmpObj);
        start = 0;
        end  = 0;
        useLine = getLine().trim();
        line = useLine.toLowerCase();
      }
      else if (line.indexOf("<constructor>") != -1) {
        procObjConstructor(line,useLine,tmpObj,ID);
        start = 0;
        end  = 0;
        useLine = getLine().trim();
        line = useLine.toLowerCase();
      }
      else if (line.indexOf("<method>") != -1) {
        procObjMethod(line,useLine,tmpObj);
        start = 0;
        end  = 0;
        useLine = getLine().trim();
        line = useLine.toLowerCase();
      }

    }

    objects.put(ID,tmpObj);
    tmpVec = null;
    objVec = null;
    tmpObj = null;
    
  }

  /**
   * Calls a given method for use in retrieving a vaild ResultSet
   */
  private void procDBMethod(String line,String useLine,DB db) throws Exception {
    int start = line.indexOf("\"",line.indexOf("objid")) + 1;
    int end = line.indexOf("\"",start + 1);
    String objid = useLine.substring(start,end);
    ObjectStore tmpObj = (ObjectStore) this.objects.remove(objid);
    //HERE HERE HERE HERE HERE
    start = end + 1;
    start = line.indexOf(">",start) + 1;
    end = line.indexOf("</usemethod>");
    String methodName = useLine.substring(start,end);
    Vector tmpVec = (Vector) this.vars.remove(db.getID());
    int location = tmpVec.indexOf("UserID");
    if (location >= 0) {
      tmpVec.remove(location);
      tmpVec.insertElementAt(Integer.toString(this.userNum),location);
    }

   location = tmpVec.indexOf("Scripter");
    if (location >= 0) {
      tmpVec.remove(location);
      tmpVec.insertElementAt(this,location);
    }
    db.setIDRS(this);
    db.procMethod(tmpObj,methodName,tmpVec);
    vars.put(db.getID(),tmpVec);
    objects.put(objid,tmpObj);
    tmpObj = null;
    tmpVec = null;
    objid = null;
  }

  /**
   *Prcesses and creates a new DB object and adds it to the DBs vector
   */
  private void procUseDB(String line, String useLine, DB db) throws Exception {
    int start = line.indexOf("<usedb>") + 7;

    int end = line.indexOf("</usedb>");
    String proc = useLine.substring(start,end);
    DB db1 = (DB) DBs.get(proc);
    db.setConnection(db1.getConnection());
    start = 0;
    end = 0;
    proc = null;
    db1 = null;
  }

  private void procDBDriver(String line, String useLine, DB db) throws Exception {
    int start = line.indexOf("<dbdriver>") + 10;
    int end = line.indexOf("</dbdriver>") ;
    String proc = useLine.substring(start,end);
    db.setDBDriver(proc);
    start = 0;
    end  = 0;
    proc = null;
  }

  private void procDBName(String line, String useLine, DB db) throws Exception {
    int start = line.indexOf("<dbname>") + 8;
    int end = line.indexOf("</dbname>") ;
    String proc = useLine.substring(start,end);
    proc = proc.trim();
    if (conns.containsKey(proc)) {
      Connection con = (Connection) conns.remove(proc);
      db.setConnection(con);
      db.setDBName(proc,false);
      connLoaded = true;
    }
    else {
      if (! db.getDBDriver().equals("")) {
        db.setDBName(proc,true);
        connLoaded = false;
      }
      else {
        
        
        throw new Exception("IDRS will only use Pooled Connections.");
      }
    }
    proc = null;
  }

  private void procDBUserName(String line, String useLine, DB db) throws Exception {
    int start = line.indexOf("<username>") + 10;
    int end = line.indexOf("</username>");
    if (! connLoaded) {
      db.setUserName(useLine.substring(start,end));
    }
  }


  private void procDBPass(String line,String useLine,DB db) throws Exception {
    int start = line.indexOf("<password>") + 10;
    int end = line.indexOf("</password>");
    if (! connLoaded)
      db.setPassword(useLine.substring(start,end));
  }

  private void procDirection(String line,String useLine, DB db) throws Exception {
    int start = line.indexOf("<direction>") + 11;
    int end = line.indexOf("</direction>");
    String dir = useLine.substring(start,end);
    if (dir.equalsIgnoreCase("INPUT")) {
      db.setDirection(DB.INPUT);  	
    }	
    else {
      db.setDirection(DB.OUTPUT);	
    }
  }
  
  private void procDB(String line, String useLine) throws Exception {
    String proc;
    Connection con;


    int start = line.indexOf("\"",line.indexOf("id")) + 1;
    int end = line.indexOf("\"",start + 1);
    String ID = useLine.substring(start,end);
    if (! vars.containsKey(ID))
      this.addVarList(ID);

    DBs.put(ID,new DB(ID));
    lineNums.put(ID,new Integer(0));
    DB db = (DB) DBs.remove(ID);
    start = 0;
    end  = 0;

    useLine = getLine();
    line = useLine.toLowerCase();
    while ((line.indexOf("</db>") == -1) ) {
      if (db.wasCached()) {
        while (line.indexOf("</db>") == -1) {
          useLine = getLine();
          line = useLine.toLowerCase();
        }
      }
      else if (line.indexOf("<pagesize>") != -1) {
        db = this.procDBPage(line,useLine,db);
        useLine = getLine();
        line = useLine.toLowerCase();
        start = 0;
        end = 0;
        DBs.remove(db.getID());
        DBs.put(db.getID(),db);
      }
      else if (line.indexOf("<usedb>",start) != -1) {
        procUseDB(line,useLine,db);
        start = 0;
        end = 0;
        useLine = getLine();
        line = useLine.toLowerCase();
      }
      else if (line.indexOf("<direction>",start) != -1) {
        procDirection(line,useLine,db);
        start = 0;
        end = 0;
        useLine = getLine();
        line = useLine.toLowerCase();
      }
      else if (line.indexOf("<dbdriver>",start) != -1) {
        procDBDriver(line,useLine,db);
        useLine = getLine();
        line = useLine.toLowerCase();
      }
      else if (line.indexOf("<dbname>",start) != -1) {
        procDBName(line,useLine,db);
        start = 0;
        end  = 0;
        useLine = getLine();
        line = useLine.toLowerCase();
      }
      else if (line.indexOf("<sql>",start) != -1) {
        useLine = getLine();
        line = useLine.toLowerCase();
        procSQL(db,false);
        useLine = getLine();
        line = useLine.toLowerCase();
        start = 0;
      }
      else if (line.indexOf("<storedproc>") != -1) {
        useLine = getLine();
        line = useLine.toLowerCase();
        procSQL(db,true);
        useLine = getLine();
        line = useLine.toLowerCase();
        start = 0;
      }
      else if (line.indexOf("<username>") != -1) {
        procDBUserName(line,useLine,db);

        useLine = getLine().trim();
        line = useLine.toLowerCase();
        start = 0;
      }
      else if (line.indexOf("<password>") != -1) {
        procDBPass(line,useLine,db);
        start = 0;
        end  = 0;
        useLine = getLine().trim();
        line = useLine.toLowerCase();
      }
      /*else if (line.indexOf("<pagesize>") != -1) {
        this.procDBPage(line,useLine,db);
        start = 0;
        end = 0;
        useLine = getLine();
        line = useLine.toLowerCase();
      } */
      else if (line.indexOf("<usemethod") != -1) {
        procDBMethod(line,useLine,db);
        start = 0;
        end  = 0;
        useLine = getLine().trim();
        line = useLine.toLowerCase();
      }
    }
    this.DBs.put(db.getID(),db);
    con = null;
    db = null;
 }

  /**
   * reads in the header of the report
   */
  private void readHeader() throws Exception {
    String ID;
    DB db;
    String line = getLine().trim(), proc;
    int	start = 0,
    end = 0;
    Connection con;
    String useLine = line;
    line = line.toLowerCase();
    Vector tmpVec, objVec;
    ObjectStore tmpObj;
    String methodName;
    while (line.indexOf("</head>") == -1) {
      if (line.indexOf("<varlist") != -1) {
        procVarList(line,useLine);
        start = 0;
        end  = 0;
        useLine = getLine().trim();
        line = useLine.toLowerCase();

      }
      else if (line.indexOf("<object") != -1) {
        procObject(line,useLine);
        start = 0;
        end  = 0;
        useLine = getLine().trim();
        line = useLine.toLowerCase();
      }
      else if (line.indexOf("<db") != -1) {
        procDB(line,useLine);
        useLine = getLine();
        line = useLine.toLowerCase();
      }
      else {
        out.println(useLine);
        start = 0;
        end = 0;
        useLine = getLine();
        line = useLine.toLowerCase();
      }
    }
    if (isHTML)
      out.println(useLine);
    tmpVec = null;
    objVec = null;
    tmpObj = null;
    methodName = null;

  }

  /**
   * Retrieves a Class based on a string
   */
  private Class getClass(String type) throws Exception {
    if (type.equalsIgnoreCase("int") ){
      return Class.forName("java.lang.Integer");
    }
    else if (type.equalsIgnoreCase("string")) {
      return Class.forName("java.lang.String");
    }
    else if (type.equalsIgnoreCase("date")) {
      return java.sql.Date.class;
    }
    else if (type.equalsIgnoreCase("time")) {
      return java.sql.Time.class;
    }
    else if (type.equalsIgnoreCase("userid")) {
      return java.lang.Integer.class;
    }
    else if (type.equalsIgnoreCase("connection")) {
      return java.sql.Connection.class;
    }
    else if (type.equalsIgnoreCase("boolean")) {
      return java.lang.Boolean.class ;
    }
    else if (type.equalsIgnoreCase("float")) {
      return java.lang.Float.class;
    }
    else if (type.equalsIgnoreCase("dataset")) {
      return IdrsDB.class;
    }
    else if (type.equalsIgnoreCase("scripter")) {
    	 return IDRSScript.class;
    }
    else
      return null;

  }

  /**
   *Pre: db is initialized
   *post: Processes <SQL></SQL> statement and retrieves data from DB
  */
  private void procSQL(DB db,boolean isProc) throws Exception {
    String line;
    String useLine;
    int start = 0, end = 0,i = 0;
    String rSQL = "",varType = "";
    useLine = getLine();
    line = useLine.toLowerCase();
    Vector varList;
    String term;

    if (isProc)
      term = "</storedproc>";
    else
      term = "</sql>";

    while (line.indexOf("</src>") == -1) {
      rSQL += useLine.trim() + " ";
      useLine = getLine();
      line = useLine.toLowerCase();
    }

      useLine = getLine();
      line = useLine.toLowerCase();

    
    
    while (line.indexOf(term) == -1) {
      start = line.indexOf("<vartype>") + 9;
      end = line.indexOf("</vartype>");
      varType = useLine.substring(start, end);
      varList = (Vector) vars.get(db.getID());
      if (varType.equalsIgnoreCase("UserID"))
        db.addVar(Integer.toString(userNum),"int");
      else
        db.addVar((String) varList.elementAt(i),varType);
      useLine = getLine();
      line = useLine.toLowerCase();
      i++;
    }
    db.ProcSQL(rSQL,isProc);
    varList = null;
  }

  /**
   *Processes the body of the RML document
  */
  private void readBody() throws Exception {
    String line;
    String useLine;
    useLine = getLine();
    line = useLine.toLowerCase();
    int start = 0;
    int lineNum;
    while (line.indexOf("</body>") == -1) {
      procLine(useLine,start,"");
      out.println();
      useLine = getLine();
      line = useLine.toLowerCase();
    }
    if (isHTML)
      out.println(useLine);

  }

  /**
   *recursivly parses each line of the RML document
  */
  private void procLine(String useLine,int start, String repID) throws Exception {
    int end = start;
    DB db;
    String methodName;
    String col1, col2;
    String varList;
    String line = useLine.toLowerCase();
    Object[] mess = {new String(""),new String("")};
    String temp, fieldname, format = null, data = "", ID, check;
    Vector trackLines = new Vector();
    String objId;
    ObjectStore obj;
    String val;
    Class cls;
    //ResultSet rs;
    Object tmpObj;
    if (start < line.length()) {
      if (line.indexOf("<usemethod",start) != -1) {
        end = line.indexOf("<usemethod",start);
        out.print(useLine.substring(start,end));
        start = end;
        start = line.indexOf("varlist",start);
        start = line.indexOf("=",start);
        start = line.indexOf("\"",start) + 1;
        end = line.indexOf("\"",start);
        varList = useLine.substring(start,end);
        start = line.indexOf("objid");
        start = line.indexOf("=",start);
        start = line.indexOf("\"",start) + 1;
        end = line.indexOf("\"",start);
        objId = useLine.substring(start,end);

        start = line.indexOf(">",end) + 1;
        end = line.indexOf("</usemethod>",start);
        methodName = useLine.substring(start,end);

        obj = (ObjectStore) objects.remove(objId);
        //create argument list

        Vector args = (Vector) varLists.remove(varList);
        Vector vals = (Vector) vars.remove(varList);
        Vector useArgs = new Vector();
        Enumeration valList = vals.elements();
        Enumeration clsList = args.elements();
        while (valList.hasMoreElements()) {
          val = (String) valList.nextElement();

          if (val.equalsIgnoreCase("dataset")) {

            ID = (String) clsList.nextElement();
            db = (DB) DBs.remove(ID);
            useArgs.add(new DBShell(db.getID(),db));



            //DBs.put(ID,db);
          }
          else if (val.equalsIgnoreCase("scripter")) {
            useArgs.add(this);
          }
          else {
            cls = (Class) clsList.nextElement();
            useArgs.add(ObjectStore.getValue(cls,val,null,this));
          }

        }

        try {
          out.print((String) obj.execMethod(methodName,useArgs.toArray()));

        }
        catch (Exception e) {
           //throw new Exception("useMethod doesn't return a string");
           e.printStackTrace();
        }
        Enumeration eargs = useArgs.elements();
        //Object obj;
        DBShell tmpShell;
        while (eargs.hasMoreElements()) {
          tmpObj = eargs.nextElement();
          if (tmpObj.getClass() == DBShell.class) {
            tmpShell = (DBShell) tmpObj;
            db = tmpShell.getDB();
            DBs.put(db.getID(),db);
          }

        }
        varLists.put(varList,args);
        vars.put(varList,vals);
        objects.put(objId,obj);
        start = end + 12;
        //procLine(useLine,start,repID);
      }
      else if (line.indexOf("<ifchange",start) != -1) {
        this.checkIsChange = true;
        start = line.indexOf("\"",line.indexOf("field")) + 1;
        end = line.indexOf("\"",start + 1);
        fieldname = useLine.substring(start,end);
        fieldname = fieldname.substring(fieldname.indexOf(".") + 1);
        start = line.length();
        try {
          check = (String) tracking.get(fieldname);
        }
        catch (Exception e) {check = null;}
        if (check != null) {
          db = (DB) DBs.get(repID);
          data = db.getFieldData(fieldname,null);
          if (! data.equalsIgnoreCase(check)) {
            this.isChanged = true;
            tracking.put(fieldname,data);
          }
          else {
            this.isChanged = false;
          }
        }
        else {
          db = (DB) DBs.get(repID);
          data = db.getFieldData(fieldname,null);
          tracking.put(fieldname,data);
          this.isChanged = true;
        }


      }
      else if (line.indexOf("<field",start) != -1) {
        end = line.indexOf("<field",start);

        temp = useLine.substring(start,end);

        out.print(temp);
        start = end + 6;
        end = line.indexOf("</field>",end);
        if ((line.indexOf("format",start) < end) && (line.indexOf("format",start) != -1)) {
          start = line.indexOf("\"", line.indexOf("format",start)) + 1;
          end = line.indexOf("\"",start);
          format = useLine.substring(start,end);
          start = line.indexOf(">",start) + 1;
          end = line.indexOf("</field>",end);
        }
        else
          start++;


        fieldname = useLine.substring(start,end);

        if (fieldname.equalsIgnoreCase("<LineNum>")){
          out.print(getLineNum(repID));
        }
        else if (fieldname.equalsIgnoreCase("<ForeColor>")) {
          lineNum = getLineNum(repID);
          if ((lineNum % 2) == 0) {
            out.print((String) color1.get(repID));
          }
          else {
            out.print((String) color2.get(repID));
          }

        }
        else if (fieldname.equalsIgnoreCase("<BackColor>")) {
          lineNum = getLineNum(repID);
          if ((lineNum % 2) == 0) {
            out.print((String) color2.get(repID));
          }
          else {
            out.print((String) color1.get(repID));
          }
        }
        else {

          ID = fieldname.substring(0,fieldname.indexOf("."));
          fieldname = fieldname.substring(fieldname.indexOf(".") + 1);
          db = (DB) DBs.get(ID);
          out.print(db.getFieldData(fieldname,format));
        }
        start = end + 8;
      }
      else if (line.indexOf("<inputresults>",start) != -1) {
        
        end = line.indexOf("<inputresults>",start);
        out.print(useLine.substring(start,end));
        start = end + 14;
        end = line.indexOf("</inputresults>",start);
        String id = useLine.substring(start,end);
        db = (DB) DBs.get(id);
        out.println(db.getUpdateResult());
        db = null;
        start = end + 15;
      }
      else if (line.indexOf("<repeat") != -1) {

        start = line.indexOf("\"",line.indexOf("id")) + 1;
        end = line.indexOf("\"",start + 1) ;
        ID = useLine.substring(start,end);

        try {
          start = line.indexOf("\"",line.indexOf("color1")) + 1;
          end = line.indexOf("\"",start ) ;
          col1 = useLine.substring(start ,end);
          color1.put(ID,col1);
          start = line.indexOf("\"",line.indexOf("color2")) + 1;
          end = line.indexOf("\"",start ) ;
          col2 = useLine.substring(start,end);
          color2.put(ID,col2);
        }
        catch (Exception e) {}
        Vector lines = new Vector();
        useLine = getLine();
        line = useLine.toLowerCase();
        while (line.indexOf("</repeat>") == -1) {

          lines.addElement(useLine);
          useLine = getLine();
          line = useLine.toLowerCase();
        }
        this.procRepeat(lines, ID);
        start = line.length();
      }
      else if (line.indexOf("<navnext>",start) != -1) {
        end = line.indexOf("<navnext>",start);
        out.println(useLine.substring(start,end));
        start = end + 9;
        end = line.indexOf("</navnext>",start);
        out.print(this.getNavTag(true,useLine.substring(start,end)));
        start = end + 10;


      }
      else if (line.indexOf("<navprev>",start) != -1) {

        end = line.indexOf("<navprev>",start);
        out.println(useLine.substring(start,end));
        start = end  + 9;
        end = line.indexOf("</navprev>",start);
        out.print(this.getNavTag(false,useLine.substring(start,end)));
        start = end + 10;
      }
      
      else if (line.indexOf("<$=",start) != -1) {
        end = line.indexOf("<$=",start);
        out.println(useLine.substring(start,end));
        start = end + 3;
        start = procEvalScript(line,useLine,start);  
        
      }
      else if (line.indexOf("<$",start) != -1) {
        end = line.indexOf("<$",start);
        out.println(useLine.substring(start,end));
        start = end + 2;
        start = procScript(line,useLine,start);  
        
      }
      else {
        if (line.indexOf("<body>",start) != -1) {
          if (isHTML) 
            out.print(useLine.substring(start));	  
        }
        else {
          out.print(useLine.substring(start));
        }
        start = line.length();
      }
      procLine(useLine,start,repID);
    }
    methodName = null;
    col1 = null;
    col2 = null;
    varList = null;
    line   = null;
    mess   = null;
    temp = null;
    fieldname = null;
    format = null;
    data  = null;
    ID = null;
    check = null;
    trackLines = null;
    objId = null;
    obj = null;
    val = null;
    cls = null;
    //ResultSet rs;
    tmpObj = null;
  }

 
  private int procEvalScript(String line, String useLine, int start) throws Exception {
    //read in the entire block, must be on one line
    int end = line.indexOf("$>");
    String cmd = useLine.substring(start,end).trim();
    //eval it
    out.print(idrs.eval(cmd));
    return end + 2;
  }
  
  private int procScript(String line, String useLine, int start) throws Exception {
    //read in the entire block
    String cmds = "";
    
    
    if (line.trim().equals("<$")) {
      useLine = getLine();
      line = useLine.toLowerCase();
      start = 0;
    }
   
    int i = start;
    
    while ((i < line.length()) &&(line.charAt(i) == " ".charAt(0) ))
      i++;
    start = i;
    while (line.indexOf("$>") == -1) {
      cmds += useLine.substring(start) + "\n";
      useLine = getLine();
      line = useLine.toLowerCase();    	
    }
      
    int end = line.indexOf("$>");
    if (end > start)
      cmds += useLine.substring(start,end);
    else 
      cmds += useLine.substring(0,end);
      
    
    //eval it
    idrs.exec(cmds);
    return end + 2;
  }
  
  /**
   * Used to retrieve a full <a> tag including what the tag goes around, if
   * there is no next, no text is returned when next is true.  If there is no
   * previous, then no text is returned when next is false
   */
  private String getNavTag(boolean next,String value) throws Exception {


      String url = this.IdrsUrl + "?doc_ID=" + Integer.toString(this.docID) + "&";

      String key;
      Enumeration e = vars.keys();
      DB db;
      Enumeration efields;
      Vector fields;
      Vector fieldNames;
      Enumeration eNames;
      String val;
      String fldKey;
      boolean breakit = false;
      int numDBs = 0;
      String tmpURL;
      boolean noPrev;
      while (e.hasMoreElements() && ! breakit) {
        key = (String) e.nextElement();
        if (DBs.containsKey(key)) {
          db = (DB) DBs.remove(key);



              fields = (Vector) vars.remove(key);
              fieldNames = (Vector) varsNames.remove(key);
              efields = fields.elements();
              eNames = fieldNames.elements();
              while (efields.hasMoreElements())  {
                val = (String) efields.nextElement();
                fldKey = (String) eNames.nextElement();
                if (! fldKey.equalsIgnoreCase("ignore")) {
                  url +=   key + "_" + fldKey + "=" + URLEncoder.encode(val) + "&";
                }
              }
              vars.put(key,fields);
              varsNames.put(key,fieldNames);

          if (db.getIsPaged()) {
            tmpURL = "";
            tmpURL +=  key + "_PageSize=" + URLEncoder.encode(Integer.toString(db.getNumRecs())) + "&";
            tmpURL += key + "_FirstRecord=";
            if (next) {
              //if (db.getHasNext()) {
                tmpURL += URLEncoder.encode(Integer.toString(db.getNumRecs() + db.getFirstRec()));

              //}
              breakit = ! db.getHasNext();

            }
            else {

              if (db.getFirstRec()  != 0) {
                tmpURL += URLEncoder.encode(Integer.toString(db.getFirstRec() - db.getNumRecs()));
                noPrev = false;
              }
              else {
                breakit = true;
                noPrev = true;
              }

            }

            tmpURL += "&";

            if (! breakit) {

              breakit = false;
              numDBs++;
            }
            else {
              breakit = false;
            }
            url += tmpURL;
          }

          DBs.put(key,db);
        }
        else {
          fields = (Vector) vars.remove(key);
          fieldNames = (Vector) varsNames.remove(key);
          efields = fields.elements();
          eNames = fieldNames.elements();
          while (efields.hasMoreElements())  {
            val = (String) efields.nextElement();
            fldKey = (String) eNames.nextElement();
            if (! fldKey.equalsIgnoreCase("ignore")) {
              url +=   key + "_" + fldKey + "=" + URLEncoder.encode(val) + "&";
            }
          }
          vars.put(key,fields);
          varsNames.put(key,fieldNames);
        }
      }

      if (numDBs > 0) {

        url = url.substring(0,url.length() - 1);
        

        key = null;
        e = null;
        db= null;
        efields= null;
        fields= null;
        fieldNames= null;
        eNames= null;
        val= null;
        fldKey= null;
        return "<a href=\"" + url + "\">" + value + "</a>";
      }
      else
{
        key = null;
        e = null;
        db= null;
        efields= null;
        fields= null;
        fieldNames= null;
        eNames= null;
        val= null;
        fldKey= null;
        return "";
      }

  }

  /**
   * Determines wether or not a resultset should continue going through records
   */
  private boolean rsContinue(DB db) throws Exception {
    boolean ok;
    boolean hasNext;
    if (db.getIsPaged()) {
      //hasNext = db.next();



      return ((db.getNumRecs() > (db.getCurrLocation() - db.getFirstRec())) && db.next());

    }
    else {
      return (db.next());
    }
  }

  /**
   *processes given lines for each record in the given DB
  */
  private void procRepeat(Vector lines, String ID) throws Exception {
    int i;
    Enumeration list;
    String line;
    String useLine;
    lineNum = 0;
    DB db = (DB) DBs.get(ID);
    while (this.rsContinue(db)) {

      addLineNum(ID);
      list = lines.elements();
      while (list.hasMoreElements()) {
        useLine = (String) list.nextElement();
        if (this.checkIsChange) {
          if (this.isChanged) {
            line = useLine.toLowerCase();
            while (line.indexOf("</ifchange>") == -1) {
              procLine(useLine,0,ID);
              useLine = (String) list.nextElement();
              line = useLine.toLowerCase();
            }
            checkIsChange = false;
          }
          else {
            line = useLine.toLowerCase();
            while (line.indexOf("</ifchange>") == -1) {
              useLine = (String) list.nextElement();
              line = useLine.toLowerCase();
            }
            checkIsChange = false;
          }
        }
        else {
          line = useLine.toLowerCase();
          procLine(useLine,0,ID);
          out.println();
        }
      }

    }
    list = null;
    line = null;
    useLine = null;
    
    db = null;
  }

  /*
   *returns the line number of current db
  */
  private int getLineNum(String ID) throws Exception {
    Integer Num = (Integer) lineNums.get(ID);
    return Num.intValue();
  }

  /*
   *increases the line num of given db
  */
  private void addLineNum(String ID) throws Exception {
    Integer Num = (Integer) lineNums.get(ID);
    int num = Num.intValue();
    num++;
    lineNums.put(ID,new Integer(num));
  }

  /**
   *adds a list of parameters
  */
  public void addVarList(String ID) throws Exception {
    vars.put(ID, new Vector());
  }

  /**
   *removes a list of variables
  */
  public void removeVarList(String ID) throws Exception {
    vars.remove(ID);
  }

  /**
   *clears the var list
  */
  public void clearVarList() throws Exception {
    vars.clear();

  }

  /**
   *adds a value to a variable list
  */
  public void addVar(String val, String ID) throws Exception {
    Vector list = (Vector) vars.get(ID);
    list.addElement(val);
    vars.put(ID,list);
  }


  /**
   * Needed for the idrs servlet in order to generate next and previouse links
   */
  public void addVarName(String val, String ID) throws Exception {
    if (! varsNames.containsKey(ID)) {
      varsNames.put(ID,new Vector());
    }
    Vector names = (Vector) varsNames.remove(ID);
    names.add(val);
    varsNames.put(ID,names);
    names = null;
  }
  /**
   *removes a value from a variable list
  */
  public void removeVar(int index,String ID) throws Exception {
    Vector list = (Vector) vars.get(ID);
    list.removeElementAt(index);
    vars.put(ID,list);
  }

  /**
   *changes a value in a variable list
  */
  public void editVar(int index, String val,String ID) throws Exception {
    Vector list = (Vector) vars.get(ID);
    list.set(index, val);
    vars.put(ID,list);
  }

  /**
   *clears a variable list for a db
  */
  public void clearVars(String ID) throws Exception {
    Vector list = (Vector) vars.get(ID);
    list.clear();
    vars.put(ID,list);
  }

  /**
   * Sets the pagesize for a report's db
   */
  public void setPageSize(String db,int size) throws Exception {
    if (this.pageSizes.containsKey(db)) {
       pageSizes.remove(db);
    }
    pageSizes.put(db,new Integer(size));
  }

  /**
   * Sets the first record for a report's db
   */
  public void setPageFirst(String db,int first) throws Exception {
    if (this.pageStart.containsKey(db)) {
      pageStart.remove(db);
    }
    pageStart.put(db,new Integer(first));
  }

  public Hashtable getCacheDBs() throws Exception {
    return this.DBcache;
  }

  /***********************************************************
   This section is the implementation of the IDRSScript object
  ************************************************************/
  
   /**
    Used to retrieve a piece of data from a particuler DB with a given format
    */
    public String getFieldData(String db,String field,String format) throws Exception {
      try {
       
        DB Db = (DB) DBs.get(db);
        if (Db == null)
          throw new Exception("DB " + db + " no found");
        return Db.getFieldData(field,format);
      } 
      catch (Exception e) {
        throw e;	
      }	
    }
    
    /**
    Used to retrieve a piece of data from a particuler DB without format
    */
    public String getFieldData(String db,String field) throws Exception {
      return getFieldData(db,field,null);	
    }
    
    /**
     Used to move to the next record in a selected db
     */
    public boolean next(String db) throws Exception {
      DB Db = (DB) DBs.get(db);
      if (Db == null) 
        throw new Exception("DB " + db + " no found");
      return Db.next();
    }
    /**
     Used to move to a particuler record
     */
    public boolean moveTo(String db, int record) throws Exception {
      DB Db = (DB) DBs.get(db);
      if (Db == null) 
        throw new Exception("DB " + db + " no found");
      return Db.moveTo(record);	
    }
    
    /**
     Used to retrieve a refrence to an object created in an IDRS report
    */
    public Object getObject(String obj) throws Exception {
      try {
        ObjectStore objstr = (ObjectStore) objects.get(obj);
        if (objstr == null)
          throw new Exception("No Object defined : " + obj);
          
        return objstr.getRef();
      }
      catch (Exception e) {
        throw new Exception("No Object defined : " + obj);	
      }
      
    }
    
    /**
     retrieves printwriter used by the IDRS
    */
    public PrintWriter getOut() throws Exception {
      return out;	
    }
    
    /**
     Retrieves the session object from webserver
    */
    public HttpSession getSession() throws Exception {
      return session;	
    }
    
    /**
     Retrieves request object from webserver
    */
    public HttpServletRequest getRequest() throws Exception {
      return request;	
    }
    
    /**
     Used to retrieve the results of an update
    */
    public int getInputResults(String db) throws Exception {
      try {
       
        DB Db = (DB) DBs.get(db);
        if (Db == null)
          throw new Exception("DB " + db + " no found");
        return Db.getUpdateResult();
      } 
      catch (Exception e) {
        throw e;	
      }
    }
}
