package net.sourceforge.idrs.core;

import net.sourceforge.idrs.utils.pool.ObjectPool;
import net.sourceforge.idrs.utils.pool.PooledObject;
//import IDRSReport;

public class IDRSPool extends ObjectPool {
  protected String scriptClass;
  
  public IDRSPool(int objectMin, int objectLimit, long daysOpen, long sleepTime, String path,int trys,String scriptClass) throws Exception {
    super(objectMin, objectLimit, daysOpen,sleepTime,path,trys);
    
    this.scriptClass = scriptClass;
    
    logHeader();
    PooledObject pobj;
    if (objectMin >= 0) {
      for (int i = 0; i < objectMin;i++) {
	   pobj = create();
	    
	   pobj.isFree(true);
	   this.pool[count] = pobj;
	   count++;
	 }
    }
  }
  
  public void logHeader() throws Exception {
    out.println("Starting PoolMan, IDRS version");
    out.println("IDRS Report Pool");
    out.println("Script Class : " + scriptClass);
    out.println("log file = " + logPath); 
    out.println("min objects = " + Integer.toString(minn));
    out.println("max objects = " + Integer.toString(limit));
    out.println("Total refresh intervel = " + Long.toString(daysOpen) + " days");
    out.println("-----------------------------------------");	
  }
  
  protected PooledObject create() throws Exception {
    try {
      IDRSReport idrs = new IDRSReport(scriptClass);
      java.util.Date now = new java.util.Date(System.currentTimeMillis());
      out.println(now.toString() + " Opening report " + count + " " + idrs.toString());
      return new PooledObject(System.currentTimeMillis(),true,idrs);	
    }
    catch (Exception e) {
      java.util.Date now = new java.util.Date(System.currentTimeMillis());
      out.println(now.toString() + " Opening report error " + count + " : " + e);	
      return null;
    }
    	    
  }
  
  protected boolean validate(PooledObject o) {
    IDRSReport idrs = (IDRSReport) o.getValue();
    try {
      return ! (idrs == null);
    } catch(Exception e) {
      out.println(e);
    }
    return false;
  }
  
  protected void expire(PooledObject o) {
	
	try {
	  o.setValue(null);
	}
	catch (Exception e) {
	  out.println(e);
	}
    }
    
  protected void reset(int index) {
    try {
      pool[index].setValue(null);
      pool[index] = null;
      out.println("----->Resetting connection " + index + " ...");
      int tmpCount = count;
      count = index;
      pool[index] = create();
      count = tmpCount;
    }	
    catch (Exception e) {
      out.println(e);	
    }
  }
    
}