package net.sourceforge.idrs.core;
/*
 * IDRSParams.java
 * Copyright (C) 2000 Marc Boorshtein under the GNU General Public License offered
 * without warenty
 * Created on March 26, 2000, 12:43 PM
 */
import javax.servlet.http.*;
import javax.servlet.*;
//import IDRSSecurity;
import java.io.*;
import java.util.*;
import java.sql.*;
import net.sourceforge.idrs.utils.DB;
import net.sourceforge.idrs.jdbc.JDBCPool;

/**
 *
 * @author  root
 * @version
 */
public class IDRSParams extends HttpServlet {
  private String dbName,
          dbDriver,
          IDRSPath,
          dbPass,
          dbUser,
          contextPath,
          logPath;
  private long daysToReset;
  private int minConns, maxConns;
  private boolean toLower;

  private JDBCPool idrsDBs;

  /** Creates new IDRSParams */
  public IDRSParams()   {
  }

  public void init(ServletConfig svg) throws ServletException {

    dbDriver = svg.getInitParameter("dbDriver");
    dbName = svg.getInitParameter("dbName");
    dbUser = svg.getInitParameter("dbUser");
    if (dbUser == null)
      dbUser = "";
    dbPass = svg.getInitParameter("dbPass");
    if (dbPass == null)
      dbPass = "";
    String lower = svg.getInitParameter("toLower");
    if  (lower == null)
      toLower = false;
    else
      toLower = lower.equalsIgnoreCase("true");


    contextPath = svg.getInitParameter("contextPath");
    minConns = Integer.parseInt(svg.getInitParameter("minConns"));
    maxConns = Integer.parseInt(svg.getInitParameter("maxConns"));
    daysToReset = Long.parseLong(svg.getInitParameter("daysOpen"));
    logPath = svg.getInitParameter("logPath");
    try {
      //idrsDBs = new JDBCPool(dbDriver,dbName,dbUser,dbPass,minConns,maxConns,logPath,daysToReset);
      idrsDBs = new JDBCPool("IDRSServlets",dbDriver,dbName,dbUser,dbPass,minConns,maxConns,daysToReset,2000,logPath,10);
    }
    catch (Exception e) {
      try {
         //System.out.println(e);
         e.printStackTrace();
      }
      catch (Exception e2) {}
    }
    IDRSPath = svg.getInitParameter("whereIsIDRS");

    super.init(svg);
  }

  public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
    try {
      procParams(req,resp);
    }
    catch (Exception e) {
      e.printStackTrace();
    }

  }

  private void procParams(HttpServletRequest req, HttpServletResponse resp) throws Exception {

    DB db = new DB("Params");
    PrintWriter out;
    Connection con;
    boolean quit = false;
    int docID = -1;
    String docName = "";
    try {
      docID = Integer.parseInt(req.getParameter("doc_ID"));
    }
    catch (Exception e) {
      docName = req.getParameter("doc_Name");
    }

    HttpSession session = req.getSession(true);

    out = resp.getWriter();

    resp.setContentType("text/html");
    out.println("<form method=\"POST\" action = \"" + IDRSPath + "\">");
    String user = "", pass = "";

    String SQL = "SELECT DocVarSrc FROM tblDoc WHERE ";
    String src = "";
    user = (String) session.getValue("user");
    con = idrsDBs.getConnection();
    if (con == null)
      out.println("not loading db");







      if (user == null) {
        out.println("<p>Username : <input type=\"text\" size=\"20\" name=\"user\"><br>");
        out.println("<p>Password : <input type=\"password\" size=\"20\" name=\"pass\"></p>");
      }

    db.setConnection(con);
    if (docID == -1) {
        SQL = SQL + "DocName = '" + docName + "';";
        out.println("<input type=\"hidden\" size=\"20\" name=\"doc_Name\" value=\"" + docName +  "\">");
    }
    else {
      SQL = SQL + "DocID = " + Integer.toString(docID) + ";";
      out.println("<input type=\"hidden\" size=\"20\" name=\"doc_ID\" value=\"" + Integer.toString(docID) +  "\">");
    }
    db.ProcSQL(SQL, false);
    String fld_docVarSrc = "DocVarSrc";
    if (toLower)
      fld_docVarSrc = fld_docVarSrc.toLowerCase();
    src = db.getFieldData(fld_docVarSrc,null);
    out.println(src);
    out.println("</form>");


    db.close();
    idrsDBs.freeConnection(con);


  }

  public void destroy() {
    super.destroy();
  }
}