
/**
 * Copyright (C) 2000 Marc Boorshtein under the GNU General Public License offered
 * without warenty
 * Title:        IDRS<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Marc Boorshtein<p>
 * Company:      <p>
 * @author Marc Boorshtein
 * @version 1.0
 */

import java.io.*;
import java.util.*;
import java.sql.*;

public class InsertToIDRS {

  public static void main(String[] args) throws Exception {
    boolean quit = false;
    String opts = args[0];
    if (opts.equals("-h")) {
      System.out.println("InsertToIDRS Allows for easy insertion of Documents into The IDRS");
      System.out.print("Usage : java InsertToIDRS -[option] [DBDriver] [DB Connection String] ");
      System.out.print("[DB User Name | NULL] [Password | NULL] [Document ID | NULL] [Document Name | NULL]");
      System.out.print(" [Doc Src Path | NULL] [Groups Allowed | NULL] [Var Src Path | NULL] [Is a File(true/false) | NULL]");
      System.out.println(" [Doc Params | NULL] [Doc Connections | NULL]");
      System.out.println("Option List is as follows : ");
      System.out.println("h : Displays this message");
      System.out.println("i : Update DocID");
      System.out.println("n : Update DocName");
      System.out.println("s : Update DocSrc");
      System.out.println("g : Update DocGroups");
      System.out.println("v : Update DocVarSrc");
      System.out.println("f : Update isFile");
      System.out.println("p : Update DocParams");
      System.out.println("c : Update DocConns");
      System.out.println("u : Is an update and not an insert");
      quit = true;
    }
    else {
      String DBDriver = args[1],
             DBName = args[2],
             User  =  args[3],
             Pass  =  args[4],
             docID  = "",
             docName = "",
             srcFile = "",
             docGroups = "",
             varFile = "",
             isFile = "",
             docParams = "",
             docConns = "";
      String SQL;
      int i = 4;
      if (opts.indexOf("u") != -1) {
        SQL = "UPDATE tblDoc SET ";

        if (opts.indexOf("i") != -1) {
          i++;
          docID = args[i];
          SQL += "DocID = " + docID + ", ";
        }
        if (opts.indexOf("n") != -1) {
          i++;
          docName = args[i];
          SQL += "DocName = '" + docName + "', ";
        }
        if (opts.indexOf("s") != -1) {
          i++;
          srcFile = args[i];
          String tmp = "";
          String docSrc;
          BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(new File(srcFile))));
          docSrc = in.readLine();
          while (docSrc != null) {
            tmp += InsertToIDRS.CleanLine(docSrc) + "\n";
            docSrc = in.readLine();
          }
          SQL += "DocSRC = '" + tmp + "', ";
        }
        if (opts.indexOf("g") != -1) {
          i++;
          docGroups = args[i];
          SQL += "DocGroups = '" + docGroups + "', ";
        }
        if (opts.indexOf("v") != -1) {
          i++;
          varFile = args[i];
          String tmp1 = "";
          String docSrc1;
          BufferedReader in1 = new BufferedReader(new InputStreamReader(new FileInputStream(new File(varFile))));
          docSrc1 = in1.readLine();
          while (docSrc1 != null) {
            tmp1 += InsertToIDRS.CleanLine(docSrc1) + "\n";
            docSrc1 = in1.readLine();
          }
          SQL += "DocVarSRC = '" + tmp1 + "', ";

        }
        if (opts.indexOf("f") != -1) {
          i++;
          isFile = args[i];
          SQL += "isFile = " + isFile + ", ";
        }
        if (opts.indexOf("p") != -1) {
          i++;
          docParams = args[i];
          SQL += "DocParams = '" + docParams + "', ";
        }
        if (opts.indexOf("c") != -1) {
          i++;
          docConns = args[i];

          SQL += "DocConns = '" + docConns + "', ";
        }



        SQL = SQL.substring(0,SQL.length() - 2);

        if (!  docID.equalsIgnoreCase("")) {

          SQL += " WHERE DocID = " + docID + ";";
        }
        else {
          if (docName.equalsIgnoreCase("")) {
            quit = true;
            System.out.println("Either the DocName or the DocID must be given");
          }
          SQL += " WHERE DocName = '" + docName + "';";
        }
        //System.out.println(SQL);



      }
      else {
        SQL = "INSERT INTO tblDoc VALUES (";
        if (opts.indexOf("i") != -1) {
          i++;
            docID = args[i];
            SQL +=  docID + ", ";

        }
        else {
          SQL += "null, ";
        }
        if (opts.indexOf("n") != -1) {
          i++;
            docName = args[i];
            SQL += "'" + docName + "', ";

        }
        else {
          SQL += "null, ";
        }

        if (opts.indexOf("s") != -1) {
          i++;
            srcFile = args[i];
            String tmp = "";
            String docSrc;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(new File(srcFile))));
            docSrc = in.readLine();
            while (docSrc != null) {
              tmp += InsertToIDRS.CleanLine(docSrc) + "\n";
              docSrc = in.readLine();
            }
            SQL += "'" + tmp + "', ";

        }
        else {
          SQL += "null, ";
        }

        if (opts.indexOf("g") != -1) {
        System.out.println("g");
          i++;
            docGroups = args[i];
            SQL += "'" + docGroups + "', ";

        }
        else {
          SQL += "null, ";
        }
        if (opts.indexOf("v") != -1) {
          i++;
          varFile = args[i];
          String tmp1 = "";
          String docSrc1;
          BufferedReader in1 = new BufferedReader(new InputStreamReader(new FileInputStream(new File(varFile))));
          docSrc1 = in1.readLine();
          while (docSrc1 != null) {
            tmp1 += InsertToIDRS.CleanLine(docSrc1) + "\n";
            docSrc1 = in1.readLine();
          }
          SQL += "'" + tmp1 + "', ";

        }
        else {
          SQL += "null, ";
        }
        if (opts.indexOf("f") != -1) {
          i++;
            isFile = args[i];
            SQL +=  isFile + ", ";

        }
        else {
          SQL += "null, ";
        }
        if (opts.indexOf("p") != -1) {
          i++;
            docParams = args[i];
            SQL += "'" + docParams + "', ";

        }
        else {
          SQL += "null, ";
        }
        if (opts.indexOf("c") != -1) {
          i++;
            docConns = args[i];
            SQL += "'" + docConns + "', ";

        }
        else {
          SQL += "null, ";
        }


        SQL = SQL.substring(0,SQL.length() - 2) + ");";
        //System.out.println(SQL);
      }

      System.out.println(SQL);
      Connection con;
      if (! quit) {
        Class.forName(DBDriver);
        if (User.equalsIgnoreCase("NULL")) {
          con = DriverManager.getConnection(DBName);
        }
        else {
          if (Pass.equalsIgnoreCase("NULL"))
            Pass = "";
          con = DriverManager.getConnection(DBName,User,Pass);
        }

        Statement stmt = con.createStatement();
        System.out.println(Integer.toString(stmt.executeUpdate(SQL)) + " row effected");
        con.close();
      }





    }

  }

  public static String CleanLine(String line) throws Exception {
    int start = 0;
    int chr = line.indexOf("'");
    String ret = "";
    while (chr != -1) {
      ret += line.substring(start,chr);
      ret += "\\'";
      start = chr + 1;
      chr = line.indexOf("'",start);
    }
    ret += line.substring(start);
    return ret;
  }
}