/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.idrs.utils.pool;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import net.sourceforge.idrs.utils.pool.PooledObject;

public abstract class ObjectPool
implements Serializable {
    protected PrintStream out;
    protected int maxTrys;
    protected long daysOpen;
    protected long sleepTime;
    protected static final String DEFAULT_PATH = Long.toString(System.currentTimeMillis()) + ".log";
    protected static final int DEFAULT_TRYS = 10;
    protected static final long DEFAULT_DAYS_OPEN = 30L;
    protected static final int DEFAULT_MIN_POOLSIZE = 1;
    protected String logPath;
    protected int minn;
    protected PooledObject[] pool;
    protected int limit;
    protected int count;
    protected boolean debug = false;
    public static final long DEFAULT_EXPIRATION = 600000L;
    public static final long DEFAULT_SLEEPTIME = 300000L;
    public static final int MAX_POOLSIZE = Integer.MAX_VALUE;
    public static final long DEFAULT_TIMEOUT = 30000L;

    public ObjectPool() throws Exception {
        this(1, Integer.MAX_VALUE, 30L, 300000L, DEFAULT_PATH, 10);
    }

    public ObjectPool(long l, long l2) throws Exception {
        this(1, Integer.MAX_VALUE, l, l2, DEFAULT_PATH, 10);
    }

    public ObjectPool(int n, int n2, long l, long l2, String string, int n3) throws Exception {
        this.limit = n2;
        this.out = new PrintStream(new FileOutputStream(string, false));
        this.maxTrys = n3;
        this.daysOpen = l;
        this.logPath = string;
        this.sleepTime = l2;
        this.pool = new PooledObject[n2];
        this.count = 0;
        if (this.limit <= 0) {
            this.limit = Integer.MAX_VALUE;
        }
        this.minn = n;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setDebugging(boolean bl) {
        this.debug = bl;
    }

    protected abstract void logHeader() throws Exception;

    protected abstract PooledObject create() throws Exception;

    protected abstract boolean validate(PooledObject var1);

    protected abstract void expire(PooledObject var1);

    public Object checkOut(int n) throws Exception {
        boolean bl = false;
        long l = System.currentTimeMillis();
        PooledObject pooledObject = null;
        if (n <= this.maxTrys) {
            Object object;
            if (this.count > 0) {
                object = this.pool;
                synchronized (object) {
                    int n2 = 0;
                    while (n2 < this.count) {
                        String string = this.pool[n2].getValue().toString();
                        if (this.pool[n2].isFree()) {
                            if (this.validate(this.pool[n2])) {
                                if (this.shouldReset(n2)) {
                                    this.reset(n2);
                                }
                                this.pool[n2].isFree(false);
                                Object object2 = this.pool[n2].getValue();
                                return object2;
                            }
                            ObjectPool objectPool = this;
                            synchronized (objectPool) {
                                Date date = new Date(System.currentTimeMillis());
                                this.out.println(date.toString() + "---------> " + date.toString() + " Object " + pooledObject.getValue().toString() + " has failed validation");
                                this.expire(this.pool[n2]);
                                this.pool[n2] = this.create();
                                this.pool[n2].isFree(false);
                                bl = true;
                                Object object3 = this.pool[n2].getValue();
                                return object3;
                            }
                        }
                        ++n2;
                    }
                }
            }
            if (this.count < this.limit) {
                object = this;
                synchronized (object) {
                    pooledObject = this.create();
                    pooledObject.isFree(false);
                    ++this.count;
                    this.pool[this.count] = pooledObject;
                }
                return pooledObject.getValue();
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("ERROR: Failed while waiting for an object:");
                System.out.println(interruptedException);
            }
            this.out.println("---------> All Connections Exhausted, waiting in loop " + n);
            return this.checkOut(n + 1);
        }
        System.out.println("Returning Here");
        return null;
    }

    protected int getConnID(Object object) {
        boolean bl = false;
        int n = 0;
        while (n < this.limit) {
            if (this.pool[n].equalsObj(object)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    protected void checkIn(Object object) throws Exception {
        if (object != null) {
            int n = this.getConnID(object);
            if (n == -1) {
                throw new Exception("Trying to return an object that was never part of the pool");
            }
            PooledObject pooledObject = this.pool[n];
            pooledObject.isFree(true);
        } else {
            System.out.println("Lost Connection");
        }
    }

    public void checkIn(String string) throws Exception {
        int n = this.getConnID(string);
        if (n == -1) {
            throw new Exception("Connection Lost");
        }
        if (this.pool[n].getValue() != null) {
            this.pool[n].isFree(true);
        } else {
            this.out.println("-------> Connection " + n + " lost, rebuilding");
            PooledObject[] pooledObjectArray = this.pool;
            synchronized (pooledObjectArray) {
                int n2 = this.count;
                this.count = n;
                this.pool[n] = this.create();
                this.count = n2;
            }
        }
    }

    protected boolean shouldReset(int n) {
        long l;
        long l2;
        long l3 = System.currentTimeMillis();
        long l4 = l3 - (l2 = this.pool[n].getBorn());
        return l4 >= (l = this.daysOpen * 1000L * 60L * 60L * 24L);
    }

    protected abstract void reset(int var1);
}

