/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.idrs.utils;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.idrs.script.IDRSScript;
import net.sourceforge.idrs.utils.ObjectStore;

public class DB
implements Serializable {
    public static final int SERVER = 1;
    public static final int CLIENT = 2;
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    private int cursurLocation;
    private int beginWith = 0;
    private int cursur;
    private Hashtable fields;
    private Vector varTypes = new Vector();
    private Vector vars = new Vector();
    private Vector rows;
    private String user;
    private String driver;
    private String name;
    private String pass;
    private String ID;
    private boolean closeConn;
    ResultSet rs;
    Connection con;
    private boolean firstRead;
    private boolean isPaged;
    private int numRecs;
    private boolean hasNext;
    private int inputResult;
    private boolean wasCached;
    private int direction;
    IDRSScript idrs;

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getDirection() {
        return this.direction;
    }

    public void wasCached(boolean bl) throws Exception {
        this.wasCached = bl;
        this.cursur = 2;
    }

    public boolean wasCached() throws Exception {
        return this.wasCached;
    }

    public int getFirstRec() throws Exception {
        return this.beginWith;
    }

    public int getNumRecs() throws Exception {
        return this.numRecs;
    }

    public void setNumRecs(int n) throws Exception {
        this.numRecs = n;
    }

    public boolean getIsPaged() throws Exception {
        return this.isPaged;
    }

    public void setIsPaged(boolean bl) throws Exception {
        this.isPaged = bl;
        this.cursur = 2;
    }

    public int getCurrLocation() throws Exception {
        return this.cursurLocation;
    }

    public DB(String string) {
        this.ID = string;
        this.user = "";
        this.driver = "";
        this.name = "";
        this.pass = "";
        this.firstRead = false;
        this.wasCached = false;
        this.direction = 2;
    }

    public String getID() throws Exception {
        return this.ID;
    }

    public void setCursurType(int n) throws Exception {
        this.cursur = n;
    }

    public void setIDRS(IDRSScript iDRSScript) {
        this.idrs = iDRSScript;
    }

    public boolean shouldPool() {
        return !this.closeConn;
    }

    public void close() throws Exception {
        if (this.closeConn) {
            this.con.close();
        }
        if (this.cursur == 1) {
            this.rs.close();
        }
    }

    public void setDBDriver(String string) throws Exception {
        this.driver = string;
        Class.forName(string);
    }

    public String getDBDriver() throws Exception {
        return this.driver;
    }

    public void setDBName(String string) throws Exception {
        this.name = string;
        this.con = this.user.equalsIgnoreCase("") ? DriverManager.getConnection(string) : DriverManager.getConnection(string, this.user, this.pass);
        this.closeConn = true;
    }

    public void setDBName(String string, boolean bl) throws Exception {
        this.name = string;
        if (bl) {
            this.con = DriverManager.getConnection(string, this.user, this.pass);
            this.closeConn = true;
        }
    }

    public String getDBName() throws Exception {
        return this.name;
    }

    public void setUserName(String string) throws Exception {
        this.user = string;
    }

    public String getUserName() throws Exception {
        return this.user;
    }

    public void setPassword(String string) throws Exception {
        this.pass = string;
    }

    public String getPassword() throws Exception {
        return this.pass;
    }

    public void setConnection(Connection connection) throws Exception {
        this.con = connection;
        this.closeConn = false;
    }

    public Connection getConnection() throws Exception {
        return this.con;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void procMethod(ObjectStore objectStore, String string, Vector vector) throws Exception {
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration enumeration = vector.elements();
        Class[] classArray = objectStore.getMethodTypes(string);
        Object object = new Object();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Class<?> clazz = classArray[n];
            object = enumeration.nextElement();
            String string2 = object.toString();
            Object object2 = ObjectStore.getValue(clazz, string2, this.con, this.idrs);
            clazz = object2.getClass();
            vector2.add(object2);
            ++n;
        }
        if (this.direction == 2) {
            this.rs = (ResultSet)objectStore.execMethod(string, vector2.toArray());
            if (this.rs == null) throw new Exception("Method Doesn't Return ResultSet");
            this.readTable();
            return;
        } else {
            Integer n2 = (Integer)objectStore.execMethod(string, vector2.toArray());
            this.inputResult = n2;
        }
    }

    public void ProcSQL(String string, boolean bl) throws Exception {
        if (bl) {
            string = "{call " + string + "}";
            CallableStatement callableStatement = this.con.prepareCall(string);
            if (this.vars != null) {
                int n = 1;
                while (n <= this.vars.size()) {
                    this.setValue(callableStatement, (String)this.varTypes.elementAt(n - 1), n);
                    ++n;
                }
            }
            if (this.direction == 2) {
                this.rs = callableStatement.executeQuery();
            } else {
                this.inputResult = callableStatement.executeUpdate();
            }
        } else {
            PreparedStatement preparedStatement = this.con.prepareStatement(string);
            if (this.vars != null) {
                int n = 1;
                while (n <= this.vars.size()) {
                    this.setValue(preparedStatement, (String)this.varTypes.elementAt(n - 1), n);
                    ++n;
                }
            }
            if (this.direction == 2) {
                this.rs = preparedStatement.executeQuery();
            } else {
                this.inputResult = preparedStatement.executeUpdate();
            }
        }
        if (this.direction == 2 && this.rs != null) {
            this.readTable();
        }
    }

    private void setValue(PreparedStatement preparedStatement, String string, int n) throws Exception {
        if ((string = string.trim()).equalsIgnoreCase("string")) {
            preparedStatement.setString(n, (String)this.vars.elementAt(n - 1));
        } else if (string.equalsIgnoreCase("int")) {
            preparedStatement.setInt(n, Integer.parseInt((String)this.vars.elementAt(n - 1)));
        } else if (string.equalsIgnoreCase("float")) {
            preparedStatement.setFloat(n, Float.parseFloat((String)this.vars.elementAt(n - 1)));
        } else if (string.equalsIgnoreCase("Date")) {
            java.sql.Date date = new java.sql.Date(Date.parse((String)this.vars.elementAt(n - 1)));
            preparedStatement.setDate(n, date);
        } else if (string.equalsIgnoreCase("time")) {
            Time time = new Time(Date.parse((String)this.vars.elementAt(n - 1)));
            preparedStatement.setTime(n, time);
        }
    }

    public void addVar(String string, String string2) throws Exception {
        this.vars.addElement(string);
        this.varTypes.addElement(string2);
    }

    public void removeVar(int n) throws Exception {
        this.vars.removeElementAt(n);
        this.varTypes.removeElementAt(n);
    }

    public void setVar(String string, String string2, int n) throws Exception {
        this.vars.setElementAt(string, n);
        this.varTypes.setElementAt(string2, n);
    }

    public void clearVars() throws Exception {
        this.vars.removeAllElements();
        this.varTypes.removeAllElements();
    }

    private void readTable() throws Exception {
        if (this.cursur == 2) {
            this.rows = new Vector();
            while (this.rs.next()) {
                this.fields = new Hashtable();
                this.readFields();
                this.rows.addElement(this.fields);
            }
            this.rs.close();
            this.cursurLocation = this.beginWith;
        } else {
            this.rs.next();
            this.readFields();
            this.firstRead = false;
        }
    }

    private void readFields() throws Exception {
        if (this.rs != null) {
            this.fields = new Hashtable();
            String string = "";
            ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = 1;
            while (n2 <= n) {
                Date date;
                String string2 = resultSetMetaData.getColumnName(n2);
                int n3 = resultSetMetaData.getColumnType(n2);
                String string3 = resultSetMetaData.getColumnTypeName(n2);
                if (string3.equalsIgnoreCase("TIME")) {
                    try {
                        date = this.rs.getTime(string2);
                        string = ((Time)date).toString();
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                } else if (string3.equalsIgnoreCase("DATE")) {
                    try {
                        date = this.rs.getDate(string2);
                        string = ((java.sql.Date)date).toString();
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                }
                if (string3.indexOf("TIME") != -1 && string3.indexOf("DATE") != -1 || string3.indexOf("time") != -1 && string3.indexOf("TIME") != -1) {
                    try {
                        Timestamp timestamp = this.rs.getTimestamp(string2);
                        string = timestamp.toString();
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                } else {
                    try {
                        string = this.rs.getString(string2);
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                }
                if (this.rs.wasNull()) {
                    string = "";
                }
                this.fields.put(string2, string);
                ++n2;
            }
        }
    }

    public int getUpdateResult() throws Exception {
        if (this.direction != 1) {
            throw new Exception("getUpdateResult() can only be called when direction is INPUT");
        }
        return this.inputResult;
    }

    public String getFieldData(String string, String string2) throws Exception {
        if (this.direction != 2) {
            throw new Exception("getFieldData() can only be called when direction is OUTPUT");
        }
        if (this.rs == null) {
            return "";
        }
        String string3 = "";
        string3 = (String)this.fields.get(string);
        Object[] objectArray = new Object[]{new String(""), new String("")};
        if (string2 == null) {
            string3 = (String)this.fields.get(string);
            return string3;
        }
        if (string3.equalsIgnoreCase("")) {
            return "";
        }
        if (string2.indexOf("number") != -1) {
            string3 = (String)this.fields.get(string);
            if (string3.indexOf(".") != -1) {
                Float f = Float.valueOf(string3);
                objectArray[0] = f;
            } else {
                objectArray[0] = new Integer(Integer.parseInt(string3));
            }
        } else if (string2.indexOf("date") != -1) {
            string3 = (String)this.fields.get(string);
            if (string3.indexOf(" ") != -1) {
                string3 = string3.substring(0, string3.indexOf(" "));
            }
            java.sql.Date date = java.sql.Date.valueOf(string3);
            objectArray[0] = date;
        } else if (string2.indexOf("time") != -1) {
            string3 = (String)this.fields.get(string);
            if (string3.indexOf(".") != -1) {
                string3 = string3.substring(0, string3.indexOf("."));
            }
            if (string3.indexOf(" ") != -1) {
                string3 = string3.substring(string3.indexOf(" ") + 1).trim();
            }
            Time time = Time.valueOf(string3);
            objectArray[0] = time;
        } else {
            objectArray[0] = (String)this.fields.get(string);
        }
        string3 = MessageFormat.format("{0," + string2 + "}", objectArray);
        return string3;
    }

    public boolean moveTo(int n) throws Exception {
        if (this.cursur == 2) {
            if (n >= 0 && n < this.rows.size()) {
                this.cursurLocation = n;
                return true;
            }
            return false;
        }
        throw new Exception("May only use DB.moveTo(int) when the cursur type is DB.CLIENT");
    }

    public void startWith(int n) throws Exception {
        this.beginWith = n;
    }

    public boolean next() throws Exception {
        if (this.cursur == 2) {
            if (this.rows.size() > this.cursurLocation) {
                this.fields = (Hashtable)this.rows.elementAt(this.cursurLocation);
                ++this.cursurLocation;
                this.hasNext = true;
                return true;
            }
            this.hasNext = false;
            return false;
        }
        if (this.firstRead) {
            if (this.rs.next()) {
                this.hasNext = true;
                this.readFields();
                return true;
            }
            this.hasNext = false;
            return false;
        }
        this.firstRead = true;
        return true;
    }

    public boolean getHasNext() throws Exception {
        if (this.cursur == 2) {
            return this.cursurLocation < this.rows.size();
        }
        return this.rs.isLast();
    }
}

