/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.idrs.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import net.sourceforge.idrs.jdbc.JDBCInfo;
import net.sourceforge.idrs.utils.pool.ObjectPool;
import net.sourceforge.idrs.utils.pool.PooledObject;

public class JDBCPool
extends ObjectPool {
    protected JDBCInfo info;

    public JDBCPool(String string, String string2, String string3, String string4, String string5, int n, int n2, long l, long l2, String string6, int n3) throws Exception {
        super(n, n2, l, l2, string6, n3);
        this.info = new JDBCInfo(string, string2, string3, string4, string5);
        this.logHeader();
        if (n >= 0) {
            int n4 = 0;
            while (n4 < n) {
                PooledObject pooledObject = this.create();
                pooledObject.isFree(true);
                this.pool[this.count] = pooledObject;
                ++this.count;
                ++n4;
            }
        }
    }

    protected void logHeader() throws Exception {
        if (this.info == null) {
            System.out.println("No INFO!");
        }
        if (this.out == null) {
            this.out = System.out;
        }
        this.out.println("Starting Poolman, IDRS Version");
        this.out.println("dbDriver = " + this.info.getDrivername());
        this.out.println("dbServer = " + this.info.getUrl());
        this.out.println("dbLogin = " + this.info.getUsername());
        this.out.println("log file = " + this.logPath);
        this.out.println("minconnections = " + Integer.toString(this.minn));
        this.out.println("maxconnections = " + Integer.toString(this.limit));
        this.out.println("Total refresh intervel = " + Long.toString(this.daysOpen) + " days");
        this.out.println("-----------------------------------------");
    }

    protected PooledObject create() throws SQLException {
        if (this.info.getDrivername() == null || this.info.getUrl() == null) {
            return null;
        }
        try {
            Driver driver = (Driver)Class.forName(this.info.getDrivername()).newInstance();
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", this.info.getUsername());
            ((Hashtable)properties).put("password", this.info.getPassword());
            Connection connection = driver.connect(this.info.getUrl(), properties);
            Date date = new Date(System.currentTimeMillis());
            this.out.println(date.toString() + " Opening connection " + this.count + " " + connection.toString());
            return new PooledObject(System.currentTimeMillis(), true, connection);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.out.println("Looks like the driver was not found...");
            this.out.println("Be sure it is in your CLASSPATH and listed properly in the properties file.");
        }
        catch (SQLException sQLException) {
            this.out.println(sQLException);
        }
        catch (RuntimeException runtimeException) {
            this.out.println(runtimeException);
        }
        catch (Exception exception) {
            this.out.println(exception);
        }
        catch (Throwable throwable) {
            this.out.println(throwable);
        }
        return null;
    }

    protected boolean validate(PooledObject pooledObject) {
        Connection connection = (Connection)pooledObject.getValue();
        try {
            return !connection.isClosed();
        }
        catch (SQLException sQLException) {
            this.out.println(sQLException);
            return false;
        }
    }

    protected void expire(PooledObject pooledObject) {
        try {
            Connection connection = (Connection)pooledObject.getValue();
            connection.close();
            connection = null;
        }
        catch (Exception exception) {
            this.out.println(exception);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            Connection connection = (Connection)super.checkOut(0);
            return connection;
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.getMessage());
        }
        catch (Exception exception) {
            this.out.print("A non-SQL error occurred when requesting a connection:");
            this.out.println(exception);
            return null;
        }
    }

    public void freeConnection(Connection connection) throws Exception {
        super.checkIn(connection);
    }

    public void freeConnection(String string) throws Exception {
        super.checkIn(string);
    }

    public JDBCInfo getInfo() {
        return this.info;
    }

    public void setInfo(JDBCInfo jDBCInfo) {
        this.info = jDBCInfo;
    }

    private int genHashCode(int n, Object object) {
        return object == null ? 0 : 1000003 * n + object.hashCode();
    }

    public int hashCode() {
        return this.genHashCode(super.hashCode(), this.info.getUrl());
    }

    public boolean equals(Object object) {
        try {
            JDBCPool jDBCPool = (JDBCPool)object;
            return this.info.getUrl().equalsIgnoreCase(jDBCPool.info.getUrl());
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void reset(int n) {
        try {
            Connection connection = (Connection)this.pool[n].getValue();
            connection.close();
            connection = null;
            this.pool[n].setValue(null);
            this.pool[n] = null;
            this.out.println("----->Resetting connection " + n + " ...");
            int n2 = this.count;
            this.count = n;
            this.pool[n] = this.create();
            this.count = n2;
        }
        catch (Exception exception) {
            this.out.println(exception);
        }
    }
}

