/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.idrs.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.idrs.core.IDRSPool;
import net.sourceforge.idrs.core.IDRSReport;
import net.sourceforge.idrs.core.IDRSSecurity;
import net.sourceforge.idrs.jdbc.JDBCPool;

public class IDRSServlet
extends HttpServlet {
    private String dbName;
    private String dbDriver;
    private String dbUser;
    private String dbPass;
    private String contextPath;
    private String logPath;
    private long daysToReset;
    private int minConns;
    private int maxConns;
    private boolean toLower;
    private Hashtable dbs;
    private Hashtable conns;
    private int numDbs;
    private JDBCPool idrsDBs;
    private String IDRSName;
    private IDRSPool idrss;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string;
        this.dbDriver = servletConfig.getInitParameter("dbDriver");
        this.dbName = servletConfig.getInitParameter("dbName");
        this.dbUser = servletConfig.getInitParameter("dbUser");
        if (this.dbUser == null) {
            this.dbUser = "";
        }
        this.dbPass = servletConfig.getInitParameter("dbPass");
        if (this.dbPass == null) {
            this.dbPass = "";
        }
        this.toLower = (string = servletConfig.getInitParameter("toLower")) == null ? false : string.equalsIgnoreCase("true");
        this.conns = new Hashtable();
        this.contextPath = servletConfig.getInitParameter("contextPath");
        this.minConns = Integer.parseInt(servletConfig.getInitParameter("minConns"));
        this.maxConns = Integer.parseInt(servletConfig.getInitParameter("maxConns"));
        this.daysToReset = Long.parseLong(servletConfig.getInitParameter("daysOpen"));
        this.logPath = servletConfig.getInitParameter("logPath");
        try {
            this.idrsDBs = new JDBCPool("IDRS", this.dbDriver, this.dbName, this.dbUser, this.dbPass, this.minConns, this.maxConns, this.daysToReset, 2000L, this.logPath, 10);
        }
        catch (Exception exception) {
            try {
                System.out.println(exception);
                exception.printStackTrace();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.numDbs = servletConfig.getInitParameter("numDBs") == null ? 0 : Integer.parseInt(servletConfig.getInitParameter("numDBs"));
        this.dbs = new Hashtable();
        int n = 1;
        while (n <= this.numDbs) {
            String string2;
            String string3 = servletConfig.getInitParameter("dbDriver" + Integer.toString(n));
            String string4 = servletConfig.getInitParameter("dbName" + Integer.toString(n));
            String string5 = servletConfig.getInitParameter("dbUser" + Integer.toString(n));
            if (string5 == null) {
                string5 = "";
            }
            if ((string2 = servletConfig.getInitParameter("dbPass" + Integer.toString(n))) == null) {
                string2 = "";
            }
            int n2 = Integer.parseInt(servletConfig.getInitParameter("minConns" + Integer.toString(n)));
            int n3 = Integer.parseInt(servletConfig.getInitParameter("maxConns" + Integer.toString(n)));
            long l = Long.parseLong(servletConfig.getInitParameter("daysOpen" + Integer.toString(n)));
            String string6 = servletConfig.getInitParameter("logPath" + Integer.toString(n));
            try {
                JDBCPool jDBCPool = new JDBCPool(string3, string3, string4, string5, string2, n2, n3, l, 2000L, string6, 10);
                this.dbs.put(string4, jDBCPool);
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            ++n;
        }
        this.IDRSName = servletConfig.getServletName();
        try {
            String string7;
            int n4;
            int n5;
            int n6;
            String string8 = servletConfig.getInitParameter("reportLogPath");
            if (string8 != null) {
                n6 = Integer.parseInt(servletConfig.getInitParameter("minReports"));
                n5 = Integer.parseInt(servletConfig.getInitParameter("maxReports"));
                n4 = Integer.parseInt(servletConfig.getInitParameter("daysReportsOpen"));
                string7 = servletConfig.getInitParameter("scriptClass");
            } else {
                string8 = "idrs.log";
                n6 = 25;
                n5 = 50;
                n4 = 7;
                string7 = "";
            }
            this.idrss = new IDRSPool(n6, n5, n4, 2000L, string8, 10, string7);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace(System.out);
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        super.init(servletConfig);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            this.procIDRS(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            System.out.println(exception + "\n" + exception.getMessage() + "\n");
            exception.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            this.procIDRS(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            System.out.println(exception + "\n" + exception.getMessage() + "\n");
            exception.printStackTrace();
        }
    }

    private boolean getConns(String string, Hashtable hashtable, Vector vector) throws Exception {
        if (this.numDbs != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                JDBCPool jDBCPool = (JDBCPool)this.dbs.get(string2);
                Connection connection = null;
                connection = jDBCPool.getConnection();
                vector.add(connection.toString());
                if (connection == null) {
                    System.out.println("No Conns!");
                    Enumeration enumeration = hashtable.keys();
                    if (enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        jDBCPool = (JDBCPool)this.dbs.get(string2);
                        connection = (Connection)hashtable.remove(string2);
                        jDBCPool.freeConnection(connection);
                        return false;
                    }
                }
                hashtable.put(string2, connection);
            }
            return true;
        }
        return true;
    }

    private void returnConns(String string, Hashtable hashtable, Vector vector) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        int n = 0;
        if (this.numDbs != 0) {
            hashtable = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                JDBCPool jDBCPool = (JDBCPool)this.dbs.get(string2);
                jDBCPool.freeConnection((String)vector.elementAt(n));
                ++n;
            }
        }
    }

    private IDRSReport getReport(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, PrintWriter printWriter, File file, Thread thread, IDRSSecurity iDRSSecurity, Hashtable hashtable, String string) throws Exception {
        String string2 = iDRSSecurity.getSrc();
        IDRSReport iDRSReport = (IDRSReport)this.idrss.checkOut(0);
        if (iDRSReport == null) {
            throw new Exception("An error has occured trying to get the report");
        }
        try {
            if (httpServletRequest.getParameter("isJSP").equalsIgnoreCase("true")) {
                String string3 = this.contextPath + "trash/" + Integer.toString(thread.hashCode()) + ".jsp";
                file = new File(string3);
                printWriter = new PrintWriter(new FileOutputStream(file), true);
                iDRSReport.init(printWriter, string2, false, iDRSSecurity.getUserID(), hashtable, iDRSSecurity.getDocID(), string, httpServletRequest.getSession(true), httpServletRequest);
            } else {
                iDRSReport.init(httpServletResponse.getWriter(), string2, false, iDRSSecurity.getUserID(), hashtable, iDRSSecurity.getDocID(), string, httpServletRequest.getSession(true), httpServletRequest);
            }
        }
        catch (Exception exception) {
            iDRSReport.init(httpServletResponse.getWriter(), string2, false, iDRSSecurity.getUserID(), hashtable, iDRSSecurity.getDocID(), string, httpServletRequest.getSession(true), httpServletRequest);
        }
        return iDRSReport;
    }

    private void addVars(HttpServletRequest httpServletRequest, IDRSReport iDRSReport, Hashtable hashtable, String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = string3.substring(0, string3.indexOf("_"));
            String string5 = string3.substring(string3.indexOf("_") + 1);
            if (!string4.equalsIgnoreCase(string2)) {
                iDRSReport.addVarList(string4);
                string2 = string4;
            }
            if (string3.indexOf("Reset") != -1) {
                try {
                    if (!httpServletRequest.getParameter(string3).equalsIgnoreCase("true")) continue;
                    hashtable.remove(string4);
                }
                catch (Exception exception) {}
                continue;
            }
            if (string3.indexOf("PageSize") != -1) {
                iDRSReport.setPageSize(string4, Integer.parseInt(httpServletRequest.getParameter(string3)));
                continue;
            }
            if (string3.indexOf("FirstRecord") != -1) {
                iDRSReport.setPageFirst(string4, Integer.parseInt(httpServletRequest.getParameter(string3)));
                continue;
            }
            if (string3.indexOf("UserID") != -1) {
                iDRSReport.addVar("UserID", string4);
                iDRSReport.addVarName("ignore", string4);
                continue;
            }
            if (string3.indexOf("Dataset") != -1) {
                iDRSReport.addVar("Dataset", string4);
                iDRSReport.addVarName("ignore", string4);
                continue;
            }
            if (string3.indexOf("Scripter") != -1) {
                iDRSReport.addVar("Scripter", string4);
                iDRSReport.addVarName("ignore", string4);
                continue;
            }
            if (string3.indexOf("Connection") != -1) {
                iDRSReport.addVar("Connection", string4);
                iDRSReport.addVarName("ignore", string4);
                continue;
            }
            iDRSReport.addVar(httpServletRequest.getParameter(string3), string4);
            iDRSReport.addVarName(string5, string4);
        }
    }

    private void procIDRS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, Exception {
        boolean bl = false;
        int n = -1;
        String string = "";
        try {
            n = Integer.parseInt(httpServletRequest.getParameter("doc_ID"));
        }
        catch (Exception exception) {
            string = httpServletRequest.getParameter("doc_Name");
        }
        HttpSession httpSession = httpServletRequest.getSession(true);
        httpServletResponse.setContentType("text/html");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        try {
            string2 = (String)httpSession.getValue("user");
            string3 = (String)httpSession.getValue("pass");
            if (string2 == null) {
                string2 = httpServletRequest.getParameter("user");
                string3 = httpServletRequest.getParameter("pass");
            }
        }
        catch (Exception exception) {
            httpServletResponse.getWriter().println("<H1>Error</H1>");
            httpServletResponse.getWriter().println(exception + "\n" + exception.getMessage() + "\n" + exception.toString());
            bl = true;
        }
        String string5 = this.IDRSName;
        String string6 = "";
        PrintWriter printWriter = null;
        Thread thread = Thread.currentThread();
        File file = null;
        Vector vector = new Vector();
        if (!bl) {
            Connection connection = this.idrsDBs.getConnection();
            IDRSSecurity iDRSSecurity = n != -1 ? new IDRSSecurity(n, string2, string3, connection, this.toLower) : new IDRSSecurity(string, string2, string3, connection, this.toLower);
            String string7 = iDRSSecurity.getParamNames();
            String string8 = "";
            Hashtable hashtable = (Hashtable)httpSession.getAttribute("DbCache");
            httpSession.removeAttribute("DbCache");
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            if (string7 != null) {
                this.conns = new Hashtable();
                if (this.getConns(iDRSSecurity.getConns(), this.conns, vector)) {
                    IDRSReport iDRSReport = this.getReport(httpServletResponse, httpServletRequest, printWriter, file, thread, iDRSSecurity, this.conns, string5);
                    string4 = iDRSReport.toString();
                    this.addVars(httpServletRequest, iDRSReport, hashtable, string7);
                    iDRSReport.setCache(hashtable);
                    try {
                        iDRSReport.buildReport();
                    }
                    catch (Exception exception) {
                        if (printWriter == null) {
                            httpServletResponse.getWriter().println("<h1>IDRS ERROR: An error occurred while building the report - " + exception + "</h1><br>");
                            exception.printStackTrace(httpServletResponse.getWriter());
                        }
                        printWriter.println("<h1>IDRS ERROR: An error occurred while building the report - " + exception + "</h1>");
                    }
                    iDRSReport.cleanUp();
                    this.returnConns(iDRSSecurity.getConns(), iDRSReport.getConns(), vector);
                    hashtable = iDRSReport.getCacheDBs();
                    httpSession.setAttribute("DbCache", (Object)hashtable);
                    iDRSSecurity.close();
                    this.idrsDBs.freeConnection(connection);
                    this.idrss.checkIn(string4);
                    httpSession.putValue("user", (Object)string2);
                    httpSession.putValue("pass", (Object)string3);
                    iDRSReport = null;
                    iDRSSecurity = null;
                    vector = null;
                    try {
                        printWriter.close();
                        ServletContext servletContext = this.getServletContext();
                        servletContext.getRequestDispatcher("/trash/" + Integer.toString(thread.hashCode()) + ".jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                        file.delete();
                    }
                    catch (Exception exception) {
                        iDRSReport = null;
                        iDRSSecurity = null;
                        vector = null;
                    }
                } else {
                    httpServletResponse.getWriter().println("<H1>Server is busy</H1>");
                    httpServletResponse.getWriter().println("<H2>The server is currently busy, please try again later</H2>");
                    Object var14_25 = null;
                    iDRSSecurity = null;
                    vector = null;
                }
            } else if (!bl) {
                iDRSSecurity.close();
                this.idrsDBs.freeConnection(connection);
                httpServletResponse.getWriter().println("<H1>Access Denied</H1>");
                httpServletResponse.getWriter().println("<H2>Hit Backspace and re-enter your username and password</H2>");
                Object var14_26 = null;
                iDRSSecurity = null;
                vector = null;
            }
        } else {
            httpServletResponse.getWriter().println("<H1>Access Denied</H1>");
            httpServletResponse.getWriter().println("<H2>Hit Backspace and re-enter your username and password</H2>");
            Object var14_27 = null;
            Object var11_20 = null;
            vector = null;
        }
        if (printWriter != null) {
            printWriter.close();
        }
        httpServletResponse.getWriter().close();
    }

    public void destroy() {
        super.destroy();
    }
}

