/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.idrs.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sourceforge.idrs.script.DBShell;
import net.sourceforge.idrs.script.IDRSScript;
import net.sourceforge.idrs.script.embedable.IDRSScriptLanguage;
import net.sourceforge.idrs.script.embedable.IDRSShell;
import net.sourceforge.idrs.utils.DB;
import net.sourceforge.idrs.utils.ObjectStore;

public class IDRSReport
implements IDRSScript {
    int docID;
    int numDBsPaged = 0;
    PrintWriter out;
    String source;
    boolean isFile;
    BufferedReader in;
    int currentPos;
    int lineNum;
    String DBName;
    String DBDriver;
    Hashtable DBs;
    Hashtable vars;
    Hashtable lineNums;
    StringTokenizer tok;
    int userNum;
    Hashtable conns;
    boolean connLoaded;
    Hashtable color1;
    Hashtable color2;
    Hashtable tracking;
    Hashtable objects;
    boolean checkIsChange;
    boolean isChanged;
    Hashtable varLists;
    Hashtable pageSizes;
    Hashtable pageStart;
    Hashtable varsNames;
    Hashtable DBcache;
    boolean isHTML;
    String IdrsUrl;
    HttpSession session;
    HttpServletRequest request;
    IDRSScriptLanguage idrs;
    IDRSShell me;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$net$sourceforge$idrs$script$IdrsDB;
    static /* synthetic */ Class class$net$sourceforge$idrs$script$IDRSScript;
    static /* synthetic */ Class class$net$sourceforge$idrs$script$DBShell;

    public IDRSReport(String string) throws Exception {
        if (!string.equals("")) {
            this.idrs = (IDRSScriptLanguage)Class.forName(string).newInstance();
        }
        this.color1 = new Hashtable();
        this.color2 = new Hashtable();
        this.tracking = new Hashtable();
        this.objects = new Hashtable();
        this.varLists = new Hashtable();
        this.pageSizes = new Hashtable();
        this.pageStart = new Hashtable();
        this.varsNames = new Hashtable();
        this.lineNums = new Hashtable();
        this.vars = new Hashtable();
        this.DBs = new Hashtable();
    }

    public void init(PrintWriter printWriter, String string, boolean bl, int n, Hashtable hashtable, int n2, String string2, HttpSession httpSession, HttpServletRequest httpServletRequest) throws Exception {
        this.session = httpSession;
        this.request = httpServletRequest;
        this.out = printWriter;
        this.source = string;
        this.isFile = bl;
        if (bl) {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            this.in = new BufferedReader(inputStreamReader);
        } else {
            this.tok = new StringTokenizer(string, "\n", false);
        }
        this.userNum = n;
        this.currentPos = 0;
        this.conns = hashtable;
        this.numDBsPaged = 0;
        this.docID = n2;
        this.IdrsUrl = string2;
        this.isHTML = true;
    }

    public void setCache(Hashtable hashtable) throws Exception {
        this.DBcache = hashtable;
    }

    private String getLine() throws Exception {
        int n = this.currentPos;
        int n2 = this.currentPos + 1;
        int n3 = 10;
        if (this.isFile) {
            return this.in.readLine();
        }
        if (this.tok.hasMoreTokens()) {
            return this.tok.nextToken();
        }
        return this.source.substring(this.source.lastIndexOf("\n"));
    }

    public void buildReport() throws Exception {
        String string = this.getLine();
        String string2 = string.toLowerCase();
        if (string2.indexOf("<rml>") != -1) {
            string = this.getLine();
            string2 = string.toLowerCase();
            while (string2.indexOf("<head") == -1) {
                String string3;
                int n;
                int n2;
                if (string2.indexOf("<ishtml>") != -1) {
                    n2 = string2.indexOf("<ishtml>") + 8;
                    n = string2.indexOf("</ishtml>", n2);
                    string3 = string.substring(n2, n);
                    try {
                        this.isHTML = Boolean.valueOf(string3);
                    }
                    catch (Exception exception) {
                        throw new Exception("<IsHTML></IsHTML> may only contain TRUE or FALSE");
                    }
                    string = this.getLine();
                    string2 = string.toLowerCase();
                    n2 = 0;
                    n = 0;
                    continue;
                }
                if (string2.indexOf("<scriptclass>") != -1) {
                    n2 = string2.indexOf("<scriptclass>") + 13;
                    n = string2.indexOf("</scriptclass>");
                    string3 = string.substring(n2, n);
                    if (this.idrs == null) {
                        try {
                            this.idrs = (IDRSScriptLanguage)Class.forName(string3).newInstance();
                        }
                        catch (Exception exception) {
                            throw new Exception(exception.toString() + " : Can't create script object");
                        }
                    }
                    this.me = new IDRSShell(this);
                    this.idrs.setVal("idrs", this.me);
                    if (this.session != null) {
                        this.idrs.importClass("javax.servlet.http.*");
                        this.idrs.importClass("javax.servlet.*");
                    }
                    this.idrs.importClass("net.sourceforge.idrs.script.IDRSScript");
                    this.idrs.importClass("net.sourceforge.idrs.script.embedable.IDRSShell");
                    this.idrs.importClass("net.sourceforge.idrs.core.IDRSReport");
                    this.idrs.importClass("java.io.PrintWriter");
                    this.idrs.setVal("out", this.out);
                    string = this.getLine();
                    string2 = string.toLowerCase();
                    n2 = 0;
                    n = 0;
                    continue;
                }
                this.out.println(string);
            }
            if (this.isHTML) {
                this.out.println(string);
            }
        } else {
            this.out.println(string);
        }
        this.readHeader();
        this.readBody();
        this.source = null;
    }

    public void cleanUp() throws Exception {
        Object v;
        String string;
        Enumeration enumeration = this.DBs.keys();
        this.DBcache = null;
        this.DBcache = new Hashtable();
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration2 = this.conns.keys();
        while (enumeration2.hasMoreElements()) {
            string = (String)enumeration2.nextElement();
            v = this.conns.remove(string);
            hashtable.put(string, v);
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            DB dB = (DB)this.DBs.remove(string2);
            Connection connection = dB.getConnection();
            if (!dB.getDBName().equalsIgnoreCase("") && dB.shouldPool()) {
                this.conns.put(dB.getDBName(), connection);
            }
            if (dB.getIsPaged()) {
                this.DBcache.put(string2, dB);
            } else {
                dB.close();
            }
            enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                v = hashtable.remove(string);
                this.conns.put(string, v);
            }
        }
        this.lineNums.clear();
        this.color1.clear();
        this.color2.clear();
        this.tracking.clear();
        this.objects.clear();
        this.varLists.clear();
        this.pageSizes.clear();
        this.pageStart.clear();
        this.varsNames.clear();
        this.DBs.clear();
        this.vars.clear();
        this.out = null;
    }

    public Hashtable getConns() throws Exception {
        return this.conns;
    }

    private void procVarList(String string, String string2) throws Exception {
        int n = string.indexOf("\"") + 1;
        int n2 = string.indexOf("\"", n);
        String string3 = string2.substring(n, n2);
        Vector<Object> vector = new Vector<Object>();
        string2 = this.getLine();
        string = string2.toLowerCase();
        while (string.indexOf("</varlist>") == -1) {
            if (string.indexOf("<vartype>") != -1) {
                n = string.indexOf("<vartype>") + 9;
                n2 = string.indexOf("</vartype>");
                vector.add(this.getClass(string2.substring(n, n2)));
            } else {
                n = string.indexOf("<dbresult>") + 10;
                n2 = string.indexOf("</dbresult>", n);
                vector.add(string2.substring(n, n2));
            }
            string2 = this.getLine();
            string = string2.toLowerCase();
        }
        this.varLists.put(string3, vector);
        vector = null;
    }

    private void procObjClss(String string, String string2, ObjectStore objectStore) throws Exception {
        int n = string.indexOf("<class>") + 7;
        int n2 = string.indexOf("</class>");
        objectStore.setClassName(string2.substring(n, n2));
    }

    private DB procDBPage(String string, String string2, DB dB) throws Exception {
        Integer n;
        DB dB2;
        String string3 = dB.getID();
        if (this.DBcache.containsKey(string3)) {
            dB2 = null;
            dB2 = (DB)this.DBcache.remove(string3);
            dB2.wasCached(true);
        } else {
            dB2 = dB;
            dB2.wasCached(false);
        }
        dB2.setIsPaged(true);
        int n2 = string.indexOf("<pagesize>") + 10;
        int n3 = string.indexOf("</pagesize>");
        int n4 = 0;
        int n5 = 0;
        if (string.substring(n2, n3).indexOf("<external>") != -1) {
            n = (Integer)this.pageSizes.remove(dB.getID());
            n4 = n;
            this.pageSizes.put(dB2.getID(), n);
        } else {
            try {
                n4 = Integer.parseInt(string2.substring(n2, n3));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        dB2.setNumRecs(n4);
        if (n4 <= 0) {
            throw new Exception(n4 + " is less then 0, number of records must be greater then 0");
        }
        n = (Integer)this.pageStart.remove(dB.getID());
        if (n != 0 && (n5 = n.intValue()) < 0) {
            throw new Exception("First Record may not be less then 0");
        }
        this.pageStart.put(dB.getID(), n);
        if (dB2.wasCached()) {
            dB2.moveTo(n5);
        }
        dB2.startWith(n5);
        ++this.numDBsPaged;
        n = null;
        return dB2;
    }

    private void procObjConstructor(String string, String string2, ObjectStore objectStore, String string3) throws Exception {
        Object[] objectArray;
        Class[] classArray;
        Vector<Class> vector = new Vector<Class>();
        int n = 0;
        int n2 = 0;
        string2 = this.getLine().trim();
        string = string2.toLowerCase();
        while (string.indexOf("</constructor>") == -1) {
            n = string.indexOf("<vartype>") + 9;
            n2 = string.indexOf("</vartype>");
            vector.add(this.getClass(string2.substring(n, n2)));
            n = 0;
            n2 = 0;
            string2 = this.getLine().trim();
            string = string2.toLowerCase();
        }
        try {
            Vector vector2 = (Vector)this.vars.remove(string3);
            if (vector2 != null) {
                int n3;
                if (vector2.indexOf("UserID") >= 0) {
                    n3 = vector2.indexOf("UserID");
                    vector2.remove(n3);
                    vector2.insertElementAt(Integer.toString(this.userNum), n3);
                }
                if (vector2.indexOf("Scripter") >= 0) {
                    n3 = vector2.indexOf("Scripter");
                    vector2.remove(n3);
                    vector2.insertElementAt(this, n3);
                }
                classArray = new Class[vector.size()];
                objectArray = vector.toArray();
                System.arraycopy(objectArray, 0, classArray, 0, classArray.length);
                objectStore.initiate(classArray, vector2.toArray());
            } else {
                objectStore.initiate(new Class[0], new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        classArray = null;
        objectArray = null;
        vector = null;
    }

    private void procObjMethod(String string, String string2, ObjectStore objectStore) throws Exception {
        Object object;
        int n = 0;
        int n2 = 0;
        string2 = this.getLine().trim();
        string = string2.toLowerCase();
        n = string.indexOf("<name>") + 6;
        n2 = string.indexOf("</name>");
        String string3 = string2.substring(n, n2);
        n = 0;
        n2 = 0;
        string2 = this.getLine().trim();
        string = string2.toLowerCase();
        Vector<Class[]> vector = new Vector<Class[]>();
        while (string.indexOf("</method>") == -1) {
            n = string.indexOf("<vartype>") + 9;
            n2 = string.indexOf("</vartype>");
            object = this.getClass(string2.substring(n, n2));
            vector.add((Class[])object);
            n = 0;
            n2 = 0;
            string2 = this.getLine().trim();
            string = string2.toLowerCase();
        }
        object = new Class[vector.size()];
        Object[] objectArray = vector.toArray();
        System.arraycopy(objectArray, 0, object, 0, objectArray.length);
        objectStore.addMethod(string3, (Class[])object);
        vector = null;
        object = null;
        objectArray = null;
    }

    private void procObject(String string, String string2) throws Exception {
        int n = string.indexOf("\"", string.indexOf("id")) + 1;
        int n2 = string.indexOf("\"", n + 1);
        String string3 = string2.substring(n, n2);
        string2 = this.getLine().trim();
        string = string2.toLowerCase();
        n = 0;
        n2 = 0;
        ObjectStore objectStore = new ObjectStore(string3);
        while (string.indexOf("</object>") == -1) {
            if (string.indexOf("<class>") != -1) {
                this.procObjClss(string, string2, objectStore);
                n = 0;
                n2 = 0;
                string2 = this.getLine().trim();
                string = string2.toLowerCase();
                continue;
            }
            if (string.indexOf("<constructor>") != -1) {
                this.procObjConstructor(string, string2, objectStore, string3);
                n = 0;
                n2 = 0;
                string2 = this.getLine().trim();
                string = string2.toLowerCase();
                continue;
            }
            if (string.indexOf("<method>") == -1) continue;
            this.procObjMethod(string, string2, objectStore);
            n = 0;
            n2 = 0;
            string2 = this.getLine().trim();
            string = string2.toLowerCase();
        }
        this.objects.put(string3, objectStore);
        Object var3_7 = null;
        Object var4_8 = null;
        objectStore = null;
    }

    private void procDBMethod(String string, String string2, DB dB) throws Exception {
        int n = string.indexOf("\"", string.indexOf("objid")) + 1;
        int n2 = string.indexOf("\"", n + 1);
        String string3 = string2.substring(n, n2);
        ObjectStore objectStore = (ObjectStore)this.objects.remove(string3);
        n = n2 + 1;
        n = string.indexOf(">", n) + 1;
        n2 = string.indexOf("</usemethod>");
        String string4 = string2.substring(n, n2);
        Vector vector = (Vector)this.vars.remove(dB.getID());
        int n3 = vector.indexOf("UserID");
        if (n3 >= 0) {
            vector.remove(n3);
            vector.insertElementAt(Integer.toString(this.userNum), n3);
        }
        if ((n3 = vector.indexOf("Scripter")) >= 0) {
            vector.remove(n3);
            vector.insertElementAt(this, n3);
        }
        dB.setIDRS(this);
        dB.procMethod(objectStore, string4, vector);
        this.vars.put(dB.getID(), vector);
        this.objects.put(string3, objectStore);
        objectStore = null;
        vector = null;
        string3 = null;
    }

    private void procUseDB(String string, String string2, DB dB) throws Exception {
        int n = string.indexOf("<usedb>") + 7;
        int n2 = string.indexOf("</usedb>");
        String string3 = string2.substring(n, n2);
        DB dB2 = (DB)this.DBs.get(string3);
        dB.setConnection(dB2.getConnection());
        n = 0;
        n2 = 0;
        string3 = null;
        dB2 = null;
    }

    private void procDBDriver(String string, String string2, DB dB) throws Exception {
        int n = string.indexOf("<dbdriver>") + 10;
        int n2 = string.indexOf("</dbdriver>");
        String string3 = string2.substring(n, n2);
        dB.setDBDriver(string3);
        n = 0;
        n2 = 0;
        string3 = null;
    }

    private void procDBName(String string, String string2, DB dB) throws Exception {
        int n = string.indexOf("<dbname>") + 8;
        int n2 = string.indexOf("</dbname>");
        String string3 = string2.substring(n, n2);
        if (this.conns.containsKey(string3 = string3.trim())) {
            Connection connection = (Connection)this.conns.remove(string3);
            dB.setConnection(connection);
            dB.setDBName(string3, false);
            this.connLoaded = true;
        } else if (!dB.getDBDriver().equals("")) {
            dB.setDBName(string3, true);
            this.connLoaded = false;
        } else {
            throw new Exception("IDRS will only use Pooled Connections.");
        }
        string3 = null;
    }

    private void procDBUserName(String string, String string2, DB dB) throws Exception {
        int n = string.indexOf("<username>") + 10;
        int n2 = string.indexOf("</username>");
        if (!this.connLoaded) {
            dB.setUserName(string2.substring(n, n2));
        }
    }

    private void procDBPass(String string, String string2, DB dB) throws Exception {
        int n = string.indexOf("<password>") + 10;
        int n2 = string.indexOf("</password>");
        if (!this.connLoaded) {
            dB.setPassword(string2.substring(n, n2));
        }
    }

    private void procDirection(String string, String string2, DB dB) throws Exception {
        int n;
        int n2 = string.indexOf("<direction>") + 11;
        String string3 = string2.substring(n2, n = string.indexOf("</direction>"));
        if (string3.equalsIgnoreCase("INPUT")) {
            dB.setDirection(1);
        } else {
            dB.setDirection(2);
        }
    }

    private void procDB(String string, String string2) throws Exception {
        int n;
        int n2 = string.indexOf("\"", string.indexOf("id")) + 1;
        String string3 = string2.substring(n2, n = string.indexOf("\"", n2 + 1));
        if (!this.vars.containsKey(string3)) {
            this.addVarList(string3);
        }
        this.DBs.put(string3, new DB(string3));
        this.lineNums.put(string3, new Integer(0));
        DB dB = (DB)this.DBs.remove(string3);
        n2 = 0;
        n = 0;
        string2 = this.getLine();
        string = string2.toLowerCase();
        while (string.indexOf("</db>") == -1) {
            if (dB.wasCached()) {
                while (string.indexOf("</db>") == -1) {
                    string2 = this.getLine();
                    string = string2.toLowerCase();
                }
                continue;
            }
            if (string.indexOf("<pagesize>") != -1) {
                dB = this.procDBPage(string, string2, dB);
                string2 = this.getLine();
                string = string2.toLowerCase();
                n2 = 0;
                n = 0;
                this.DBs.remove(dB.getID());
                this.DBs.put(dB.getID(), dB);
                continue;
            }
            if (string.indexOf("<usedb>", n2) != -1) {
                this.procUseDB(string, string2, dB);
                n2 = 0;
                n = 0;
                string2 = this.getLine();
                string = string2.toLowerCase();
                continue;
            }
            if (string.indexOf("<direction>", n2) != -1) {
                this.procDirection(string, string2, dB);
                n2 = 0;
                n = 0;
                string2 = this.getLine();
                string = string2.toLowerCase();
                continue;
            }
            if (string.indexOf("<dbdriver>", n2) != -1) {
                this.procDBDriver(string, string2, dB);
                string2 = this.getLine();
                string = string2.toLowerCase();
                continue;
            }
            if (string.indexOf("<dbname>", n2) != -1) {
                this.procDBName(string, string2, dB);
                n2 = 0;
                n = 0;
                string2 = this.getLine();
                string = string2.toLowerCase();
                continue;
            }
            if (string.indexOf("<sql>", n2) != -1) {
                string2 = this.getLine();
                string = string2.toLowerCase();
                this.procSQL(dB, false);
                string2 = this.getLine();
                string = string2.toLowerCase();
                n2 = 0;
                continue;
            }
            if (string.indexOf("<storedproc>") != -1) {
                string2 = this.getLine();
                string = string2.toLowerCase();
                this.procSQL(dB, true);
                string2 = this.getLine();
                string = string2.toLowerCase();
                n2 = 0;
                continue;
            }
            if (string.indexOf("<username>") != -1) {
                this.procDBUserName(string, string2, dB);
                string2 = this.getLine().trim();
                string = string2.toLowerCase();
                n2 = 0;
                continue;
            }
            if (string.indexOf("<password>") != -1) {
                this.procDBPass(string, string2, dB);
                n2 = 0;
                n = 0;
                string2 = this.getLine().trim();
                string = string2.toLowerCase();
                continue;
            }
            if (string.indexOf("<usemethod") == -1) continue;
            this.procDBMethod(string, string2, dB);
            n2 = 0;
            n = 0;
            string2 = this.getLine().trim();
            string = string2.toLowerCase();
        }
        this.DBs.put(dB.getID(), dB);
        Object var4_7 = null;
        dB = null;
    }

    private void readHeader() throws Exception {
        String string = this.getLine().trim();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string;
        string = string.toLowerCase();
        while (string.indexOf("</head>") == -1) {
            if (string.indexOf("<varlist") != -1) {
                this.procVarList(string, string2);
                bl = false;
                bl2 = false;
                string2 = this.getLine().trim();
                string = string2.toLowerCase();
                continue;
            }
            if (string.indexOf("<object") != -1) {
                this.procObject(string, string2);
                bl = false;
                bl2 = false;
                string2 = this.getLine().trim();
                string = string2.toLowerCase();
                continue;
            }
            if (string.indexOf("<db") != -1) {
                this.procDB(string, string2);
                string2 = this.getLine();
                string = string2.toLowerCase();
                continue;
            }
            this.out.println(string2);
            bl = false;
            bl2 = false;
            string2 = this.getLine();
            string = string2.toLowerCase();
        }
        if (this.isHTML) {
            this.out.println(string2);
        }
        Object var9_5 = null;
        Object var10_6 = null;
        Object var11_7 = null;
        Object var12_8 = null;
    }

    private Class getClass(String string) throws Exception {
        if (string.equalsIgnoreCase("int")) {
            return Class.forName("java.lang.Integer");
        }
        if (string.equalsIgnoreCase("string")) {
            return Class.forName("java.lang.String");
        }
        if (string.equalsIgnoreCase("date")) {
            return class$java$sql$Date == null ? (class$java$sql$Date = IDRSReport.class$("java.sql.Date")) : class$java$sql$Date;
        }
        if (string.equalsIgnoreCase("time")) {
            return class$java$sql$Time == null ? (class$java$sql$Time = IDRSReport.class$("java.sql.Time")) : class$java$sql$Time;
        }
        if (string.equalsIgnoreCase("userid")) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = IDRSReport.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (string.equalsIgnoreCase("connection")) {
            return class$java$sql$Connection == null ? (class$java$sql$Connection = IDRSReport.class$("java.sql.Connection")) : class$java$sql$Connection;
        }
        if (string.equalsIgnoreCase("boolean")) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = IDRSReport.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (string.equalsIgnoreCase("float")) {
            return class$java$lang$Float == null ? (class$java$lang$Float = IDRSReport.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (string.equalsIgnoreCase("dataset")) {
            return class$net$sourceforge$idrs$script$IdrsDB == null ? (class$net$sourceforge$idrs$script$IdrsDB = IDRSReport.class$("net.sourceforge.idrs.script.IdrsDB")) : class$net$sourceforge$idrs$script$IdrsDB;
        }
        if (string.equalsIgnoreCase("scripter")) {
            return class$net$sourceforge$idrs$script$IDRSScript == null ? (class$net$sourceforge$idrs$script$IDRSScript = IDRSReport.class$("net.sourceforge.idrs.script.IDRSScript")) : class$net$sourceforge$idrs$script$IDRSScript;
        }
        return null;
    }

    private void procSQL(DB dB, boolean bl) throws Exception {
        Vector vector;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = "";
        String string2 = "";
        String string3 = this.getLine();
        String string4 = string3.toLowerCase();
        String string5 = bl ? "</storedproc>" : "</sql>";
        while (string4.indexOf("</src>") == -1) {
            string = string + string3.trim() + " ";
            string3 = this.getLine();
            string4 = string3.toLowerCase();
        }
        string3 = this.getLine();
        string4 = string3.toLowerCase();
        while (string4.indexOf(string5) == -1) {
            n = string4.indexOf("<vartype>") + 9;
            n2 = string4.indexOf("</vartype>");
            string2 = string3.substring(n, n2);
            vector = (Vector)this.vars.get(dB.getID());
            if (string2.equalsIgnoreCase("UserID")) {
                dB.addVar(Integer.toString(this.userNum), "int");
            } else {
                dB.addVar((String)vector.elementAt(n3), string2);
            }
            string3 = this.getLine();
            string4 = string3.toLowerCase();
            ++n3;
        }
        dB.ProcSQL(string, bl);
        vector = null;
    }

    private void readBody() throws Exception {
        String string = this.getLine();
        String string2 = string.toLowerCase();
        int n = 0;
        while (string2.indexOf("</body>") == -1) {
            this.procLine(string, n, "");
            this.out.println();
            string = this.getLine();
            string2 = string.toLowerCase();
        }
        if (this.isHTML) {
            this.out.println(string);
        }
    }

    private void procLine(String string, int n, String string2) throws Exception {
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Object object;
        Class clazz;
        String string8;
        String string9;
        ObjectStore objectStore;
        String string10;
        String string11;
        String string12;
        int n2 = n;
        String string13 = string.toLowerCase();
        Object[] objectArray = new Object[]{new String(""), new String("")};
        String string14 = null;
        String string15 = "";
        Vector vector = new Vector();
        if (n < string13.length()) {
            if (string13.indexOf("<usemethod", n) != -1) {
                DB dB;
                n2 = string13.indexOf("<usemethod", n);
                this.out.print(string.substring(n, n2));
                n = n2;
                n = string13.indexOf("varlist", n);
                n = string13.indexOf("=", n);
                n = string13.indexOf("\"", n) + 1;
                n2 = string13.indexOf("\"", n);
                string12 = string.substring(n, n2);
                n = string13.indexOf("objid");
                n = string13.indexOf("=", n);
                n = string13.indexOf("\"", n) + 1;
                n2 = string13.indexOf("\"", n);
                string11 = string.substring(n, n2);
                n = string13.indexOf(">", n2) + 1;
                n2 = string13.indexOf("</usemethod>", n);
                string10 = string.substring(n, n2);
                objectStore = (ObjectStore)this.objects.remove(string11);
                Vector vector2 = (Vector)this.varLists.remove(string12);
                Vector vector3 = (Vector)this.vars.remove(string12);
                Vector<Object> vector4 = new Vector<Object>();
                Enumeration enumeration = vector3.elements();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    string9 = (String)enumeration.nextElement();
                    if (string9.equalsIgnoreCase("dataset")) {
                        string8 = (String)enumeration2.nextElement();
                        dB = (DB)this.DBs.remove(string8);
                        vector4.add(new DBShell(dB.getID(), dB));
                        continue;
                    }
                    if (string9.equalsIgnoreCase("scripter")) {
                        vector4.add(this);
                        continue;
                    }
                    clazz = (Class)enumeration2.nextElement();
                    vector4.add(ObjectStore.getValue(clazz, string9, null, this));
                }
                try {
                    this.out.print((String)objectStore.execMethod(string10, vector4.toArray()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Enumeration enumeration3 = vector4.elements();
                while (enumeration3.hasMoreElements()) {
                    object = enumeration3.nextElement();
                    if (object.getClass() != (class$net$sourceforge$idrs$script$DBShell == null ? IDRSReport.class$("net.sourceforge.idrs.script.DBShell") : class$net$sourceforge$idrs$script$DBShell)) continue;
                    DBShell dBShell = (DBShell)object;
                    dB = dBShell.getDB();
                    this.DBs.put(dB.getID(), dB);
                }
                this.varLists.put(string12, vector2);
                this.vars.put(string12, vector3);
                this.objects.put(string11, objectStore);
                n = n2 + 12;
            } else if (string13.indexOf("<ifchange", n) != -1) {
                this.checkIsChange = true;
                n = string13.indexOf("\"", string13.indexOf("field")) + 1;
                n2 = string13.indexOf("\"", n + 1);
                string7 = string.substring(n, n2);
                string7 = string7.substring(string7.indexOf(".") + 1);
                n = string13.length();
                try {
                    string6 = (String)this.tracking.get(string7);
                }
                catch (Exception exception) {
                    string6 = null;
                }
                if (string6 != null) {
                    DB dB = (DB)this.DBs.get(string2);
                    string15 = dB.getFieldData(string7, null);
                    if (!string15.equalsIgnoreCase(string6)) {
                        this.isChanged = true;
                        this.tracking.put(string7, string15);
                    } else {
                        this.isChanged = false;
                    }
                } else {
                    DB dB = (DB)this.DBs.get(string2);
                    string15 = dB.getFieldData(string7, null);
                    this.tracking.put(string7, string15);
                    this.isChanged = true;
                }
            } else if (string13.indexOf("<field", n) != -1) {
                n2 = string13.indexOf("<field", n);
                string5 = string.substring(n, n2);
                this.out.print(string5);
                n = n2 + 6;
                n2 = string13.indexOf("</field>", n2);
                if (string13.indexOf("format", n) < n2 && string13.indexOf("format", n) != -1) {
                    n = string13.indexOf("\"", string13.indexOf("format", n)) + 1;
                    n2 = string13.indexOf("\"", n);
                    string14 = string.substring(n, n2);
                    n = string13.indexOf(">", n) + 1;
                    n2 = string13.indexOf("</field>", n2);
                } else {
                    ++n;
                }
                string7 = string.substring(n, n2);
                if (string7.equalsIgnoreCase("<LineNum>")) {
                    this.out.print(this.getLineNum(string2));
                } else if (string7.equalsIgnoreCase("<ForeColor>")) {
                    this.lineNum = this.getLineNum(string2);
                    if (this.lineNum % 2 == 0) {
                        this.out.print((String)this.color1.get(string2));
                    } else {
                        this.out.print((String)this.color2.get(string2));
                    }
                } else if (string7.equalsIgnoreCase("<BackColor>")) {
                    this.lineNum = this.getLineNum(string2);
                    if (this.lineNum % 2 == 0) {
                        this.out.print((String)this.color2.get(string2));
                    } else {
                        this.out.print((String)this.color1.get(string2));
                    }
                } else {
                    string8 = string7.substring(0, string7.indexOf("."));
                    string7 = string7.substring(string7.indexOf(".") + 1);
                    DB dB = (DB)this.DBs.get(string8);
                    this.out.print(dB.getFieldData(string7, string14));
                }
                n = n2 + 8;
            } else if (string13.indexOf("<inputresults>", n) != -1) {
                n2 = string13.indexOf("<inputresults>", n);
                this.out.print(string.substring(n, n2));
                n = n2 + 14;
                n2 = string13.indexOf("</inputresults>", n);
                String string16 = string.substring(n, n2);
                DB dB = (DB)this.DBs.get(string16);
                this.out.println(dB.getUpdateResult());
                dB = null;
                n = n2 + 15;
            } else if (string13.indexOf("<repeat") != -1) {
                n = string13.indexOf("\"", string13.indexOf("id")) + 1;
                n2 = string13.indexOf("\"", n + 1);
                string8 = string.substring(n, n2);
                try {
                    n = string13.indexOf("\"", string13.indexOf("color1")) + 1;
                    n2 = string13.indexOf("\"", n);
                    string4 = string.substring(n, n2);
                    this.color1.put(string8, string4);
                    n = string13.indexOf("\"", string13.indexOf("color2")) + 1;
                    n2 = string13.indexOf("\"", n);
                    string3 = string.substring(n, n2);
                    this.color2.put(string8, string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Vector<String> vector5 = new Vector<String>();
                string = this.getLine();
                string13 = string.toLowerCase();
                while (string13.indexOf("</repeat>") == -1) {
                    vector5.addElement(string);
                    string = this.getLine();
                    string13 = string.toLowerCase();
                }
                this.procRepeat(vector5, string8);
                n = string13.length();
            } else if (string13.indexOf("<navnext>", n) != -1) {
                n2 = string13.indexOf("<navnext>", n);
                this.out.println(string.substring(n, n2));
                n = n2 + 9;
                n2 = string13.indexOf("</navnext>", n);
                this.out.print(this.getNavTag(true, string.substring(n, n2)));
                n = n2 + 10;
            } else if (string13.indexOf("<navprev>", n) != -1) {
                n2 = string13.indexOf("<navprev>", n);
                this.out.println(string.substring(n, n2));
                n = n2 + 9;
                n2 = string13.indexOf("</navprev>", n);
                this.out.print(this.getNavTag(false, string.substring(n, n2)));
                n = n2 + 10;
            } else if (string13.indexOf("<$=", n) != -1) {
                n2 = string13.indexOf("<$=", n);
                this.out.println(string.substring(n, n2));
                n = n2 + 3;
                n = this.procEvalScript(string13, string, n);
            } else if (string13.indexOf("<$", n) != -1) {
                n2 = string13.indexOf("<$", n);
                this.out.println(string.substring(n, n2));
                n = n2 + 2;
                n = this.procScript(string13, string, n);
            } else {
                if (string13.indexOf("<body>", n) != -1) {
                    if (this.isHTML) {
                        this.out.print(string.substring(n));
                    }
                } else {
                    this.out.print(string.substring(n));
                }
                n = string13.length();
            }
            this.procLine(string, n, string2);
        }
        string10 = null;
        string4 = null;
        string3 = null;
        string12 = null;
        string13 = null;
        objectArray = null;
        string5 = null;
        string7 = null;
        string14 = null;
        string15 = null;
        string8 = null;
        string6 = null;
        vector = null;
        string11 = null;
        objectStore = null;
        string9 = null;
        clazz = null;
        object = null;
    }

    private int procEvalScript(String string, String string2, int n) throws Exception {
        int n2 = string.indexOf("$>");
        String string3 = string2.substring(n, n2).trim();
        this.out.print(this.idrs.eval(string3));
        return n2 + 2;
    }

    private int procScript(String string, String string2, int n) throws Exception {
        String string3 = "";
        if (string.trim().equals("<$")) {
            string2 = this.getLine();
            string = string2.toLowerCase();
            n = 0;
        }
        int n2 = n;
        while (n2 < string.length() && string.charAt(n2) == " ".charAt(0)) {
            ++n2;
        }
        n = n2;
        while (string.indexOf("$>") == -1) {
            string3 = string3 + string2.substring(n) + "\n";
            string2 = this.getLine();
            string = string2.toLowerCase();
        }
        int n3 = string.indexOf("$>");
        string3 = n3 > n ? string3 + string2.substring(n, n3) : string3 + string2.substring(0, n3);
        this.idrs.exec(string3);
        return n3 + 2;
    }

    private String getNavTag(boolean bl, String string) throws Exception {
        String string2;
        String string3;
        Enumeration enumeration;
        Enumeration enumeration2;
        Vector vector;
        Vector vector2;
        DB dB;
        String string4;
        String string5 = this.IdrsUrl + "?doc_ID=" + Integer.toString(this.docID) + "&";
        Enumeration enumeration3 = this.vars.keys();
        boolean bl2 = false;
        int n = 0;
        while (enumeration3.hasMoreElements() && !bl2) {
            string4 = (String)enumeration3.nextElement();
            if (this.DBs.containsKey(string4)) {
                dB = (DB)this.DBs.remove(string4);
                vector2 = (Vector)this.vars.remove(string4);
                vector = (Vector)this.varsNames.remove(string4);
                enumeration2 = vector2.elements();
                enumeration = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    string3 = (String)enumeration2.nextElement();
                    string2 = (String)enumeration.nextElement();
                    if (string2.equalsIgnoreCase("ignore")) continue;
                    string5 = string5 + string4 + "_" + string2 + "=" + URLEncoder.encode(string3) + "&";
                }
                this.vars.put(string4, vector2);
                this.varsNames.put(string4, vector);
                if (dB.getIsPaged()) {
                    boolean bl3;
                    String string6 = "";
                    string6 = string6 + string4 + "_PageSize=" + URLEncoder.encode(Integer.toString(dB.getNumRecs())) + "&";
                    string6 = string6 + string4 + "_FirstRecord=";
                    if (bl) {
                        string6 = string6 + URLEncoder.encode(Integer.toString(dB.getNumRecs() + dB.getFirstRec()));
                        bl2 = !dB.getHasNext();
                    } else if (dB.getFirstRec() != 0) {
                        string6 = string6 + URLEncoder.encode(Integer.toString(dB.getFirstRec() - dB.getNumRecs()));
                        bl3 = false;
                    } else {
                        bl2 = true;
                        bl3 = true;
                    }
                    string6 = string6 + "&";
                    if (!bl2) {
                        bl2 = false;
                        ++n;
                    } else {
                        bl2 = false;
                    }
                    string5 = string5 + string6;
                }
                this.DBs.put(string4, dB);
                continue;
            }
            vector2 = (Vector)this.vars.remove(string4);
            vector = (Vector)this.varsNames.remove(string4);
            enumeration2 = vector2.elements();
            enumeration = vector.elements();
            while (enumeration2.hasMoreElements()) {
                string3 = (String)enumeration2.nextElement();
                string2 = (String)enumeration.nextElement();
                if (string2.equalsIgnoreCase("ignore")) continue;
                string5 = string5 + string4 + "_" + string2 + "=" + URLEncoder.encode(string3) + "&";
            }
            this.vars.put(string4, vector2);
            this.varsNames.put(string4, vector);
        }
        if (n > 0) {
            string5 = string5.substring(0, string5.length() - 1);
            string4 = null;
            enumeration3 = null;
            dB = null;
            enumeration2 = null;
            vector2 = null;
            vector = null;
            enumeration = null;
            string3 = null;
            string2 = null;
            return "<a href=\"" + string5 + "\">" + string + "</a>";
        }
        string4 = null;
        enumeration3 = null;
        dB = null;
        enumeration2 = null;
        vector2 = null;
        vector = null;
        enumeration = null;
        string3 = null;
        string2 = null;
        return "";
    }

    private boolean rsContinue(DB dB) throws Exception {
        if (dB.getIsPaged()) {
            return dB.getNumRecs() > dB.getCurrLocation() - dB.getFirstRec() && dB.next();
        }
        return dB.next();
    }

    private void procRepeat(Vector vector, String string) throws Exception {
        String string2;
        String string3;
        Enumeration enumeration;
        this.lineNum = 0;
        DB dB = (DB)this.DBs.get(string);
        while (this.rsContinue(dB)) {
            this.addLineNum(string);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                if (this.checkIsChange) {
                    if (this.isChanged) {
                        string2 = string3.toLowerCase();
                        while (string2.indexOf("</ifchange>") == -1) {
                            this.procLine(string3, 0, string);
                            string3 = (String)enumeration.nextElement();
                            string2 = string3.toLowerCase();
                        }
                        this.checkIsChange = false;
                        continue;
                    }
                    string2 = string3.toLowerCase();
                    while (string2.indexOf("</ifchange>") == -1) {
                        string3 = (String)enumeration.nextElement();
                        string2 = string3.toLowerCase();
                    }
                    this.checkIsChange = false;
                    continue;
                }
                string2 = string3.toLowerCase();
                this.procLine(string3, 0, string);
                this.out.println();
            }
        }
        enumeration = null;
        string2 = null;
        string3 = null;
        dB = null;
    }

    private int getLineNum(String string) throws Exception {
        Integer n = (Integer)this.lineNums.get(string);
        return n;
    }

    private void addLineNum(String string) throws Exception {
        Integer n = (Integer)this.lineNums.get(string);
        int n2 = n;
        this.lineNums.put(string, new Integer(++n2));
    }

    public void addVarList(String string) throws Exception {
        this.vars.put(string, new Vector());
    }

    public void removeVarList(String string) throws Exception {
        this.vars.remove(string);
    }

    public void clearVarList() throws Exception {
        this.vars.clear();
    }

    public void addVar(String string, String string2) throws Exception {
        Vector vector = (Vector)this.vars.get(string2);
        vector.addElement(string);
        this.vars.put(string2, vector);
    }

    public void addVarName(String string, String string2) throws Exception {
        if (!this.varsNames.containsKey(string2)) {
            this.varsNames.put(string2, new Vector());
        }
        Vector vector = (Vector)this.varsNames.remove(string2);
        vector.add(string);
        this.varsNames.put(string2, vector);
        vector = null;
    }

    public void removeVar(int n, String string) throws Exception {
        Vector vector = (Vector)this.vars.get(string);
        vector.removeElementAt(n);
        this.vars.put(string, vector);
    }

    public void editVar(int n, String string, String string2) throws Exception {
        Vector vector = (Vector)this.vars.get(string2);
        vector.set(n, string);
        this.vars.put(string2, vector);
    }

    public void clearVars(String string) throws Exception {
        Vector vector = (Vector)this.vars.get(string);
        vector.clear();
        this.vars.put(string, vector);
    }

    public void setPageSize(String string, int n) throws Exception {
        if (this.pageSizes.containsKey(string)) {
            this.pageSizes.remove(string);
        }
        this.pageSizes.put(string, new Integer(n));
    }

    public void setPageFirst(String string, int n) throws Exception {
        if (this.pageStart.containsKey(string)) {
            this.pageStart.remove(string);
        }
        this.pageStart.put(string, new Integer(n));
    }

    public Hashtable getCacheDBs() throws Exception {
        return this.DBcache;
    }

    public String getFieldData(String string, String string2, String string3) throws Exception {
        DB dB = (DB)this.DBs.get(string);
        if (dB == null) {
            throw new Exception("DB " + string + " no found");
        }
        return dB.getFieldData(string2, string3);
    }

    public String getFieldData(String string, String string2) throws Exception {
        return this.getFieldData(string, string2, null);
    }

    public boolean next(String string) throws Exception {
        DB dB = (DB)this.DBs.get(string);
        if (dB == null) {
            throw new Exception("DB " + string + " no found");
        }
        return dB.next();
    }

    public boolean moveTo(String string, int n) throws Exception {
        DB dB = (DB)this.DBs.get(string);
        if (dB == null) {
            throw new Exception("DB " + string + " no found");
        }
        return dB.moveTo(n);
    }

    public Object getObject(String string) throws Exception {
        try {
            ObjectStore objectStore = (ObjectStore)this.objects.get(string);
            if (objectStore == null) {
                throw new Exception("No Object defined : " + string);
            }
            return objectStore.getRef();
        }
        catch (Exception exception) {
            throw new Exception("No Object defined : " + string);
        }
    }

    public PrintWriter getOut() throws Exception {
        return this.out;
    }

    public HttpSession getSession() throws Exception {
        return this.session;
    }

    public HttpServletRequest getRequest() throws Exception {
        return this.request;
    }

    public int getInputResults(String string) throws Exception {
        DB dB = (DB)this.DBs.get(string);
        if (dB == null) {
            throw new Exception("DB " + string + " no found");
        }
        return dB.getUpdateResult();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

