/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.idrs.core;

import java.util.Date;
import net.sourceforge.idrs.core.IDRSReport;
import net.sourceforge.idrs.utils.pool.ObjectPool;
import net.sourceforge.idrs.utils.pool.PooledObject;

public class IDRSPool
extends ObjectPool {
    protected String scriptClass;

    public IDRSPool(int n, int n2, long l, long l2, String string, int n3, String string2) throws Exception {
        super(n, n2, l, l2, string, n3);
        this.scriptClass = string2;
        this.logHeader();
        if (n >= 0) {
            int n4 = 0;
            while (n4 < n) {
                PooledObject pooledObject = this.create();
                pooledObject.isFree(true);
                this.pool[this.count] = pooledObject;
                ++this.count;
                ++n4;
            }
        }
    }

    public void logHeader() throws Exception {
        this.out.println("Starting PoolMan, IDRS version");
        this.out.println("IDRS Report Pool");
        this.out.println("Script Class : " + this.scriptClass);
        this.out.println("log file = " + this.logPath);
        this.out.println("min objects = " + Integer.toString(this.minn));
        this.out.println("max objects = " + Integer.toString(this.limit));
        this.out.println("Total refresh intervel = " + Long.toString(this.daysOpen) + " days");
        this.out.println("-----------------------------------------");
    }

    protected PooledObject create() throws Exception {
        try {
            IDRSReport iDRSReport = new IDRSReport(this.scriptClass);
            Date date = new Date(System.currentTimeMillis());
            this.out.println(date.toString() + " Opening report " + this.count + " " + iDRSReport.toString());
            return new PooledObject(System.currentTimeMillis(), true, iDRSReport);
        }
        catch (Exception exception) {
            Date date = new Date(System.currentTimeMillis());
            this.out.println(date.toString() + " Opening report error " + this.count + " : " + exception);
            return null;
        }
    }

    protected boolean validate(PooledObject pooledObject) {
        IDRSReport iDRSReport = (IDRSReport)pooledObject.getValue();
        try {
            return iDRSReport != null;
        }
        catch (Exception exception) {
            this.out.println(exception);
            return false;
        }
    }

    protected void expire(PooledObject pooledObject) {
        try {
            pooledObject.setValue(null);
        }
        catch (Exception exception) {
            this.out.println(exception);
        }
    }

    protected void reset(int n) {
        try {
            this.pool[n].setValue(null);
            this.pool[n] = null;
            this.out.println("----->Resetting connection " + n + " ...");
            int n2 = this.count;
            this.count = n;
            this.pool[n] = this.create();
            this.count = n2;
        }
        catch (Exception exception) {
            this.out.println(exception);
        }
    }
}

