/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.testcase.models;

import freemarker.template.*;
import freemarker.template.utility.*;

/**
 * Part of the TestTransform testcase suite.
 *
 * @author  <a href="mailto:run2000@users.sourceforge.net">Nicholas Cull</a>
 * @version 0.1
 */
public class TransformHashWrapper extends Object implements TemplateHashModel,
        TemplateScalarModel {

    private SimpleHash m_cHashModel = new SimpleHash();

    /** Creates new TransformHashWrapper */
    public TransformHashWrapper() {
        m_cHashModel.put( "htmlEscape", new HtmlEscape() );
        m_cHashModel.put( "compress", new LegacyCompress() );
        m_cHashModel.put( "escape", new TransformMethodWrapper1() );
        m_cHashModel.put( "special", new TransformMethodWrapper2() );
    }

    /**
     * Gets a <tt>TemplateModel</tt> from the hash.
     *
     * @param key the name by which the <tt>TemplateModel</tt>
     * is identified in the template.
     * @return the <tt>TemplateModel</tt> referred to by the key,
     * or null if not found.
     */
    public TemplateModel get(String key) throws TemplateModelException {
        return m_cHashModel.get( key );
    }
    
    /**
     * @return true if this object is empty.
     */
    public boolean isEmpty() throws TemplateModelException {
        return false;
    }
    
    /**
     * Returns the scalar's value as a String.
     *
     * @return the String value of this scalar.
     */
    public String getAsString() throws TemplateModelException {
        return "Utility transformations";
    }
    
}
