/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.testcase.models;

import java.util.List;
import freemarker.template.*;

/**
 * A simple method model used as a test bed.
 *
 * @version $Id: SimpleTestMethod.java,v 1.1 2001/05/27 05:45:44 run2000 Exp $
 */
public class SimpleTestMethod implements freemarker.template.TemplateMethodModel {

    /** Creates new SimpleTestMethod */
    public SimpleTestMethod () {
    }

    /**
     * Executes a method call.
     *
     * @param arguments a <tt>List</tt> of <tt>String</tt> objects containing the values
     * of the arguments passed to the method.
     * @return the <tt>TemplateModel</tt> produced by the method, or null.
     */
    public TemplateModel exec(List arguments) throws TemplateModelException {
        if( arguments.size() == 0 ) {
            return new SimpleScalar( "Empty list provided" );
        } else if( arguments.size() > 1 ) {
            return new SimpleScalar( "Argument size is: " + arguments.size() );
        } else {
            return new SimpleScalar( "Single argument value is: " + arguments.get(0) );
        }
    }
    
    /**
     * @return true if this object is empty.
     */
    public boolean isEmpty() throws TemplateModelException {
        return false;
    }
    
}
