/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.testcase.models;

import freemarker.template.*;

/**
 * Testcase to see how FreeMarker deals with multiple Template models.
 */
public class MultiModel4 extends Object implements TemplateListModel, TemplateHashModel {

    private SimpleList  m_cList = new SimpleList();

    /** Creates new MultiModel4 */
    public MultiModel4() {
    }

    /**
     * Resets the cursor to the beginning of the list.
     */
    public void rewind() throws TemplateModelException {
        m_cList.rewind();
    }

    /**
     * @return true if the cursor is at the beginning of the list.
     */
    public boolean isRewound() throws TemplateModelException {
        return m_cList.isRewound();
    }

    /**
     * @return true if there is a next element.
     */
    public boolean hasNext() throws TemplateModelException {
        return m_cList.hasNext();
    }

    /**
     * @return the next element in the list.
     */
    public TemplateModel next() throws TemplateModelException {
        return m_cList.next();
    }

    /**
     * @return the size of the list as a TemplateModel
     */
    public TemplateModel listSize() throws TemplateModelException {
        // Important! This lets us use the "size" key instead.
        return null;
    }

    /**
     * @return the specified index in the list
     */
    public TemplateModel get(int i) throws TemplateModelException {
        return m_cList.get( i );
    }

    /**
     * @return true if this object is empty.
     */
    public boolean isEmpty() throws TemplateModelException {
        return m_cList.isEmpty();
    }
    
    /**
     * Gets a <tt>TemplateModel</tt> from the hash.
     *
     * @param key the name by which the <tt>TemplateModel</tt>
     * is identified in the template.
     * @return the <tt>TemplateModel</tt> referred to by the key,
     * or null if not found.
     */
    public TemplateModel get(String key) throws TemplateModelException {
        if( key.equals( "size" )) {
            return new SimpleScalar( "Key size, not the listSize method." );
        } else {
            return null;
        }
    }
    
}
