/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.testcase.models;

import freemarker.template.*;

/**
 * Testcase to see how FreeMarker deals with multiple Template models.
 */
public class MultiModel1 implements TemplateHashModel,
        TemplateListModel, TemplateScalarModel {
    
    private TemplateModel m_cSubModel = new MultiModel2();
    private TemplateModel m_cListHashModel1 = new MultiModel4();
    private TemplateModel m_cListHashModel2 = new MultiModel5();
    private TemplateListModel m_cListModel = new SimpleList();
    private TemplateHashModel m_cHashModel = new SimpleHash();

    /** Creates new MultiModel1 */
    public MultiModel1() {
        for( int i = 0; i < 10; i++ ) {
            ((SimpleList)m_cListModel).add( "Model1 value: " + Integer.toString( i ));
        }
        ((SimpleList)m_cListModel).add( new MultiModel3() );
        ((SimpleHash)m_cHashModel).put( "nested", new MultiModel3() );
    }
    
    /**
     * Gets a <tt>TemplateModel</tt> from the hash.
     *
     * @param key the name by which the <tt>TemplateModel</tt>
     * is identified in the template.
     * @return the <tt>TemplateModel</tt> referred to by the key,
     * or null if not found.
     */
    public TemplateModel get(String key) throws TemplateModelException {
        if( key.equals( "model2" )) {
            return m_cSubModel;
        } else if( key.equals( "modellist" )) {
            return m_cListModel;
        } else if( key.equals( "selftest" )) {
            return new SimpleScalar( "Selftest of a hash from MultiModel1" );
        } else if( key.equals( "one" )) {
            return m_cListHashModel1;
        } else if( key.equals( "two" )) {
            return m_cListHashModel2;
        } else if( key.equals( "size" )) {
            return new SimpleScalar( "Nasty!" );
        } else if( key.equals( "nesting1" )) {
            return m_cHashModel;
        } else {
            return null;
        }
    }
    
    /**
     * @return true if this object is empty.
     */
    public boolean isEmpty() throws TemplateModelException {
        return false;
    }
    
    /**
     * Resets the cursor to the beginning of the list.
     */
    public void rewind() throws TemplateModelException {
        m_cListModel.rewind();
    }
    
    /**
     * @return true if the cursor is at the beginning of the list.
     */
    public boolean isRewound() throws TemplateModelException {
        return m_cListModel.isRewound();
    }
    
    /**
     * @return true if there is a next element.
     */
    public boolean hasNext() throws TemplateModelException {
        return m_cListModel.hasNext();
    }
    
    /**
     * @return the next element in the list.
     */
    public TemplateModel next() throws TemplateModelException {
        return m_cListModel.next();
    }
    
    /**
     * @return the specified index in the list
     */
    public TemplateModel get(int i) throws TemplateModelException {
        return m_cListModel.get( i );
    }
    
    /**
     * Returns the scalar's value as a String.
     *
     * @return the String value of this scalar.
     */
    public String getAsString() throws TemplateModelException {
        return "MultiModel1 as a string!";
    }
}
