/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.testcase.models;

import freemarker.template.*;

/**
 * A template that always throws an exception whenever we call getAsString()
 */
public class ExceptionModel implements TemplateScalarModel {

    /** Creates new ExceptionModel */
    public ExceptionModel () {
    }

    /**
     * Returns the scalar's value as a String.
     *
     * @return the String value of this scalar.
     */
    public String getAsString () throws TemplateModelException {
        throw new TemplateModelException( "Throwing from ExceptionModel!" );
    }
    
    /**
     * @return true if this object is empty.
     */
    public boolean isEmpty () throws TemplateModelException {
        return false;
    }
    
}
