/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.testcase;

import freemarker.template.*;
import freemarker.testcase.models.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.StringReader;
import junit.framework.*;

/** Test class for testing FreeMarker's number literal syntax.
 *
 * @version $Id: TestNumberLiteral.java,v 1.2 2001/06/19 12:07:13 run2000 Exp $
 */
public class TestNumberLiteral extends AbstractTestCase {
    protected SimpleHash    modelRoot;
    
    /** Create a new TestNumberLiteral test case */
    public TestNumberLiteral( String aTestname ) {
        super( aTestname );
    }

    /**
     * Set up the test case prior to running.
     */
    public void setUp() {
        setUpFiles( "test-numberliteral.html" );

        // Make a template data model.
        SimpleHash cModel1 = new SimpleHash();
        
        cModel1.put("1", "one");
        cModel1.put("12", "twelve");
        cModel1.put( "2one", "two-one" );
        cModel1.put( "one2", "one-two" );
        
        SimpleList cModel2 = new SimpleList();
        
        cModel2.add( "zero" );
        cModel2.add( "one" );
        cModel2.add( "two" );
        cModel2.add( "three" );
        cModel2.add( "four" );
        cModel2.add( "five" );
        cModel2.add( "six" );
        cModel2.add( "seven" );
        cModel2.add( "eight" );
        cModel2.add( "nine" );
        cModel2.add( "tenth" );
        cModel2.add( "eleven" );
        cModel2.add( "twelve" );

        modelRoot = new SimpleHash();
        modelRoot.put("message", "Hello, world!");
        modelRoot.put("foo", "bar");
        modelRoot.put("one", "1");
        modelRoot.put("1", "one");
        modelRoot.put("12", "twelve");
        modelRoot.put("2one", "two-one");
        modelRoot.put("one2", "one-two");
        modelRoot.put("hash", cModel1);
        modelRoot.put("list", cModel2);
        modelRoot.put("call", new SimpleTestMethod() );
    }

    /**
     * Abstract method for performing the test. The implementing class should
     * indicate clearly whether the test has passed. A pass result should be
     * written to screen. A fail result should also generate information about
     * the failure.
     */
    public void runTest() {
        Template cTemplate;
        StringWriter cWriter = new StringWriter();
        PrintWriter cOut = new PrintWriter( cWriter );

        try {
            cTemplate = new Template( new StringReader( m_aTemplateText ));
        } catch( IOException e ) {
            fail( e.getMessage() );
            return;
        }

        // Process the template.
        cTemplate.process(modelRoot, cOut);
        cOut.flush();
        cOut.close();

        showTestResults( m_aReferenceText, cWriter.toString() );
    }

    /** Bootstrap for the self-test code.
     */
    public static void main( String[] argc ) throws Exception {
        AbstractTestCase cTest = new TestNumberLiteral( "test-numberliteral.html" );
        TestResult cResults = new TestResult();

        cTest.run();
    }
}
