/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.testcase;

import freemarker.template.*;
import freemarker.testcase.models.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.StringReader;
import junit.framework.*;

/**
 * Test case for the situation where a template throws a TemplateModelException.
 */
public class TestException extends AbstractTestCase {
    protected TemplateModelRoot modelRoot;

    /** Creates new TestException */
    public TestException ( String aTestname ) {
        super( aTestname );
    }

    /**
     * Set up the test case prior to running.
     */
    public void setUp() {
        setUpFiles( "test-exception.html" );

        // Make a template data model.
        modelRoot = new SimpleHash();
        modelRoot.put( "message", new SimpleScalar( "Hello, world!" ) );
        modelRoot.put( "test", new ExceptionModel() );
    }

    /**
     * Abstract method for performing the test. The implementing class should
     * indicate clearly whether the test has passed. A pass result should be
     * written to screen. A fail result should also generate information about
     * the failure.
     */
    public void runTest() {
        Template cTemplate;
        StringWriter cWriter = new StringWriter();
        PrintWriter cOut = new PrintWriter( cWriter );

        try {
            cTemplate = new Template( new StringReader( m_aTemplateText ));
        } catch( IOException e ) {
            fail( e.getMessage() );
            return;
        }

        // Process the template.
        cTemplate.process(modelRoot, cOut);
        cOut.flush();
        cOut.close();

        showTestResults( m_aReferenceText, cWriter.toString() );
    }


    /**
     * Small test suite for this test case.
     */
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestException("testException"));
        return suite;
    }
 
    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) throws Exception {
        AbstractTestCase cTester = new TestException( "test-exception.html" );
        TestResult cResult = new TestResult();

        cTester.run( cResult );
    }

}
