/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.testcase;

import freemarker.template.*;
import freemarker.template.utility.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.StringReader;
import junit.framework.*;

/** Test class for testing FreeMarker's &lt;compress&gt; tag, and the replacement
 * TemplateTransformModel classes.
 */
public class TestCompress extends AbstractTestCase {
    protected SimpleHash    modelRoot;
    
    public TestCompress (String aTestname) {
        super( aTestname );
    }

    /**
     * Set up the test case prior to running.
     */
    public void setUp() {
        setUpFiles( "test-compress.html" );

        // Make a template data model.
        SimpleHash  utility = new SimpleHash();

        modelRoot = new SimpleHash();
        modelRoot.put("message", new SimpleScalar("Hello, world!"));

        utility.put( "legacyCompress", new LegacyCompress() );
        utility.put( "compressWhitespace", new CompressWhitespace() );

        modelRoot.put( "utility", utility );
    }

    /**
     * Abstract method for performing the test. The implementing class should
     * indicate clearly whether the test has passed. A pass result should be
     * written to screen. A fail result should also generate information about
     * the failure.
     */
    public void runTest() {
        Template cTemplate;
        StringWriter cWriter = new StringWriter();
        PrintWriter cOut = new PrintWriter( cWriter );

        try {
            cTemplate = new Template( new StringReader( m_aTemplateText ));
        } catch( IOException e ) {
            fail( e.getMessage() );
            return;
        }

        // Process the template.
        cTemplate.process(modelRoot, cOut);
        cOut.flush();
        cOut.close();

        showTestResults( m_aReferenceText, cWriter.toString() );
    }

    /** Bootstrap for the self-test code.
     */
    public static void main( String[] argc ) throws Exception {
        AbstractTestCase cTest = new TestCompress( "test-compress.html" );
        TestResult cResults = new TestResult();

        cTest.run();
    }
}