/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.testcase;

import junit.framework.*;

/**
 * Test suite for FreeMarker. The suite conforms to interface expected by
 * <a href="http://junit.sourceforge.net/" target="_top">JUnit</a>.
 *
 * @version $Id: FreeMarkerTestSuite.java,v 1.7 2001/05/27 05:46:42 run2000 Exp $
 */
public class FreeMarkerTestSuite {

    public static Test suite() {
        TestSuite suite = new TestSuite();

        suite.addTest( new DummyTestCase( "dummyTestCase" ));
        suite.addTest( new TestComment( "commentTest" ));
        suite.addTest( new TestMultiModels( "multiModelTest" ));
        suite.addTest( new TestNoParse( "noParseTest" ));
        suite.addTest( new TestTransform( "transformTest" ));
        suite.addTest( new TestCompress( "compressionTest" ));
        suite.addTest( new TestListLiteral( "listLiteralTest" ));
        suite.addTest( new TestHashLiteral( "hashLiteralTest" ));
        suite.addTest( new TestNumberLiteral( "numberLiteralTest" ));

        // These tests are problematic in an automatic suite --
        // commenting out for now.
        //suite.addTest( new TestException( "exceptionTest" ));
        //suite.addTest( new TestExecModel( "execTest" ));

        return suite;
    }

	public static void main (String[] args) {
		junit.textui.TestRunner.run (suite());
	}
}
