/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.instruction;

import freemarker.template.*;
import freemarker.template.expression.*;
import java.io.*;

/**
 * An instruction that outputs the value of a <tt>Variable</tt>.
 */
public class VariableInstruction extends EmptyInstruction {

	private Variable variable;

	public VariableInstruction() { }

	public VariableInstruction(Variable variable) {
		this.variable = variable;
	}

    /**
     * @param modelRoot the root node of the data model.
     * @param out a PrintWriter to send the output to.
     */
    public void process(TemplateModelRoot modelRoot, PrintWriter out) {
		if (variable != null) {
			String variableValue = null;
			try {
				variableValue = variable.getValue(modelRoot);
			} catch (TemplateException e) {
				String variableName;
				try {
					variableName = variable.getName(modelRoot);
				} catch (TemplateException te) {
					out.print(Template.formatErrorMessage("Couldn't get value of variable, " +
						"or resolve its name: " + te.getMessage()));
					return;
				}
				out.print(Template.formatErrorMessage("Couldn't get value of variable " +
					variableName + ": " + e.getMessage()));
				return;
			}

			if (variableValue != null) {
				out.print(variableValue);
			}
		}
	}
}
