/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.instruction;

import freemarker.template.*;
import java.io.*;

/**
 * A TemplateProcessor representing a block of plain text.
 */
public class TextBlockInstruction extends NOOPInstruction {

    private char[] text;

    public TextBlockInstruction() { }

    public TextBlockInstruction(String text) {
		setText(text);
    }

    /**
     * @param text the text contained in this block.
     */
    public void setText(String text) {
		this.text = (text == null ? null : text.toCharArray());
    }

    /**
     * Outputs the text.
     *
     * @param modelRoot the root node of the data model.
     * @param out a PrintWriter to send the output to.
     */
    public void process(TemplateModelRoot modelRoot, PrintWriter out) {
		if (text != null) {
			out.print(text);
		}
    }
}
