/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.instruction;

import freemarker.template.*;
import freemarker.template.compiler.*;

/**
 * An interface that parsed instructions must implement.
 */
public interface Instruction {
	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int NONE = -1;

	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int BREAK = 0;

	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int CASE = 1;

	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int COMPRESS_END = 2;

	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int ELSE = 3;

	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int FUNCTION_END = 4;

	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int IF_END = 5;

	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int LIST_END = 6;

	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int SWITCH_END = 7;

        /**
         * Constant returned by <tt>getEndType()</tt>.
         */
        public static final int COMMENT_END = 8;

        /**
         * Constant returned by <tt>getEndType()</tt>.
         */
        public static final int FOREACH_END = LIST_END;
	
	/**
	 * Constant returned by <tt>getEndType()</tt>.
	 */
	public static final int NOPARSE_END = 9;

    /**
     * Constant returned by <tt>getEndType()</tt>.
     */
	public static final int TRANSFORM_END = 10;

	/**
	 * @return true if this instruction marks the end of a statement.
	 */
	public boolean isEndInstruction();

	/**
	 * @return the type of this instruction if it is an end instruction,
	 * otherwise <tt>NONE</tt>.
	 */
	public int getEndType();

	/**
	 * A <tt>TemplateBuilder</tt> can call this method to have an
	 * <tt>Instruction</tt> call it back to be built.  The <tt>Instruction</tt>
	 * will call the appropriate <tt>TemplateBuilder.buildStatement()</tt> method
	 * for its subclass, passing back a reference to itself, along with the
	 * <tt>RuntimeStructuralElement</tt> argument that is passed to this method.
	 * This approach is intended to make type-checking of
	 * <tt>Instruction</tt> objects unnecessary.
	 */
	public void callBuilder(TemplateBuilder builder,
		RuntimeStructuralElement element) throws TemplateException;
}
