/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.instruction;

import freemarker.template.*;
import freemarker.template.compiler.*;
import freemarker.template.expression.*;
import java.io.*;
import java.util.*;

/**
 * An instruction representing a function.
 */
public class FunctionInstruction extends GenericStartInstruction {
    private String name;
    private List argumentNames;

    public FunctionInstruction(String name, List argumentNames) {
	this.name = name;
	this.argumentNames = argumentNames;
    }

    public String getName() {
	return name;
    }

    public List getArgumentNames() {
	return argumentNames;
    }

    public boolean testEndInstruction(Instruction endInstruction) {
	return (endInstruction.getEndType() == FUNCTION_END);
    }

    public String getTypeName() {
	return "function";
    }

    public void callBuilder(TemplateBuilder builder,
			    RuntimeStructuralElement element) throws TemplateException {
	builder.buildStatement(this, element);
    }

    /**
     * @param modelRoot the root node of the data model.
     * @param out a PrintWriter to send the output to.
     */
    public void process(TemplateModelRoot modelRoot, PrintWriter out) {
	body.process(modelRoot, out);
    }
}
