/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.expression;

import freemarker.template.*;

public class NumberLiteral implements Expression {
		private Number value;

		public NumberLiteral() { }

		public NumberLiteral(String value) {
	setValue(value);
		}

		public void setValue(String value) {
			try
			{
				this.value = new Integer(value);
			}
			catch(NumberFormatException ex) {}
		}

		public String getValue(TemplateModelRoot modelRoot) throws TemplateException {
	return value !=null ? value.toString() : null;
		}

		public TemplateModel getAsTemplateModel(TemplateModelRoot modelRoot) throws TemplateException {
	return new SimpleScalar(getValue(modelRoot));
		}

		public boolean isTrue(TemplateModelRoot modelRoot) throws TemplateException {
	return value!=null;
		}

		public boolean isComplete() {
	return (value != null);
		}
	
	  public String toString() {
			if(value!=null) return value.toString();
			return null;
		}
	
		public int intValue() {
			return value.intValue();
		}
}
