/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.expression;

import java.util.*;
import freemarker.template.*;

public class ListLiteral implements Expression {
    private List values;

    public ListLiteral() {}

    public ListLiteral(List values) {
        setValue(values);
    }

    public void setValue(List values) {
        this.values = values;
    }

    public String getValue(TemplateModelRoot modelRoot) throws TemplateException {
        // If the list doesn't exist, return null, otherwise return the list size
        return (values == null) ? null : Integer.toString(values.size());
    }

    public TemplateModel getAsTemplateModel(TemplateModelRoot modelRoot) throws TemplateException {
        SimpleList list = new SimpleList();
        Iterator iItem;
        Expression  cItem;

        if( values != null ) {
            iItem = values.iterator();

            while( iItem.hasNext() ) {
                cItem = (Expression)iItem.next();
                list.add( cItem.getAsTemplateModel(modelRoot) );
            }
        }

        return list;
    }

    /**
     * For the benefit of method calls, return the list of arguments as a list
     * of values.
     */
    public List getValueList(TemplateModelRoot modelRoot) throws TemplateException {
		LinkedList list = new LinkedList();
		ListIterator iterator;
		Expression cItem;

        if( values != null ) {
            iterator = values.listIterator();

            while(iterator.hasNext()) {
                cItem = (Expression)iterator.next();
                list.add( cItem.getValue(modelRoot) );
            }
        }

        return list;
    }
    
    public boolean isTrue(TemplateModelRoot modelRoot) throws TemplateException {
        return (values != null);
    }

    public boolean isComplete() {
        return (values != null);
    }
}
