/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.expression;

import freemarker.template.*;
import freemarker.template.instruction.*;
import java.util.*;
import java.io.*;

/**
 * An identifer in a variable.
 */
public class Identifier extends Variable {

    private String name;

    public Identifier(String name) {
        setName(name);
    }

    public String getName(TemplateModelRoot modelRoot) throws TemplateException {
	return name;
    }

    public void setName(String name) {
	this.name = name;
    }

    /**
     * Gets the identifier's referent in modelRoot.
     *
     * @param modelRoot the root node of the data model.
     * @return the TemplateModel that the variable refers to.
     */
    public TemplateModel getAsTemplateModel(TemplateModelRoot modelRoot) throws TemplateException {
	TemplateModel referent = null;
	try {
	    referent = modelRoot.get(name);
	} catch (TemplateModelException e) {
	    throw new TemplateException("Couldn't get referent of " +
					name + ":\n" +
					Template.getStackTrace(e));
	}
	return referent;
    }

    public boolean isComplete() {
	return (name != null);
    }
}
