/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.expression;

import java.util.*;
import freemarker.template.*;

public class HashLiteral implements Expression {
    private AbstractMap values;

    public HashLiteral () {}

    public HashLiteral (List values) throws TemplateException {
        setValue(values);
    }

    public void setValue(List values) throws TemplateException {
        HashMap cHash = new HashMap();
        int iList;

        if( (values.size() % 2 ) != 0 ) {
            throw new TemplateException( "Incorrect number of parameters supplied for a hash literal" );
        }
        
        for( iList = 0; iList < values.size(); iList += 2 ) {
            cHash.put( values.get( iList ), values.get( iList + 1 ));
        }
        
        this.values = cHash;
    }

    public String getValue(TemplateModelRoot modelRoot) throws TemplateException {
        // If the hash doesn't exist, return null, otherwise return the list size
        return (values == null) ? null : Integer.toString(values.size());
    }

    public TemplateModel getAsTemplateModel(TemplateModelRoot modelRoot) throws TemplateException {
        SimpleHash hash = new SimpleHash();
        Set cKeys;
        Expression  cKey, cValue;
        Iterator    iItem;
        String aKey;

        if( values != null ) {
            cKeys = values.keySet();
            iItem = cKeys.iterator();

            while( iItem.hasNext() ) {
                cKey = (Expression)iItem.next();
                cValue = (Expression)values.get( cKey );
                hash.put( cKey.getValue(modelRoot), cValue.getAsTemplateModel(modelRoot) );
            }
        }

        return hash;
    }

    public boolean isTrue(TemplateModelRoot modelRoot) throws TemplateException {
        return (values != null);
    }

    public boolean isComplete() {
        return (values != null);
    }
}
