/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.expression;

import freemarker.template.*;

/**
 * An <tt>Expression</tt> can return its string, boolean, and TemplateModel
 * values.  Once complete (i.e. parsed), expressions should be immutable.
 */
public interface Expression extends ExpressionElement {

    /**
     * The boolean value of this <tt>Expression</tt>.
     *
     * @param modelRoot the root node of the data model.
     */
    public boolean isTrue(TemplateModelRoot modelRoot) throws TemplateException;

    /**
     * The string value of this <tt>Expression</tt>.
     *
     * @param modelRoot the root node of the data model.
     */
    public String getValue(TemplateModelRoot modelRoot) throws TemplateException;

    /**
     * The <tt>TemplateModel</tt> value of this <tt>Expression</tt>.
     */
    public TemplateModel getAsTemplateModel(TemplateModelRoot modelRoot) throws TemplateException;

    /**
     * @return true if this <tt>Expression</tt> is complete.
     */
    public boolean isComplete();
}

