/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.expression;

import freemarker.template.*;

/**
 * An interface for binary operators.
 */
public interface Binary extends Expression {
	/**
	 * @throws a <tt>TemplateException</tt> if the <tt>Expression</tt>
	 * is of an incompatible type for this operator.
	 */
    public void setLeft(Expression left) throws TemplateException;

	/**
	 * @throws a <tt>TemplateException</tt> if the <tt>Expression</tt>
	 * is of an incompatible type for this operator.
	 */
    public void setRight(Expression right) throws TemplateException;

    public Expression getLeft();
    public Expression getRight();
}
