/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.compiler;

import freemarker.template.*;
import java.io.*;

/**
 * A linked list of TemplateLink objects.
 */
class TemplateLinkedList implements TemplateProcessor {

    private TemplateLink head;
	private TemplateLink tail;

    TemplateLinkedList() { }

    /**
     * Adds a link to the list.
     */
    void add(TemplateLink link) {
		if (head == null) {
			head = link;
		} else {
			tail.setNext(link);
		}
		tail = link;
    }

    /**
     * Processes all the links in the list.
     *
     * @param modelRoot the root node of the data model.
     * @param out a PrintWriter to send the output to.
     */
    public void process(TemplateModelRoot modelRoot, PrintWriter out) {
		TemplateLink current = head;
		while (current != null) {
			current.process(modelRoot, out);
			current = current.getNext();
		}
    }
}
