/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template.compiler;

import freemarker.template.*;

/**
 * An interface for structural elements of the compiled form of a template.
 * Wraps a <tt>TemplateProcessor</tt>.
 */
public interface RuntimeStructuralElement extends TemplateProcessor {
    /**
     * Sets the statement delegate.
     *
     * @param statement a TemplateProcessor to be used as the statement delegate.
     */
	public void setStatement(TemplateProcessor statement);

    /**
     * Gets the statement delegate.
     *
     * @return the TemplateProcessor to be used as the statement delegate.
     */
	public TemplateProcessor getStatement();
}
