/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template;

import java.util.*;
import javax.servlet.ServletRequest;

/**
 * A class containing static utility methods to facilitate using
 * templates with servlets.
 *
 * @deprecated Use the classes in the <code>org.szegedi.expose.servlet</code>
 * package instead.
 */
public class TemplateServletUtils {

    /**
     * Copies the parameters from a <tt>ServletRequest</tt> into
     * a data model, in a hash called <tt>request</tt>.  Single
     * values are stored as <tt>SimpleScalars</tt>; multiple
     * values are stored as <tt>SimpleLists</tt> of
     * <tt>SimpleScalars</tt>.
     *
     * @param req the <tt>ServletRequest</tt> containing the
     * parameters to be saved.
     * @param modelRoot the root node of the data model.
     */
    public static void copyRequest(ServletRequest req,
		TemplateModelRoot modelRoot) {

		SimpleHash request = new SimpleHash();
		Enumeration paramNames = req.getParameterNames();
		while (paramNames.hasMoreElements()) {
			String paramName = (String)paramNames.nextElement();
			String [] paramValues = req.getParameterValues(paramName);
			if (paramValues.length == 1) {
				SimpleScalar valueScalar = new SimpleScalar(paramValues[0]);
				request.put(paramName, valueScalar);
			} else {
				SimpleList valueList = new SimpleList();
				for (int i = 0; i < paramValues.length; i++) {
					valueList.add(new SimpleScalar(paramValues[i]));
				}
				request.put(paramName, valueList);
			}
		}
		modelRoot.put("request", request);
    }

    /**
     * Copies the parameters from a <tt>ServletRequest</tt> into
     * an empty data model, in a hash called <tt>request</tt>.  Single
     * values are stored as <tt>SimpleScalars</tt>; multiple
     * values are stored as <tt>SimpleLists</tt> of
     * <tt>SimpleScalars</tt>.
     * 
     * @param req the <tt>ServletRequest</tt> containing the
     * parameters to be saved.
     * @return the resulting data model.
     */
    public static TemplateModelRoot copyRequest(ServletRequest req) {
		SimpleHash modelRoot = new SimpleHash();
		copyRequest(req, modelRoot);
		return modelRoot;
    }
}
